/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ACLAugment;
import ch.cern.ZKCheckElement;
import ch.cern.ZKClient;
import ch.cern.ZKDefaultQuery;
import ch.cern.ZKQuery;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;

public class ZKCheck {
    private ZKClient zk;
    private ZKDefaultQuery defaultQueries = new ZKDefaultQuery();
    private static Logger logger = LogManager.getLogger(ZKCheck.class);

    public ZKCheck(ZKClient zk) {
        this.zk = zk;
    }

    public void check(String rootPath, List<ZKCheckElement> checkElements, Hashtable<Integer, List<String>> checksOutput) throws KeeperException, InterruptedException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        ArrayList<ZKCheckElement> invalidChecks = new ArrayList<ZKCheckElement>();
        for (ZKCheckElement zkCheckElement : checkElements) {
            try {
                if (this.zk.exists(zkCheckElement.getRootPath(), null) != null) continue;
                checksOutput.get(zkCheckElement.hashCode()).add("The path " + zkCheckElement.getRootPath() + " does not exist.");
                invalidChecks.add(zkCheckElement);
            }
            catch (IllegalArgumentException e) {
                checksOutput.get(zkCheckElement.hashCode()).add("Invalid rootpath " + zkCheckElement.getRootPath() + " : " + e.getMessage());
                invalidChecks.add(zkCheckElement);
            }
        }
        for (ZKCheckElement zkQueryElement : invalidChecks) {
            zkQueryElement.$status = false;
            checkElements.remove(zkQueryElement);
        }
        if (checkElements.size() > 0) {
            this.checkIntPreOrder(rootPath, checkElements, checksOutput);
        }
    }

    private void checkIntPreOrder(String path, List<ZKCheckElement> checkElements, Hashtable<Integer, List<String>> checksOutput) throws KeeperException, InterruptedException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        List<String> children = null;
        List<ACL> znodeACLList = null;
        try {
            children = this.zk.getChildren(path, null);
            znodeACLList = this.zk.getACL(path, null);
        }
        catch (KeeperException.NoAuthException e) {
            logger.info("WARNING: No READ permission for " + path + ", skipping subtree");
        }
        for (ZKCheckElement zkCheckElement : checkElements) {
            Pattern pathPatternRegex = Pattern.compile(zkCheckElement.getPathPattern());
            Matcher currentMatcher = pathPatternRegex.matcher(path);
            if (!currentMatcher.matches()) continue;
            ZKQuery checkQuery = zkCheckElement.getNegate() != false ? this.defaultQueries.noSatisfyACL : this.defaultQueries.exactACL;
            if (checkQuery.query(znodeACLList, null, path, this.zk, zkCheckElement.getAcls())) {
                checksOutput.get(zkCheckElement.hashCode()).add(path + " : PASS");
                continue;
            }
            if (znodeACLList == null) {
                checksOutput.get(zkCheckElement.hashCode()).add(path + " : FAIL (No permission for subtree)");
            } else {
                checksOutput.get(zkCheckElement.hashCode()).add(path + " : FAIL (actual: " + ACLAugment.generateACLStringList(znodeACLList) + ")");
            }
            zkCheckElement.$status = false;
        }
        if (path.equals("/")) {
            path = "";
        }
        if (children == null) {
            return;
        }
        Collections.sort(children);
        for (String child : children) {
            this.checkIntPreOrder(path + "/" + child, checkElements, checksOutput);
        }
    }
}

