/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKConfig;
import ch.cern.ZKPolicyUtils;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZKClient
extends ZooKeeper {
    private Logger logger = LogManager.getLogger(ZKClient.class.getName());
    private String host;
    private int port;
    private ZKConfig zkpConfig;

    public String getHost() {
        return this.host;
    }

    public ZKConfig getZKPConfig() {
        return this.zkpConfig;
    }

    public int getPort() {
        return this.port;
    }

    public ZKClient(String connectString, int sessionTimeout) throws IOException {
        super(connectString, sessionTimeout, new Watcher(){

            @Override
            public void process(WatchedEvent event) {
            }
        });
        this.logger.info("Connecting to {} ...", (Object)connectString);
        ZKClient.waitUntilConnected(this);
        this.logger.info("Connection to {} complete", (Object)connectString);
    }

    public ZKClient(ZKConfig config) throws IOException {
        super(config.getZkServers(), config.getTimeout(), new Watcher(){

            @Override
            public void process(WatchedEvent event) {
            }
        });
        this.logger.debug("Connecting to one of {} ...", (Object)config.getZkServers());
        ZKClient.waitUntilConnected(this);
        this.zkpConfig = config;
        Pattern hostPortPattern = Pattern.compile("remoteserver:.*?/(.+?):(\\d+)");
        Matcher matches = hostPortPattern.matcher(this.toString());
        if (matches.find()) {
            this.host = matches.group(1);
            this.port = Integer.parseInt(matches.group(2));
        }
        this.logger.debug("Connection to {} complete", (Object)(this.host + ":" + this.port));
    }

    private static void waitUntilConnected(ZooKeeper zooKeeper) {
        CountDownLatch connectedLatch = new CountDownLatch(1);
        ZKPolicyUtils.ConnectedWatcher watcher = new ZKPolicyUtils.ConnectedWatcher(connectedLatch);
        zooKeeper.register(watcher);
        if (ZooKeeper.States.CONNECTING == zooKeeper.getState()) {
            try {
                connectedLatch.await();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

