/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKClient;
import ch.cern.ZKRollbackElement;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.zookeeper.KeeperException;

public class ZKRollbackSet {
    private List<ZKRollbackElement> elements = new ArrayList<ZKRollbackElement>();
    private File $outputFile;

    public ZKRollbackSet(File policyConfigFile) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper om = new ObjectMapper(new YAMLFactory());
        om.readerForUpdating(this).readValue(policyConfigFile);
    }

    public void setOutputFile(File rollbackStateFile) {
        this.$outputFile = rollbackStateFile;
    }

    public void exportToYAML() {
        try {
            ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
            mapper.writeValue(this.$outputFile, (Object)this);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void enforceRollback(ZKClient zk) throws KeeperException, InterruptedException {
        for (ZKRollbackElement zkRollbackElement : this.elements) {
            try {
                zk.setACL(zkRollbackElement.getPath(), zkRollbackElement.getAcl(), -1);
            }
            catch (KeeperException.NoNodeException e) {
                System.out.println(e.toString());
            }
        }
    }

    @Generated
    public List<ZKRollbackElement> getElements() {
        return this.elements;
    }

    @Generated
    public void setElements(List<ZKRollbackElement> elements) {
        this.elements = elements;
    }

    @Generated
    public ZKRollbackSet() {
    }

    @Generated
    protected ZKRollbackSet(List<ZKRollbackElement> elements) {
        this.elements = elements;
    }
}

