/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKClient;
import ch.cern.ZKConfig;
import ch.cern.ZKEnforce;
import ch.cern.ZKEnforcePolicyElement;
import ch.cern.ZKEnforcePolicySet;
import ch.cern.ZKPolicyCli;
import ch.cern.ZKQueryCli;
import ch.cern.ZKQueryElement;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="enforce", aliases={"f"}, description={"Enforce policy on znodes"}, helpCommand=true, mixinStandardHelpOptions=true)
public class ZKEnforceCli
implements Runnable {
    private static Logger logger = LogManager.getLogger(ZKEnforceCli.class);
    @CommandLine.ParentCommand
    private ZKPolicyCli parent;
    @CommandLine.Option(names={"-r", "--rollback-export"}, required=false, description={"File to save pre-enforce state of altered znodes for rollback (default: /opt/zkpolicy/rollback/ROLLBACK_STATE_<DATETIME>.yml)"})
    File rollbackStateFile;
    @CommandLine.Option(names={"-d", "--dry-run"}, required=false, description={"Execute enforce in dry-run (show affected nodes without applying changes)"})
    boolean dryRun = false;
    @CommandLine.ArgGroup(exclusive=true, multiplicity="1")
    Exclusive exclusive;

    @Override
    public void run() {
        try {
            if (this.exclusive.fileEnforceGroup == null && this.exclusive.serviceEnforceGroup == null) {
                this.cliEnforce();
            } else if (this.exclusive.cliEnforceGroup == null && this.exclusive.serviceEnforceGroup == null) {
                this.cliEnforceFromFile(this.exclusive.fileEnforceGroup.policiesFile);
            } else if (this.exclusive.cliEnforceGroup == null && this.exclusive.fileEnforceGroup == null) {
                for (String servicePolicy : this.exclusive.serviceEnforceGroup.services) {
                    File policiesFile = new File(this.exclusive.serviceEnforceGroup.servicePoliciesDir.toString() + "/" + servicePolicy + ".yml");
                    this.cliEnforceFromFile(policiesFile);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
    }

    private void cliEnforce() throws JsonParseException, JsonMappingException, IOException {
        ZKConfig config = new ZKConfig(this.parent.configFile);
        try (ZKClient zk = new ZKClient(config);){
            ZKQueryElement query = new ZKQueryElement();
            query.setName(this.exclusive.cliEnforceGroup.queryName);
            query.setArgs(this.exclusive.cliEnforceGroup.queryArgs);
            query.setRootPath(this.exclusive.cliEnforceGroup.rootPath);
            ZKEnforcePolicyElement policy = new ZKEnforcePolicyElement();
            policy.setQuery(query);
            policy.setAppend(this.exclusive.cliEnforceGroup.append);
            policy.setAcls(this.exclusive.cliEnforceGroup.policies);
            if (this.dryRun) {
                ZKEnforce zkEnforce = new ZKEnforce(zk);
                zkEnforce.enforceDry(policy);
            } else {
                if (this.rollbackStateFile == null) {
                    DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH:mm:ss");
                    LocalDateTime now = LocalDateTime.now();
                    this.rollbackStateFile = new File("/opt/zkpolicy/rollback/ROLLBACK_STATE_" + dtf.format(now) + ".yml");
                }
                ZKEnforce zkEnforce = new ZKEnforce(zk, this.rollbackStateFile);
                zkEnforce.enforce(policy);
            }
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            System.out.println("No such method: " + this.exclusive.cliEnforceGroup.queryName);
            System.out.println("Please consult the list of default queries using query -h");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
    }

    private void cliEnforceFromFile(File policiesFile) throws JsonParseException, JsonMappingException, IOException {
        ZKConfig config = new ZKConfig(this.parent.configFile);
        try (ZKClient zk = new ZKClient(config);){
            ZKEnforcePolicySet policySet = new ZKEnforcePolicySet(policiesFile);
            List<ZKEnforcePolicyElement> policies = policySet.getPolicies();
            for (ZKEnforcePolicyElement policy : policies) {
                ZKEnforce zkEnforce;
                if (this.dryRun) {
                    zkEnforce = new ZKEnforce(zk);
                    System.out.println(policy.getTitle());
                    zkEnforce.enforceDry(policy);
                    System.out.print("\n");
                    continue;
                }
                if (this.rollbackStateFile == null) {
                    DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH:mm:ss");
                    LocalDateTime now = LocalDateTime.now();
                    this.rollbackStateFile = new File("/opt/zkpolicy/rollback/ROLLBACK_STATE_" + dtf.format(now) + ".yml");
                }
                zkEnforce = new ZKEnforce(zk, this.rollbackStateFile);
                zkEnforce.enforce(policy);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
    }

    static class DefaultQueryCandidates
    extends ArrayList<String> {
        private static final long serialVersionUID = 1L;

        DefaultQueryCandidates() {
            super(Arrays.asList(new String[0]));
            this.add("%n * kafka");
            this.add("%n * hbase");
            this.add("%n * hive");
            this.add("%n * ooozie");
            this.add("%n * yarn");
            this.add("%n * hdfs");
            Collections.sort(this);
        }
    }

    static class Exclusive {
        @CommandLine.ArgGroup(exclusive=false)
        FileEnforceGroup fileEnforceGroup;
        @CommandLine.ArgGroup(exclusive=false)
        CliEnforceGroup cliEnforceGroup;
        @CommandLine.ArgGroup(exclusive=false)
        ServiceEnforceGroup serviceEnforceGroup;

        Exclusive() {
        }
    }

    static class CliEnforceGroup {
        @CommandLine.Option(names={"-P", "--policy"}, required=true, description={"Policies to enforce on matching nodes"})
        List<String> policies;
        @CommandLine.Parameters(paramLabel="[QUERY_NAME]", description={"Query to be executed: ${COMPLETION-CANDIDATES}"}, completionCandidates=ZKQueryCli.DefaultQueryCandidates.class)
        String queryName;
        @CommandLine.Option(names={"-p", "--root-path"}, required=false, description={"Root path to execute query before applying policy"})
        String rootPath;
        @CommandLine.Option(names={"-a", "--args"}, required=false, description={"Query arguments"})
        List<String> queryArgs;
        @CommandLine.Option(names={"-A", "--append"}, required=false, description={"Append policy ACLs to matching znode's ACL (default: false)"})
        boolean append = false;

        CliEnforceGroup() {
        }
    }

    static class ServiceEnforceGroup {
        @CommandLine.Option(names={"-s", "--service-policy"}, required=true, description={"Enforce default policy for a specific service. Available services: ${COMPLETION-CANDIDATES}"}, completionCandidates=DefaultQueryCandidates.class, arity="1..*")
        List<String> services;
        @CommandLine.Option(names={"-D", "--service-policies-dir"}, required=false, description={"Directory for service policies"}, defaultValue="/opt/zkpolicy/conf/policies/")
        File servicePoliciesDir;

        ServiceEnforceGroup() {
        }
    }

    static class FileEnforceGroup {
        @CommandLine.Option(names={"-i", "--input"}, required=true, description={"File with policy definitions to enforce"}, defaultValue="/opt/zkpolicy/conf/enforce.yml")
        File policiesFile;

        FileEnforceGroup() {
        }
    }
}

