/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ZKPattern {
    public static List<Pattern> createGlobPatternList(List<String> globStringList) {
        ArrayList<Pattern> queryPatternList = new ArrayList<Pattern>();
        for (String queryGlob : globStringList) {
            String regexFromGlob = ZKPattern.globToRegex(queryGlob);
            Pattern patternRegex = Pattern.compile(regexFromGlob);
            queryPatternList.add(patternRegex);
        }
        return queryPatternList;
    }

    public static List<Pattern> createRegexPatternList(List<String> regexStringList) {
        ArrayList<Pattern> queryPatternList = new ArrayList<Pattern>();
        for (String queryRegEx : regexStringList) {
            Pattern patternRegex = Pattern.compile(queryRegEx);
            queryPatternList.add(patternRegex);
        }
        return queryPatternList;
    }

    private static String globToRegex(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length());
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append('\\');
                            sb.append('\\');
                            break;
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    if (inClass == 0) {
                        sb.append(".*");
                        continue block16;
                    }
                    sb.append('*');
                    continue block16;
                }
                case '?': {
                    if (inClass == 0) {
                        sb.append('.');
                        continue block16;
                    }
                    sb.append('?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        continue block16;
                    }
                    sb.append('!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        continue block16;
                    }
                    sb.append(',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

