/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKClient;
import ch.cern.ZKConfig;
import ch.cern.ZKPolicyCli;
import ch.cern.ZKRollbackSet;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="rollback", aliases={"r"}, description={"Rollback ACLs to pre enforce state"}, helpCommand=true, mixinStandardHelpOptions=true)
public class ZKRollbackCli
implements Runnable {
    private static Logger logger = LogManager.getLogger(ZKRollbackCli.class);
    @CommandLine.ParentCommand
    private ZKPolicyCli parent;
    @CommandLine.Option(names={"-i", "--input"}, required=true, description={"File with ZooKeeper tree state before enforcing"})
    File inputStateFile;

    @Override
    public void run() {
        ZKConfig config = null;
        try {
            config = new ZKConfig(this.parent.configFile);
        }
        catch (IOException e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
        if (config != null) {
            try (ZKClient zk = new ZKClient(config);){
                ZKRollbackSet rollbackSet = new ZKRollbackSet(this.inputStateFile);
                rollbackSet.enforceRollback(zk);
            }
            catch (Exception e) {
                System.out.println(e.toString());
                logger.error("Exception occurred!", (Throwable)e);
            }
        }
    }
}

