/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKClient;
import ch.cern.ZKConfig;
import ch.cern.ZKPolicyCli;
import ch.cern.ZKQuery;
import ch.cern.ZKQueryElement;
import ch.cern.ZKTree;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.zookeeper.data.ACL;
import picocli.CommandLine;

@CommandLine.Command(name="tree", aliases={"t"}, description={"Visualize znode tree"}, helpCommand=true, mixinStandardHelpOptions=true)
public class ZKTreeCli
implements Runnable {
    private static Logger logger = LogManager.getLogger(ZKTreeCli.class);
    @CommandLine.ParentCommand
    private ZKPolicyCli parent;
    @CommandLine.Option(names={"-p", "--root-path"}, required=true, description={"Root path of requested subtree"})
    String rootPath;

    @Override
    public void run() {
        ZKTree zktree = null;
        Hashtable<Integer, List<String>> queriesOutput = new Hashtable<Integer, List<String>>();
        ArrayList<ZKQueryElement> queriesList = new ArrayList<ZKQueryElement>();
        TreeAlwaysTrueQuery query = new TreeAlwaysTrueQuery();
        ZKQueryElement queryElement = new ZKQueryElement("treeAlwaysTrueQuery", this.rootPath, null, query);
        queriesList.add(queryElement);
        queriesOutput.put(queryElement.hashCode(), new ArrayList());
        ZKConfig config = null;
        try {
            config = new ZKConfig(this.parent.configFile);
            config.setMatchColor("WHITE");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
        if (config != null) {
            try (ZKClient zk = new ZKClient(config);){
                zktree = new ZKTree(zk);
                zktree.queryTree(queryElement.getRootPath(), queriesList, queriesOutput);
            }
            catch (Exception e) {
                System.out.println(e.toString());
                logger.error("Exception occurred!", (Throwable)e);
            }
            System.out.println(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)queriesOutput.get(queryElement.hashCode())) + "\n");
        }
    }

    private static class TreeAlwaysTrueQuery
    implements ZKQuery {
        private TreeAlwaysTrueQuery() {
        }

        @Override
        public String getDescription() {
            return "Query matching every node of a subtree";
        }

        @Override
        public boolean query(List<ACL> aclList, List<ACL> parentAclList, String path, ZKClient zk, List<String> queryACLs) {
            return true;
        }
    }
}

