/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import java.util.Iterator;
import java.util.List;
import lombok.Generated;

public class ZKCheckElement {
    private String title;
    private String rootPath;
    private String pathPattern;
    private Boolean negate;
    List<String> acls;
    public boolean $status = true;

    public String generateDescription() {
        StringBuffer outputBuf = new StringBuffer();
        if (this.negate.booleanValue()) {
            outputBuf.append(String.format("Check if znodes under %s with paths matching the %s pattern are not accessible by clients with the following authentication credentials:", this.rootPath, this.pathPattern) + "\n");
        } else {
            outputBuf.append(String.format("Check if znodes under %s with paths matching the %s pattern have the following ACL definition set:", this.rootPath, this.pathPattern) + "\n");
        }
        Iterator<String> aclIterator = this.acls.iterator();
        while (aclIterator.hasNext()) {
            String acl = aclIterator.next();
            outputBuf.append("- " + acl);
            if (!aclIterator.hasNext()) continue;
            outputBuf.append("\n");
        }
        return outputBuf.toString();
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getRootPath() {
        return this.rootPath;
    }

    @Generated
    public String getPathPattern() {
        return this.pathPattern;
    }

    @Generated
    public Boolean getNegate() {
        return this.negate;
    }

    @Generated
    public List<String> getAcls() {
        return this.acls;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    @Generated
    public void setPathPattern(String pathPattern) {
        this.pathPattern = pathPattern;
    }

    @Generated
    public void setNegate(Boolean negate) {
        this.negate = negate;
    }

    @Generated
    public void setAcls(List<String> acls) {
        this.acls = acls;
    }

    @Generated
    public ZKCheckElement() {
    }

    @Generated
    protected ZKCheckElement(String title, String rootPath, String pathPattern, Boolean negate, List<String> acls) {
        this.title = title;
        this.rootPath = rootPath;
        this.pathPattern = pathPattern;
        this.negate = negate;
        this.acls = acls;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZKCheckElement)) {
            return false;
        }
        ZKCheckElement other = (ZKCheckElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$rootPath = this.getRootPath();
        String other$rootPath = other.getRootPath();
        if (this$rootPath == null ? other$rootPath != null : !this$rootPath.equals(other$rootPath)) {
            return false;
        }
        String this$pathPattern = this.getPathPattern();
        String other$pathPattern = other.getPathPattern();
        if (this$pathPattern == null ? other$pathPattern != null : !this$pathPattern.equals(other$pathPattern)) {
            return false;
        }
        Boolean this$negate = this.getNegate();
        Boolean other$negate = other.getNegate();
        if (this$negate == null ? other$negate != null : !((Object)this$negate).equals(other$negate)) {
            return false;
        }
        List<String> this$acls = this.getAcls();
        List<String> other$acls = other.getAcls();
        return !(this$acls == null ? other$acls != null : !((Object)this$acls).equals(other$acls));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ZKCheckElement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $rootPath = this.getRootPath();
        result = result * 59 + ($rootPath == null ? 43 : $rootPath.hashCode());
        String $pathPattern = this.getPathPattern();
        result = result * 59 + ($pathPattern == null ? 43 : $pathPattern.hashCode());
        Boolean $negate = this.getNegate();
        result = result * 59 + ($negate == null ? 43 : ((Object)$negate).hashCode());
        List<String> $acls = this.getAcls();
        result = result * 59 + ($acls == null ? 43 : ((Object)$acls).hashCode());
        return result;
    }
}

