/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import lombok.Generated;

public class ZKConfig {
    private String zkServers;
    private int timeout;
    private String matchColor;
    private String mismatchColor;
    private String jaas;

    public ZKConfig(File configFile) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory());
        om.readerForUpdating((Object)this).readValue(configFile);
        this.setPropertyJaas();
    }

    public void setPropertyJaas() {
        if (this.jaas != null && !this.jaas.isEmpty()) {
            System.setProperty("java.security.auth.login.config", this.jaas);
        }
    }

    @Generated
    public String getZkServers() {
        return this.zkServers;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getMatchColor() {
        return this.matchColor;
    }

    @Generated
    public String getMismatchColor() {
        return this.mismatchColor;
    }

    @Generated
    public String getJaas() {
        return this.jaas;
    }

    @Generated
    public void setZkServers(String zkServers) {
        this.zkServers = zkServers;
    }

    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setMatchColor(String matchColor) {
        this.matchColor = matchColor;
    }

    @Generated
    public void setMismatchColor(String mismatchColor) {
        this.mismatchColor = mismatchColor;
    }

    @Generated
    public void setJaas(String jaas) {
        this.jaas = jaas;
    }

    @Generated
    public ZKConfig() {
    }

    @Generated
    protected ZKConfig(String zkServers, int timeout, String matchColor, String mismatchColor, String jaas) {
        this.zkServers = zkServers;
        this.timeout = timeout;
        this.matchColor = matchColor;
        this.mismatchColor = mismatchColor;
        this.jaas = jaas;
    }
}

