/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKAudit;
import ch.cern.ZKAuditSet;
import ch.cern.ZKClient;
import ch.cern.ZKConfig;
import ch.cern.ZKPolicyCli;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="audit", aliases={"a"}, description={"Generate full audit report"}, mixinStandardHelpOptions=true)
public class ZKAuditCli
implements Runnable {
    private static Logger logger = LogManager.getLogger(ZKAuditCli.class);
    @CommandLine.ParentCommand
    private ZKPolicyCli parent;
    @CommandLine.Option(names={"-o", "--output"}, required=false, description={"Audit report output file"})
    File outputFile = null;
    @CommandLine.Option(names={"-i", "--input"}, required=false, description={"Audit report configuration file (default: ${DEFAULT-VALUE})"}, defaultValue="/opt/zkpolicy/conf/audit.yml")
    File auditConfigFile;
    ZKConfig config;
    ZKClient zk;

    @Override
    public void run() {
        OutputStreamWriter writer = null;
        String outputString = "";
        try {
            ZKAudit zkAudit = null;
            this.config = new ZKConfig(this.parent.configFile);
            try (ZKClient zk = new ZKClient(this.config);){
                this.zk = zk;
                zkAudit = new ZKAudit(zk, this.auditConfigFile);
                ZKAuditSet.ZKPolicyReportSections sections = zkAudit.getZkAuditSet().getSections();
                if (sections.isGeneralInformation()) {
                    outputString = outputString + this.addZKHeader();
                    outputString = outputString + "\n===============================================\n";
                }
                if (sections.isFourLetterWordCommands()) {
                    outputString = outputString + zkAudit.getFourLetterWordOverview();
                    outputString = outputString + "\n===============================================\n";
                }
                if (sections.isQueryResults()) {
                    outputString = outputString + zkAudit.generateQueriesSection();
                    outputString = outputString + "\n===============================================\n";
                }
                if (sections.isCheckResults()) {
                    outputString = outputString + zkAudit.generateChecksSection();
                    outputString = outputString + "\n===============================================\n";
                }
                if (sections.isAclOverview()) {
                    outputString = outputString + zkAudit.getACLOverview();
                }
            }
            catch (Exception e) {
                System.out.println(e.toString());
                logger.error("Exception occurred!", (Throwable)e);
            }
            OutputStream writerStream = this.outputFile != null ? new FileOutputStream(this.outputFile) : System.out;
            writer = new OutputStreamWriter(writerStream, "UTF-8");
            writer.write(outputString);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
    }

    private String addZKHeader() throws Exception {
        String headerOut = "";
        ZKPolicyCli.PropertiesVersionProvider versionProvider = new ZKPolicyCli.PropertiesVersionProvider();
        headerOut = headerOut + "ZKPolicy v" + versionProvider.getVersion()[0] + " Audit report\n";
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss Z", Locale.getDefault());
        Date date = new Date();
        headerOut = headerOut + "DateTime: " + dateFormat.format(date) + "\n";
        headerOut = headerOut + "Report results for file: " + this.auditConfigFile.getCanonicalPath() + "\n";
        headerOut = headerOut + "Connected to ZooKeeper server: " + this.zk.getHost() + ":" + this.zk.getPort() + "\n";
        return headerOut;
    }
}

