/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ACLAugment;
import ch.cern.ZKClient;
import ch.cern.ZKDefaultQuery;
import ch.cern.ZKEnforcePolicyElement;
import ch.cern.ZKQuery;
import ch.cern.ZKQueryElement;
import ch.cern.ZKRollbackElement;
import ch.cern.ZKRollbackSet;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;

public class ZKEnforce {
    private ZKClient zk;
    private ZKDefaultQuery zkDefaultQuery = new ZKDefaultQuery();
    private ZKRollbackSet rollbackSet = new ZKRollbackSet();

    public ZKEnforce(ZKClient zk) {
        this.zk = zk;
    }

    public ZKEnforce(ZKClient zk, File rollbackStateFile) {
        this.zk = zk;
        this.rollbackSet.setOutputFile(rollbackStateFile);
    }

    public void enforceDry(ZKEnforcePolicyElement policy) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, KeeperException, InterruptedException, NoSuchFieldException {
        ZKQueryElement queryElement = policy.getQuery();
        if (this.zk.exists(queryElement.getRootPath(), null) == null) {
            System.out.println("The path " + queryElement.getRootPath() + " does not exist.");
            return;
        }
        ZKDefaultQuery zkDefaultQuery = new ZKDefaultQuery();
        ZKQuery query = zkDefaultQuery.getValueOf(queryElement.getName());
        this.enforceInnerDry(queryElement.getRootPath(), query, queryElement.getArgs());
    }

    public void enforce(ZKEnforcePolicyElement policy) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InterruptedException, KeeperException, NoSuchFieldException {
        ZKQueryElement queryElement = policy.getQuery();
        if (this.zk.exists(queryElement.getRootPath(), null) == null) {
            System.out.println("The path " + queryElement.getRootPath() + " does not exist.");
            return;
        }
        ArrayList<ACL> policiesACL = new ArrayList<ACL>();
        for (String policyACLString : policy.getAcls()) {
            policiesACL.add(new ACLAugment(policyACLString).getACL());
        }
        ZKQuery query = this.zkDefaultQuery.getValueOf(queryElement.getName());
        this.enforceInner(policiesACL, queryElement.getRootPath(), query, queryElement.getArgs(), policy.isAppend());
        this.rollbackSet.exportToYAML();
    }

    private void enforceInnerDry(String path, ZKQuery query, List<String> queryACLs) throws InterruptedException, KeeperException {
        List znodeACLList = null;
        List children = null;
        try {
            znodeACLList = this.zk.getACL(path, null);
            children = this.zk.getChildren(path, null);
        }
        catch (KeeperException e) {
            System.out.println("WARNING: No READ permission for " + path + ", skipping subtree");
            return;
        }
        if (query.query(znodeACLList, null, path, this.zk, queryACLs)) {
            System.out.println(path);
        }
        if (path.equals("/")) {
            path = "";
        }
        Collections.sort(children);
        for (String child : children) {
            this.enforceInnerDry(path + "/" + child, query, queryACLs);
        }
    }

    private void enforceInner(List<ACL> policies, String path, ZKQuery query, List<String> queryACLs, boolean append) throws KeeperException, InterruptedException {
        List znodeACLList = null;
        List children = null;
        ArrayList<ACL> newACLList = new ArrayList<ACL>();
        try {
            znodeACLList = this.zk.getACL(path, null);
            children = this.zk.getChildren(path, null);
        }
        catch (KeeperException e) {
            System.out.println("WARNING: No READ permission for " + path + ", skipping subtree");
            return;
        }
        if (query.query(znodeACLList, null, path, this.zk, queryACLs)) {
            if (append) {
                newACLList.addAll(znodeACLList);
            }
            for (ACL policyACL : policies) {
                newACLList.add(policyACL);
            }
            this.zk.setACL(path, newACLList, -1);
            this.rollbackSet.getElements().add(new ZKRollbackElement(path, znodeACLList));
        }
        if (path.equals("/")) {
            path = "";
        }
        Collections.sort(children);
        for (String child : children) {
            this.enforceInner(policies, path + "/" + child, query, queryACLs, append);
        }
    }
}

