/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZKConfig {
    private static Logger logger = LogManager.getLogger(ZKConfig.class);
    private String zkServers;
    private int timeout;
    private String matchColor;
    private String mismatchColor;
    private String jaas;

    public ZKConfig(File configFile) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory());
        om.readerForUpdating((Object)this).readValue(configFile);
        this.setPropertyJaas();
    }

    public void setPropertyJaas() {
        if (System.getProperty("java.security.auth.login.config") != null && !System.getProperty("java.security.auth.login.config").isEmpty()) {
            logger.info("JAAS configuration file {} used for ZooKeeper Authentication", (Object)System.getProperty("java.security.auth.login.config"));
            return;
        }
        if (this.jaas != null && !this.jaas.isEmpty()) {
            System.setProperty("java.security.auth.login.config", this.jaas);
            logger.info("JAAS configuration file {} used for ZooKeeper Authentication", (Object)this.jaas);
            return;
        }
    }

    @Generated
    public String getZkServers() {
        return this.zkServers;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getMatchColor() {
        return this.matchColor;
    }

    @Generated
    public String getMismatchColor() {
        return this.mismatchColor;
    }

    @Generated
    public String getJaas() {
        return this.jaas;
    }

    @Generated
    public void setZkServers(String zkServers) {
        this.zkServers = zkServers;
    }

    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setMatchColor(String matchColor) {
        this.matchColor = matchColor;
    }

    @Generated
    public void setMismatchColor(String mismatchColor) {
        this.mismatchColor = mismatchColor;
    }

    @Generated
    public void setJaas(String jaas) {
        this.jaas = jaas;
    }

    @Generated
    public ZKConfig() {
    }

    @Generated
    protected ZKConfig(String zkServers, int timeout, String matchColor, String mismatchColor, String jaas) {
        this.zkServers = zkServers;
        this.timeout = timeout;
        this.matchColor = matchColor;
        this.mismatchColor = mismatchColor;
        this.jaas = jaas;
    }
}

