/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import lombok.Generated;

public class ZKPolicyDefs {

    static interface TerminalConstants {
        public static final String lastChildIndent = "\u2514\u2500\u2500\u2500 ";
        public static final String innerChildIndent = "\u251c\u2500\u2500\u2500 ";
        public static final String lastParentIndent = "      ";
        public static final String innerParentIndent = "\u2502     ";
        public static final int indentStepLength = "\u2514\u2500\u2500\u2500 ".length();
        public static final String sectionSeparator = "\n===============================================\n";
        public static final String subSectionSeparator = "---------------------------------------------------------------------";
    }

    static class Query {
        static final String DESCRIPTION_FORMAT = "Znodes under %s that satisfy the %s query";

        Query() {
        }
    }

    static class Check {
        static final String DESCRIPTION_FORMAT = "Check if znodes under %s with paths matching the %s pattern have the following ACL definition set:";
        static final String NEGATE_DESCRIPTION_FORMAT = "Check if znodes under %s with paths matching the %s pattern are not accessible by clients with the following authentication credentials:";

        Check() {
        }
    }

    static class Queries {
        static final String EXACT_ACL_DESCRIPTION = "Match znodes with ACL equal to the passed ACL argument";
        static final String NO_ACL_DESCRIPTION = "Match znodes with no access control restrictions (ACL equals [world:anyone:cdrwa])";
        static final String SATISFY_ACL_DESCRIPTION = "Match znodes that are accessible by clients with the passed authentication info arguments (logical match)";
        static final String NO_SATISFY_ACL_DESCRIPTION = "Match znodes that are not accessible by clients with the passed authentication info arguments";
        static final String PARENT_YES_CHILD_NO_DESCRIPTION = "Match znodes with ACL not equal to their parent's ACL";
        static final String DUPLICATE_ACL_DESCRIPTION = "Match znodes with duplicate ACL entries";
        static final String REGEX_MATCH_ACL_DESCRIPTION = "Match znodes with ACL entries matching the passed regular expression arguments";
        static final String GLOB_MATCH_ACL_DESCRIPTION = "Match znodes with ACL entries matching the passed glob pattern arguments";
        static final String GLOB_MATCH_PATH_DESCRIPTION = "Match znodes with paths matching the passed glob pattern argument";
        static final String REGEX_MATCH_PATH_DESCRIPTION = "Match znodes with paths matching the passed regular expression argument";

        Queries() {
        }
    }

    static class Cli {
        Cli() {
        }

        static class Rollback {
            static final String DESCRIPTION = "Rollback ACLs to pre enforce state";
            static final String INPUT_STATE_DESCRIPTION = "File with ZooKeeper tree state before enforcing";

            Rollback() {
            }
        }

        static class Tree {
            static final String DESCRIPTION = "Visualize znode tree";
            static final String ROOT_PATH_DESCRIPTION = "Root path of requested subtree";

            Tree() {
            }
        }

        static class Query {
            static final String DESCRIPTION = "Query the znode tree";
            static final String QUERY_NAME_DESCRIPTION = "Query to be executed: ${COMPLETION-CANDIDATES}";
            static final String ROOT_PATH_DESCRIPTION = "Query execution root path";
            static final String ARGS_DESCRIPTION = "Query arguments";
            static final String DESCR_DESCRIPTION = "Include query description in output (default: disabled)";
            static final String COLOR_DESCR_DESCRIPTION = "Include color description in output (default: disabled)";
            static final String LIST_DESCRIPTION = "Return list with query matching znode paths (default: disabled)";

            Query() {
            }
        }

        static class Export {
            static final String DESCRIPTION = "Export the znode tree";
            static final String TYPE_DESCRIPTION = "Output file format ${COMPLETION-CANDIDATES} (default: json)";
            static final String COMPACT_DESCRIPTION = "Minified export (default: false)";
            static final String OUTPUT_DESCRIPTION = "Output file destination";
            static final String OUTPUT_DEFAULT = "./zkpolicy_export.out";
            static final String ROOT_PATH_DESCRIPTION = "Root path for exported subtree";

            Export() {
            }
        }

        static class Enforce {
            static final String DESCRIPTION = "Enforce policy on znodes";
            static final String INPUT_DESCRIPTION = "File with policy definitions to enforce";
            static final String INPUT_DEFAULT = "/opt/zkpolicy/conf/enforce.yml";
            static final String POLICY_DESCRIPTION = "Policies to enforce on matching nodes";
            static final String QUERY_NAME_DESCRIPTION = "Query to be executed: ${COMPLETION-CANDIDATES}";
            static final String ROOT_PATH_DESCRIPTION = "Root path to execute query before applying policy";
            static final String ARGS_DESCRIPTION = "Query arguments";
            static final String APPEND_DESCRIPTION = "Append policy ACLs to matching znode's ACL (default: false)";
            static final String DRY_RUN_DESCRIPTION = "Execute enforce in dry-run (show affected nodes without applying changes)";
            static final String ROLLBACK_EXPORT_DESCRIPTION = "File to save pre-enforce state of altered znodes for rollback (default: /opt/zkpolicy/rollback/ROLLBACK_STATE_<DATETIME>.yml)";
            static final String SERVICE_POLICY_DESCRIPTION = "Enforce default policy for a specific service. Available services: ${COMPLETION-CANDIDATES}";
            static final String SERVICE_POLICIES_DIR_DESCRIPTION = "Directory for service policies";
            static final String SERVICE_POLICIES_DIR_DEFAULT = "/opt/zkpolicy/conf/policies/";

            Enforce() {
            }
        }

        static class Check {
            static final String DESCRIPTION = "Check specific znodes for ACL match";
            static final String ROOT_PATH_DESCRIPTION = "Root path to execute query";
            static final String PATH_PATTERN_DESCRIPTION = "Path pattern that must be satisfied to check node";
            static final String ACLS_DESCRIPTION = "ACLs for checking against matching znodes";
            static final String DESCR_DESCRIPTION = "Include check description in output (default: disabled)";
            static final String NEGATE_DESCRIPTION = "Negate result by checking if passed ACLs are not satisfying znode ACL (default: disabled)";

            Check() {
            }
        }

        static class Audit {
            static final String DESCRIPTION = "Generate full audit report";
            static final String INPUT_DESCRIPTION = "Audit report configuration file (default: ${DEFAULT-VALUE})";
            static final String INPUT_DEFAULT = "/opt/zkpolicy/conf/audit.yml";
            static final String OUTPUT_DESCRIPTION = "Audit report output file";

            Audit() {
            }
        }

        static class ZkPolicy {
            static final String DESCRIPTION = "ZooKeeper policy auditing tool";
            static final String CONFIG_DESCRIPTION = "YAML configuration file to use (default: ${DEFAULT-VALUE})";
            static final String CONFIG_DEFAULT = "/opt/zkpolicy/conf/config.yml";
            static final String JAAS_FILE_DESCRIPTION = "JAAS file to be used during ZooKeeper authentication";

            ZkPolicy() {
            }
        }
    }

    static enum Schemes {
        WORLD("world"),
        AUTH("auth"),
        IP("ip"),
        SASL("sasl"),
        DIGEST("digest");

        private String schemeValue;

        public static boolean includes(String value) {
            for (Schemes enumElement : Schemes.values()) {
                if (!enumElement.getSchemeValue().equals(value)) continue;
                return true;
            }
            return false;
        }

        @Generated
        private Schemes(String schemeValue) {
            this.schemeValue = schemeValue;
        }

        @Generated
        public String getSchemeValue() {
            return this.schemeValue;
        }
    }

    static enum FourLetterWords {
        CONF("conf"),
        CONS("cons"),
        CRST("crst"),
        DIRS("dirs"),
        DUMP("dump"),
        ENVI("envi"),
        GTMK("gtmk"),
        RUOK("ruok"),
        STMK("stmk"),
        SRST("srst"),
        SRVR("srvr"),
        STAT("stat"),
        WCHC("wchc"),
        WCHP("wchp"),
        WCHS("wchs"),
        MNTR("mntr"),
        ISRO("isro"),
        HASH("hash");

        private String command;

        @Generated
        private FourLetterWords(String command) {
            this.command = command;
        }

        @Generated
        public String getCommand() {
            return this.command;
        }
    }

    static enum Colors {
        BLACK("\u001b[30m"),
        RED("\u001b[31m"),
        GREEN("\u001b[32m"),
        YELLOW("\u001b[33m"),
        BLUE("\u001b[34m"),
        MAGENTA("\u001b[35m"),
        CYAN("\u001b[36m"),
        WHITE("\u001b[37m"),
        RESET("\u001b[0m");

        private String ANSIValue;

        @Generated
        private Colors(String ANSIValue) {
            this.ANSIValue = ANSIValue;
        }

        @Generated
        public String getANSIValue() {
            return this.ANSIValue;
        }
    }

    static enum CheckResults {
        pass,
        fail,
        invalidRootPath,
        notExistingRootPath;

    }

    static enum ExportFormats {
        json,
        yaml;

    }
}

