/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKCheck;
import ch.cern.ZKCheckElement;
import ch.cern.ZKClient;
import ch.cern.ZKConfig;
import ch.cern.ZKPolicyCli;
import ch.cern.ZKPolicyDefs;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="check", aliases={"c"}, description={"Check specific znodes for ACL match"}, helpCommand=true, mixinStandardHelpOptions=true)
public class ZKCheckCli
implements Runnable {
    private static Logger logger = LogManager.getLogger(ZKCheckCli.class);
    @CommandLine.ParentCommand
    private ZKPolicyCli parent;
    @CommandLine.Option(names={"-p", "--root-path"}, required=true, description={"Root path to execute query"})
    String rootPath;
    @CommandLine.Option(names={"-e", "--path-pattern"}, required=true, description={"Path pattern that must be satisfied to check node"})
    String pathPattern;
    @CommandLine.Option(names={"-a", "--acls"}, required=true, description={"ACLs for checking against matching znodes"}, arity="1..*")
    List<String> checkACLs;
    @CommandLine.Option(names={"-n", "--negate"}, description={"Negate result by checking if passed ACLs are not satisfying znode ACL (default: disabled)"})
    Boolean negate = false;
    @CommandLine.Option(names={"-D", "--description"}, description={"Include check description in output (default: disabled)"})
    Boolean description = false;

    @Override
    public void run() {
        ZKConfig config = null;
        try {
            config = new ZKConfig(this.parent.configFile);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
        if (config != null) {
            try (ZKClient zk = new ZKClient(config);){
                StringBuffer outputBuf = new StringBuffer();
                ZKCheckElement checkElement = new ZKCheckElement(null, this.rootPath, this.pathPattern, this.negate, this.checkACLs);
                ArrayList<ZKCheckElement> checksList = new ArrayList<ZKCheckElement>();
                checksList.add(checkElement);
                if (this.description.booleanValue()) {
                    outputBuf.append("Description: ");
                    outputBuf.append(checkElement.generateDescription() + "\n");
                }
                Hashtable<Integer, List<String>> checksOutput = new Hashtable<Integer, List<String>>();
                checksOutput.put(checkElement.hashCode(), new ArrayList());
                ZKCheck zkCheck = new ZKCheck(zk);
                zkCheck.check(checkElement.getRootPath(), checksList, checksOutput);
                if (checkElement.$status) {
                    outputBuf.append("\nCheck Result: " + ZKPolicyDefs.Colors.valueOf(zk.getZKPConfig().getMatchColor()).getANSIValue() + "PASS" + ZKPolicyDefs.Colors.RESET.getANSIValue() + "\n");
                } else {
                    outputBuf.append("\nCheck Result: " + ZKPolicyDefs.Colors.valueOf(zk.getZKPConfig().getMismatchColor()).getANSIValue() + "FAIL" + ZKPolicyDefs.Colors.RESET.getANSIValue() + "\n");
                }
                outputBuf.append("\n" + String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)checksOutput.get(checkElement.hashCode())) + "\n");
                System.out.println(outputBuf.toString());
            }
            catch (Exception e) {
                System.out.println(e.toString());
                logger.error("Exception occurred!", (Throwable)e);
            }
        }
    }
}

