/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKAuditCli;
import ch.cern.ZKCheckCli;
import ch.cern.ZKEnforceCli;
import ch.cern.ZKExportCli;
import ch.cern.ZKPolicy;
import ch.cern.ZKQueryCli;
import ch.cern.ZKRollbackCli;
import ch.cern.ZKTreeCli;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import lombok.Generated;
import picocli.CommandLine;

@CommandLine.Command(name="zkpolicy", description={"ZooKeeper policy auditing tool"}, versionProvider=PropertiesVersionProvider.class, subcommands={ZKQueryCli.class, ZKExportCli.class, ZKTreeCli.class, ZKEnforceCli.class, ZKAuditCli.class, ZKCheckCli.class, ZKRollbackCli.class, CommandLine.HelpCommand.class}, mixinStandardHelpOptions=true)
public class ZKPolicyCli
implements Runnable {
    @CommandLine.Option(names={"-c", "--config"}, required=false, description={"YAML configuration file to use (default: ${DEFAULT-VALUE})"}, scope=CommandLine.ScopeType.INHERIT, defaultValue="/opt/zkpolicy/conf/config.yml")
    public File configFile;
    @CommandLine.Option(names={"-j", "--jaas"}, required=false, description={"JAAS file to be used during ZooKeeper authentication"}, scope=CommandLine.ScopeType.INHERIT)
    public File jaasFile;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    @Override
    public void run() {
        this.spec.commandLine().usage(System.err);
    }

    public int executionStrategy(CommandLine.ParseResult parseResult) throws IOException {
        this.init();
        return new CommandLine.RunLast().execute(parseResult);
    }

    private void init() throws IOException {
        if (this.jaasFile != null && this.jaasFile.exists()) {
            System.setProperty("java.security.auth.login.config", this.jaasFile.getCanonicalPath());
        }
    }

    @Generated
    public ZKPolicyCli() {
    }

    static class PropertiesVersionProvider
    implements CommandLine.IVersionProvider {
        PropertiesVersionProvider() {
        }

        public String[] getVersion() throws Exception {
            Properties properties = new Properties();
            properties.load(ZKPolicy.class.getClassLoader().getResourceAsStream("project.properties"));
            return new String[]{properties.getProperty("version")};
        }
    }
}

