/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ACLAugment;
import ch.cern.ACLAugmentSatisfyEquator;
import ch.cern.ZKClient;
import ch.cern.ZKPattern;
import ch.cern.ZKQuery;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Equator;
import org.apache.commons.collections4.IterableUtils;
import org.apache.zookeeper.data.ACL;

public class ZKDefaultQuery {
    public ExactACLDef exactACL = new ExactACLDef();
    public NoACLDef noACL = new NoACLDef();
    public SatisfyACLDef satisfyACL = new SatisfyACLDef();
    public NoSatisfyACLDef noSatisfyACL = new NoSatisfyACLDef();
    public ParentYesChildNoDef parentYesChildNo = new ParentYesChildNoDef();
    public DuplicateACLDef duplicateACL = new DuplicateACLDef();
    public RegexMatchACLDef regexMatchACL = new RegexMatchACLDef();
    public GlobMatchACLDef globMatchACL = new GlobMatchACLDef();
    public GlobMatchPathDef globMatchPath = new GlobMatchPathDef();
    public RegexMatchPathDef regexMatchPath = new RegexMatchPathDef();

    public ZKQuery getValueOf(String lookingForValue) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = this.getClass().getField(lookingForValue);
        return (ZKQuery)field.get(this);
    }

    private static class RegexMatchPathDef
    implements ZKQuery {
        private RegexMatchPathDef() {
        }

        @Override
        public String getDescription() {
            return "Match znodes with paths matching the passed regular expression argument";
        }

        @Override
        public boolean query(List<ACL> aclList, List<ACL> parentAclList, String path, ZKClient zk, List<String> queryPathRegexList) {
            List<Pattern> queryPatternList = ZKPattern.createRegexPatternList(queryPathRegexList);
            Matcher pathMatcher = queryPatternList.get(0).matcher(path);
            return pathMatcher.matches();
        }
    }

    private static class GlobMatchPathDef
    implements ZKQuery {
        private GlobMatchPathDef() {
        }

        @Override
        public String getDescription() {
            return "Match znodes with paths matching the passed glob pattern argument";
        }

        @Override
        public boolean query(List<ACL> aclList, List<ACL> parentAclList, String path, ZKClient zk, List<String> queryPathGlobList) {
            List<Pattern> queryPatternList = ZKPattern.createGlobPatternList(queryPathGlobList);
            Matcher pathMatcher = queryPatternList.get(0).matcher(path);
            return pathMatcher.matches();
        }
    }

    private static class GlobMatchACLDef
    implements ZKQuery {
        private GlobMatchACLDef() {
        }

        @Override
        public String getDescription() {
            return "Match znodes with ACL entries matching the passed glob pattern arguments";
        }

        @Override
        public boolean query(List<ACL> aclList, List<ACL> parentAclList, String path, ZKClient zk, List<String> queryACLGlobList) {
            List<Pattern> queryPatternList = ZKPattern.createGlobPatternList(queryACLGlobList);
            int queryListSentinel = queryPatternList.size();
            for (ACL aclElement : aclList) {
                ACLAugment currentACLAugment = new ACLAugment(aclElement);
                String currentACLString = currentACLAugment.getStringFromACL();
                for (Pattern pattern : queryPatternList) {
                    Matcher currentMatcher = pattern.matcher(currentACLString);
                    if (currentMatcher.matches()) {
                        --queryListSentinel;
                    }
                    if (queryListSentinel != 0) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class RegexMatchACLDef
    implements ZKQuery {
        private RegexMatchACLDef() {
        }

        @Override
        public String getDescription() {
            return "Match znodes with ACL entries matching the passed regular expression arguments";
        }

        @Override
        public boolean query(List<ACL> aclList, List<ACL> parentAclList, String path, ZKClient zk, List<String> queryACLRegexList) {
            List<Pattern> queryPatternList = ZKPattern.createRegexPatternList(queryACLRegexList);
            int queryListSentinel = queryPatternList.size();
            for (ACL aclElement : aclList) {
                ACLAugment currentACLAugment = new ACLAugment(aclElement);
                String currentACLString = currentACLAugment.getStringFromACL();
                for (Pattern pattern : queryPatternList) {
                    Matcher currentMatcher = pattern.matcher(currentACLString);
                    if (currentMatcher.matches()) {
                        --queryListSentinel;
                    }
                    if (queryListSentinel != 0) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class DuplicateACLDef
    implements ZKQuery {
        private DuplicateACLDef() {
        }

        @Override
        public String getDescription() {
            return "Match znodes with duplicate ACL entries";
        }

        @Override
        public boolean query(List<ACL> aclList, List<ACL> parentAclList, String path, ZKClient zk, List<String> queryACLs) {
            HashSet<ACLAugment> unique = new HashSet<ACLAugment>();
            for (ACL aclElement : aclList) {
                ACLAugment aclAugment = new ACLAugment(aclElement);
                if (unique.add(aclAugment)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ParentYesChildNoDef
    implements ZKQuery {
        private ParentYesChildNoDef() {
        }

        @Override
        public String getDescription() {
            return "Match znodes with ACL not equal to their parent's ACL";
        }

        @Override
        public boolean query(List<ACL> aclList, List<ACL> parentAclList, String path, ZKClient zk, List<String> queryACLs) {
            List<ACLAugment> myACLsAugment = null;
            List<ACLAugment> parentACLsAugment = null;
            myACLsAugment = ACLAugment.generateACLAugmentList(aclList);
            return CollectionUtils.isEqualCollection(myACLsAugment, parentACLsAugment = ACLAugment.generateACLAugmentList(parentAclList));
        }
    }

    private static class NoSatisfyACLDef
    implements ZKQuery {
        private NoSatisfyACLDef() {
        }

        @Override
        public String getDescription() {
            return "Match znodes that are not accessible by clients with the passed authentication info arguments";
        }

        @Override
        public boolean query(List<ACL> aclList, List<ACL> parentAclList, String path, ZKClient zk, List<String> queryACLs) {
            List<ACLAugment> aclListAugment = ACLAugment.generateACLAugmentList(aclList);
            for (String queryACLString : queryACLs) {
                ACLAugment temp = new ACLAugment(queryACLString);
                if (IterableUtils.contains(aclListAugment, (Object)temp, (Equator)new ACLAugmentSatisfyEquator())) continue;
                return true;
            }
            return false;
        }
    }

    private static class SatisfyACLDef
    implements ZKQuery {
        private SatisfyACLDef() {
        }

        @Override
        public String getDescription() {
            return "Match znodes that are accessible by clients with the passed authentication info arguments (logical match)";
        }

        @Override
        public boolean query(List<ACL> aclList, List<ACL> parentAclList, String path, ZKClient zk, List<String> queryACLs) {
            List<ACLAugment> aclListAugment = ACLAugment.generateACLAugmentList(aclList);
            for (String queryACLString : queryACLs) {
                ACLAugment temp = new ACLAugment(queryACLString);
                if (IterableUtils.contains(aclListAugment, (Object)temp, (Equator)new ACLAugmentSatisfyEquator())) continue;
                return false;
            }
            return true;
        }
    }

    private static class NoACLDef
    implements ZKQuery {
        private NoACLDef() {
        }

        @Override
        public String getDescription() {
            return "Match znodes with no access control restrictions (ACL equals [world:anyone:cdrwa])";
        }

        @Override
        public boolean query(List<ACL> aclList, List<ACL> parentAclList, String path, ZKClient zk, List<String> queryACLs) {
            for (ACL aclElement : aclList) {
                ACLAugment aclAugment = new ACLAugment(aclElement);
                if (!aclAugment.getScheme().equals("world") || !aclAugment.getId().equals("anyone") || !aclAugment.hasCreate() || !aclAugment.hasWrite() || !aclAugment.hasAdmin() || !aclAugment.hasRead() || !aclAugment.hasDelete()) continue;
                return true;
            }
            return false;
        }
    }

    private static class ExactACLDef
    implements ZKQuery {
        private ExactACLDef() {
        }

        @Override
        public String getDescription() {
            return "Match znodes with ACL equal to the passed ACL argument";
        }

        @Override
        public boolean query(List<ACL> aclList, List<ACL> parentAclList, String path, ZKClient zk, List<String> queryACLs) {
            if (aclList == null || aclList.size() != queryACLs.size()) {
                return false;
            }
            List<ACLAugment> aclListAugment = ACLAugment.generateACLAugmentList(aclList);
            List<String> queryACLsSub = queryACLs;
            ArrayList<ACLAugment> queryACLString = new ArrayList<ACLAugment>();
            for (String queryACL : queryACLsSub) {
                ACLAugment tempACLAugment = new ACLAugment(queryACL);
                queryACLString.add(tempACLAugment);
            }
            return aclListAugment.containsAll(queryACLString);
        }
    }
}

