/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKClient;
import ch.cern.ZKConfig;
import ch.cern.ZKExport;
import ch.cern.ZKPolicyCli;
import ch.cern.ZKPolicyDefs;
import java.io.File;
import picocli.CommandLine;

@CommandLine.Command(name="export", aliases={"e"}, description={"Export the znode tree"}, mixinStandardHelpOptions=true)
public class ZKExportCli
implements Runnable {
    @CommandLine.ParentCommand
    private ZKPolicyCli parent;
    @CommandLine.Option(names={"-t", "--type"}, required=true, description={"Output file format ${COMPLETION-CANDIDATES} (default: json)"})
    ZKPolicyDefs.ExportFormats format = ZKPolicyDefs.ExportFormats.json;
    @CommandLine.Option(names={"-C", "--compact"}, description={"Minified export (default: false)"})
    Boolean compactMode = false;
    @CommandLine.Option(names={"-o", "--output"}, required=true, description={"Output file destination"})
    File outputFile = new File("./zkpolicy_export.out");
    @CommandLine.Option(names={"-p", "--root-path"}, required=true, description={"Root path for exported subtree"})
    String rootPath;

    @Override
    public void run() {
        ZKConfig config = null;
        try {
            config = new ZKConfig(this.parent.configFile);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        if (config != null) {
            try (ZKClient zk = new ZKClient(config);){
                ZKExport zkExport = new ZKExport(zk);
                zkExport.export(this.rootPath, this.format, this.compactMode, this.outputFile);
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }
}

