/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZKPurgeRollback {
    private static Logger logger = LogManager.getLogger(ZKPurgeRollback.class);
    private File rollbackDir;

    public void purgeRollback(Integer retainCount) throws IOException {
        Object[] files = this.rollbackDir.listFiles(new RollbackFilenameFilter());
        if (files != null) {
            Arrays.sort(files);
            Integer totalSnapshotNum = files.length;
            Integer cnt = 0;
            for (Object rollbackFile : files) {
                if (totalSnapshotNum - cnt <= retainCount) break;
                logger.info("Purging: " + ((File)rollbackFile).getPath());
                if (!((File)rollbackFile).delete()) {
                    logger.error("Failed to delete " + ((File)rollbackFile).getPath());
                    throw new IOException("Failed to delete " + ((File)rollbackFile).getPath());
                }
                cnt = cnt + 1;
            }
        }
    }

    @Generated
    public File getRollbackDir() {
        return this.rollbackDir;
    }

    @Generated
    public void setRollbackDir(File rollbackDir) {
        this.rollbackDir = rollbackDir;
    }

    @Generated
    public ZKPurgeRollback() {
    }

    @Generated
    protected ZKPurgeRollback(File rollbackDir) {
        this.rollbackDir = rollbackDir;
    }

    static class RollbackFilenameFilter
    implements FilenameFilter {
        RollbackFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.matches("^ROLLBACK_STATE.*\\.yml");
        }
    }
}

