/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKClient;
import ch.cern.ZKPolicyDefs;
import ch.cern.ZKTreeNode;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ZKExport {
    private static Logger logger = LogManager.getLogger(ZKExport.class);
    private ZKClient zk;
    private ZKTreeNode znodeRoot;

    public ZKExport(ZKClient zk) {
        this.zk = zk;
        this.znodeRoot = new ZKTreeNode();
    }

    public void export(String rootPath, ZKPolicyDefs.ExportFormats format, boolean compactMode, File outputFile) {
        try {
            this.toTreeStruct(rootPath, this.znodeRoot);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
        switch (format) {
            case json: {
                this.exportToJSON(outputFile, compactMode);
                break;
            }
            case yaml: {
                this.exportToYAML(outputFile);
                break;
            }
        }
    }

    private void exportToJSON(File outputFile, boolean compactMode) {
        try {
            ObjectMapper mapper = new ObjectMapper(new JsonFactory());
            if (compactMode) {
                mapper.writeValue(outputFile, (Object)this.znodeRoot);
            } else {
                mapper.writerWithDefaultPrettyPrinter().writeValue(outputFile, (Object)this.znodeRoot);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
    }

    private void exportToYAML(File outputFile) {
        try {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            mapper.writeValue(outputFile, (Object)this.znodeRoot);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
    }

    private void toTreeStruct(String path, ZKTreeNode currentNode) throws KeeperException, InterruptedException {
        List acl;
        byte[] data;
        Stat stat = new Stat();
        try {
            data = this.zk.getData(path, null, stat);
            acl = this.zk.getACL(path, null);
        }
        catch (KeeperException.NoAuthException e) {
            return;
        }
        ArrayList<Byte> byteData = new ArrayList<Byte>();
        if (data != null) {
            for (byte dataItem : data) {
                byteData.add(dataItem);
            }
        }
        currentNode.setData(byteData);
        currentNode.setPath(path);
        currentNode.setAcl(acl);
        currentNode.setStat(stat);
        List children = null;
        try {
            children = this.zk.getChildren(path, null);
        }
        catch (KeeperException.NoAuthException e) {
            return;
        }
        Collections.sort(children);
        if (path.equals("/")) {
            path = "";
        }
        Iterator iterator = children.iterator();
        ArrayList<ZKTreeNode> childrenList = new ArrayList<ZKTreeNode>();
        while (iterator.hasNext()) {
            String child = (String)iterator.next();
            ZKTreeNode childNode = new ZKTreeNode();
            this.toTreeStruct(path + "/" + child, childNode);
            childrenList.add(childNode);
        }
        currentNode.setChildren(childrenList);
    }
}

