/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKPurgeRollback;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="purge-rollback", aliases={"p"}, description={"Purge rollback snapshots, retaining a user defined number"}, helpCommand=true, mixinStandardHelpOptions=true)
public class ZKPurgeRollbackCli
implements Runnable {
    private static Logger logger = LogManager.getLogger(ZKPurgeRollbackCli.class);
    @CommandLine.Option(names={"-r", "--retain-count"}, required=true, description={"Number of rollback snapshots to retain after purging"})
    Integer retainCount;
    @CommandLine.Option(names={"-d", "--rollback-dir"}, required=false, defaultValue="/opt/zkpolicy/rollback", description={"Rollback snapshots directory (default: ${DEFAULT-VALUE})"})
    File rollbackDir;

    @Override
    public void run() {
        ZKPurgeRollback zkPurge = new ZKPurgeRollback(this.rollbackDir);
        try {
            zkPurge.purgeRollback(this.retainCount);
        }
        catch (IOException e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
    }
}

