/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKClient;
import ch.cern.ZKConfig;
import ch.cern.ZKDefaultQuery;
import ch.cern.ZKPolicyCli;
import ch.cern.ZKQuery;
import ch.cern.ZKQueryElement;
import ch.cern.ZKTree;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="query", aliases={"q"}, description={"Query the znode tree"}, helpCommand=true, mixinStandardHelpOptions=true)
public class ZKQueryCli
implements Runnable {
    private static Logger logger = LogManager.getLogger(ZKQueryCli.class);
    @CommandLine.ParentCommand
    private ZKPolicyCli parent;
    @CommandLine.Parameters(paramLabel="[QUERY_NAME]", description={"Query to be executed: ${COMPLETION-CANDIDATES}"}, completionCandidates=DefaultQueryCandidates.class)
    String queryName;
    @CommandLine.Option(names={"-p", "--root-path"}, required=true, description={"Query execution root path"})
    String rootPath;
    @CommandLine.Option(names={"-a", "--args"}, description={"Query arguments"}, arity="1..*")
    List<String> queryArgs;
    @CommandLine.Option(names={"-D", "--description"}, description={"Include query description in output (default: disabled)"})
    Boolean description = false;
    @CommandLine.ArgGroup(exclusive=true, multiplicity="0..1")
    Exclusive exclusive;

    @Override
    public void run() {
        try {
            this.executeQuery();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
    }

    private void executeQuery() throws JsonParseException, JsonMappingException, IOException {
        ZKTree zktree = null;
        ZKConfig config = new ZKConfig(this.parent.configFile);
        try (ZKClient zk = new ZKClient(config);){
            zktree = new ZKTree(zk);
            StringBuffer outputBuf = new StringBuffer();
            ZKDefaultQuery zkDefaultQuery = new ZKDefaultQuery();
            ZKQuery query = zkDefaultQuery.getValueOf(this.queryName);
            ZKQueryElement queryElement = new ZKQueryElement(this.queryName, this.rootPath, this.queryArgs, query);
            ArrayList<ZKQueryElement> queriesList = new ArrayList<ZKQueryElement>();
            queriesList.add(queryElement);
            Hashtable<Integer, List<String>> queriesOutput = new Hashtable<Integer, List<String>>();
            queriesOutput.put(queryElement.hashCode(), new ArrayList());
            if (this.description.booleanValue()) {
                outputBuf.append("Description: " + queryElement.generateDescription() + "\n\n");
            }
            if (this.exclusive != null && this.exclusive.listQueryGroup != null && this.exclusive.listQueryGroup.listMode.booleanValue()) {
                zktree.queryFind(queryElement.getRootPath(), queriesList, queriesOutput);
            } else {
                zktree.queryTree(queryElement.getRootPath(), queriesList, queriesOutput);
                if (this.exclusive != null && this.exclusive.treeQueryGroup != null && this.exclusive.treeQueryGroup.colorDescription.booleanValue()) {
                    outputBuf.append(zktree.colorCodeExplanation() + "\n");
                }
            }
            List<String> queryOutput = queriesOutput.get(queryElement.hashCode());
            if (queryOutput.size() > 0) {
                outputBuf.append(String.join((CharSequence)"\n", queryOutput));
            }
            System.out.println(outputBuf.toString());
        }
        catch (NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            System.out.println("No such method: " + this.queryName);
            System.out.println("Please consult the list of default queries using query -h");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
    }

    static class DefaultQueryCandidates
    extends ArrayList<String> {
        private static final long serialVersionUID = 7171497735085364947L;

        DefaultQueryCandidates() {
            super(Arrays.asList(new String[0]));
            Field[] fields;
            Class<ZKDefaultQuery> zkDefaultQueryClass = ZKDefaultQuery.class;
            for (Field field : fields = zkDefaultQueryClass.getDeclaredFields()) {
                if (field.getName().equals("logger")) continue;
                this.add("%n * " + field.getName());
            }
            Collections.sort(this);
        }
    }

    static class Exclusive {
        @CommandLine.ArgGroup(exclusive=false)
        TreeQueryGroup treeQueryGroup;
        @CommandLine.ArgGroup(exclusive=false)
        ListQueryGroup listQueryGroup;

        Exclusive() {
        }
    }

    static class ListQueryGroup {
        @CommandLine.Option(names={"-l", "--list"}, description={"Return list with query matching znode paths (default: disabled)"})
        Boolean listMode = false;

        ListQueryGroup() {
        }
    }

    static class TreeQueryGroup {
        @CommandLine.Option(names={"--color-description"}, description={"Include color description in output (default: disabled)"})
        Boolean colorDescription = false;

        TreeQueryGroup() {
        }
    }
}

