/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKPolicyDefs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

public class ACLAugment {
    private ACL acl;

    public ACLAugment(ACL initACL) {
        this.acl = initACL;
    }

    public ACLAugment(String stringACL) throws IllegalArgumentException {
        if (stringACL == null) {
            throw new IllegalArgumentException("Null stringACL provided");
        }
        int firstColon = stringACL.indexOf(58);
        int lastColon = stringACL.lastIndexOf(58);
        if (firstColon == -1 || lastColon == -1 || firstColon == lastColon) {
            throw new IllegalArgumentException(stringACL + " does not have the form scheme:id:perm");
        }
        String scheme = stringACL.substring(0, firstColon);
        if (!ZKPolicyDefs.Schemes.includes(scheme)) {
            throw new IllegalArgumentException(scheme + " is not a valid scheme type");
        }
        String id = stringACL.substring(firstColon + 1, lastColon);
        String perms = stringACL.substring(lastColon + 1);
        ACL newAcl = new ACL();
        newAcl.setId(new Id(scheme, id));
        newAcl.setPerms(ACLAugment.getPermFromString(perms));
        this.acl = newAcl;
    }

    public boolean hasRead() {
        return (this.acl.getPerms() & 1) != 0;
    }

    public boolean hasWrite() {
        return (this.acl.getPerms() & 2) != 0;
    }

    public boolean hasCreate() {
        return (this.acl.getPerms() & 4) != 0;
    }

    public boolean hasDelete() {
        return (this.acl.getPerms() & 8) != 0;
    }

    public boolean hasAdmin() {
        return (this.acl.getPerms() & 0x10) != 0;
    }

    public String getScheme() {
        return this.acl.getId().getScheme();
    }

    public String getId() {
        return this.acl.getId().getId();
    }

    public int getPerms() {
        return this.acl.getPerms();
    }

    public ACL getACL() {
        return this.acl;
    }

    private static int getPermFromString(String permString) throws IllegalArgumentException {
        int perm = 0;
        block7: for (int i = 0; i < permString.length(); ++i) {
            switch (permString.charAt(i)) {
                case 'r': {
                    perm |= 1;
                    continue block7;
                }
                case 'w': {
                    perm |= 2;
                    continue block7;
                }
                case 'c': {
                    perm |= 4;
                    continue block7;
                }
                case 'd': {
                    perm |= 8;
                    continue block7;
                }
                case 'a': {
                    perm |= 0x10;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Unknown perm type: " + permString.charAt(i));
                }
            }
        }
        return perm;
    }

    public String getStringFromACL() {
        String returnACL = this.getScheme() + ":" + this.getId() + ":";
        if (this.hasCreate()) {
            returnACL = returnACL + "c";
        }
        if (this.hasDelete()) {
            returnACL = returnACL + "d";
        }
        if (this.hasRead()) {
            returnACL = returnACL + "r";
        }
        if (this.hasWrite()) {
            returnACL = returnACL + "w";
        }
        if (this.hasAdmin()) {
            returnACL = returnACL + "a";
        }
        return returnACL;
    }

    public static List<ACLAugment> generateACLAugmentList(List<ACL> aclList) {
        ArrayList<ACLAugment> toReturnList = new ArrayList<ACLAugment>();
        for (ACL acl : aclList) {
            toReturnList.add(new ACLAugment(acl));
        }
        return toReturnList;
    }

    public static String generateACLStringList(List<ACL> aclList) {
        StringBuffer outputBuf = new StringBuffer();
        Iterator<ACL> iterator = aclList.iterator();
        while (iterator.hasNext()) {
            ACLAugment tempACL = new ACLAugment(iterator.next());
            if (iterator.hasNext()) {
                outputBuf.append(tempACL.getStringFromACL() + ", ");
                continue;
            }
            outputBuf.append(tempACL.getStringFromACL());
        }
        return outputBuf.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ACLAugment)) {
            return false;
        }
        ACLAugment other = (ACLAugment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ACL this$acl = this.getACL();
        ACL other$acl = other.getACL();
        return !(this$acl == null ? other$acl != null : !((Object)this$acl).equals(other$acl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ACLAugment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ACL $acl = this.getACL();
        result = result * 59 + ($acl == null ? 43 : ((Object)$acl).hashCode());
        return result;
    }
}

