/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ACLAugment;
import ch.cern.ZKAuditSet;
import ch.cern.ZKCheck;
import ch.cern.ZKCheckElement;
import ch.cern.ZKClient;
import ch.cern.ZKDefaultQuery;
import ch.cern.ZKPolicyDefs;
import ch.cern.ZKPolicyUtils;
import ch.cern.ZKQuery;
import ch.cern.ZKQueryElement;
import ch.cern.ZKTree;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.client.FourLetterWordMain;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.data.ACL;

public class ZKAudit {
    private ZKClient zk;
    private ZKAuditSet zkAuditSet;
    private Hashtable<String, List<ZKQueryElement>> rootPathGroups;
    private Hashtable<String, List<ZKCheckElement>> rootPathCheckGroups;
    Hashtable<Integer, List<String>> queriesOutput = null;
    Hashtable<Integer, List<String>> checksOutput = null;

    public Set<String> getRootPathKeys() {
        return this.rootPathGroups.keySet();
    }

    public Set<String> getRootPathCheckKeys() {
        return this.rootPathCheckGroups.keySet();
    }

    public ZKAuditSet getZkAuditSet() {
        return this.zkAuditSet;
    }

    public ZKAudit(ZKClient zk, File auditConfigFile) throws JsonParseException, JsonMappingException, IOException {
        this.zk = zk;
        this.rootPathGroups = new Hashtable();
        this.rootPathCheckGroups = new Hashtable();
        this.zkAuditSet = new ZKAuditSet(auditConfigFile);
        if (this.zkAuditSet.getQueries() != null) {
            this.queriesOutput = ZKPolicyUtils.getQueryOutputBuffer(this.zkAuditSet.getQueries());
        }
        if (this.zkAuditSet.getChecks() != null) {
            this.checksOutput = ZKPolicyUtils.getChecksOutputBuffer(this.zkAuditSet.getChecks());
        }
    }

    public String getACLOverview() throws KeeperException, InterruptedException {
        ArrayList<String> output = new ArrayList<String>();
        output.add("Permission overview for ZooKeeper Tree\n");
        this.getACLHeaderInner("/", output);
        return String.join((CharSequence)"\n", output) + "\n";
    }

    public String getFourLetterWordOverview() throws KeeperException, InterruptedException, IOException, X509Exception.SSLContextException {
        ArrayList<String> enabledOutput = new ArrayList<String>();
        ArrayList<String> disabledOutput = new ArrayList<String>();
        ArrayList<String> unknownOutput = new ArrayList<String>();
        for (ZKPolicyDefs.FourLetterWords command : ZKPolicyDefs.FourLetterWords.values()) {
            String commandResponse = "";
            try {
                commandResponse = this.retrySend4LetterWord(command.getCommand(), 1000, 3);
            }
            catch (IOException e) {
                unknownOutput.add(command.getCommand());
                continue;
            }
            if (commandResponse.contains("is not executed because it is not in the whitelist.")) {
                disabledOutput.add(command.getCommand());
                continue;
            }
            enabledOutput.add(command.getCommand());
        }
        Collections.sort(enabledOutput);
        Collections.sort(disabledOutput);
        Collections.sort(unknownOutput);
        return "Four Letter Words overview for ZooKeeper Server\nEnabled: " + String.join((CharSequence)", ", enabledOutput) + "\nDisabled: " + String.join((CharSequence)", ", disabledOutput) + "\nUnknown: " + String.join((CharSequence)", ", unknownOutput) + "\n";
    }

    private String retrySend4LetterWord(String command, int timeOut, int tryNum) throws X509Exception.SSLContextException, IOException {
        int count = 0;
        while (true) {
            try {
                return FourLetterWordMain.send4LetterWord(this.zk.getHost(), this.zk.getPort(), command, false, timeOut);
            }
            catch (IOException e) {
                if (++count != tryNum) continue;
                throw e;
            }
            break;
        }
    }

    private void executeRootGroupQueries() throws JsonParseException, JsonMappingException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, KeeperException, InterruptedException {
        ZKTree zkTree = new ZKTree(this.zk);
        this.groupQueriesByRootPath();
        for (String rootPath : this.getRootPathKeys()) {
            List<ZKQueryElement> currentBatch = this.rootPathGroups.get(rootPath);
            zkTree.queryFind(rootPath, currentBatch, this.queriesOutput);
        }
    }

    private void executeRootGroupChecks() throws JsonParseException, JsonMappingException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, KeeperException, InterruptedException {
        ZKCheck zkCheck = new ZKCheck(this.zk);
        this.groupChecksByRootPath();
        for (String rootPath : this.getRootPathCheckKeys()) {
            List<ZKCheckElement> currentBatch = this.rootPathCheckGroups.get(rootPath);
            zkCheck.check(rootPath, currentBatch, this.checksOutput);
        }
    }

    public String generateQueriesSection() throws JsonParseException, JsonMappingException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, KeeperException, InterruptedException {
        StringBuffer outputBuf = new StringBuffer();
        if (this.zkAuditSet.getQueries() != null) {
            this.executeRootGroupQueries();
            for (ZKQueryElement queryElement : this.zkAuditSet.getQueries()) {
                outputBuf.append("\nQuery: " + queryElement.getName() + "\n");
                outputBuf.append("Root Path: " + queryElement.getRootPath() + "\n");
                if (queryElement.getArgs() != null) {
                    outputBuf.append("Arguments:\n- " + String.join((CharSequence)"\n- ", queryElement.getArgs()) + "\n");
                }
                outputBuf.append("Description: " + queryElement.generateDescription() + "\n");
                outputBuf.append("\nResult:\n");
                outputBuf.append(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)this.queriesOutput.get(queryElement.hashCode())) + "\n");
                outputBuf.append("\n---------------------------------------------------------------------\n");
            }
        }
        return outputBuf.toString();
    }

    public String generateChecksSection() throws JsonParseException, JsonMappingException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, KeeperException, InterruptedException {
        int aggregateCheckSuccessNum = 0;
        StringBuffer outputBuf = new StringBuffer();
        if (this.zkAuditSet.getChecks() != null) {
            this.executeRootGroupChecks();
            for (ZKCheckElement checkElement : this.zkAuditSet.getChecks()) {
                outputBuf.append("\nCheck: " + checkElement.getTitle() + "\n");
                outputBuf.append("Root Path: " + checkElement.getRootPath() + "\n");
                outputBuf.append("Path Pattern: " + checkElement.getPathPattern() + "\n");
                if (checkElement.getAcls() != null) {
                    outputBuf.append("Arguments:\n- " + String.join((CharSequence)"\n- ", checkElement.getAcls()) + "\n");
                }
                outputBuf.append("Description: " + checkElement.generateDescription() + "\n");
                if (checkElement.$status) {
                    outputBuf.append("\nResult: PASS\n");
                    ++aggregateCheckSuccessNum;
                } else {
                    outputBuf.append("\nResult: FAIL\n");
                }
                List<String> checkOutput = this.checksOutput.get(checkElement.hashCode());
                if (checkOutput.size() == 0) {
                    outputBuf.append("No znodes matching the requested path pattern found.");
                } else {
                    outputBuf.append(String.join((CharSequence)"\n", checkOutput) + "\n");
                }
                outputBuf.append("\n---------------------------------------------------------------------\n");
            }
            if (aggregateCheckSuccessNum == this.zkAuditSet.getChecks().size()) {
                outputBuf.append("\nOverall Check Result: PASS\n");
            } else {
                outputBuf.append("\nOverall Check Result: FAIL\n");
                outputBuf.append("\nPASS: " + aggregateCheckSuccessNum + ", FAIL: ");
                outputBuf.append(this.zkAuditSet.getChecks().size() - aggregateCheckSuccessNum + "\n");
            }
        }
        return outputBuf.toString();
    }

    private void getACLHeaderInner(String path, List<String> output) throws KeeperException, InterruptedException {
        List<ACL> acl;
        List<String> children = null;
        try {
            acl = this.zk.getACL(path, null);
            children = this.zk.getChildren(path, null);
        }
        catch (KeeperException.NoAuthException e) {
            output.add("Warning: No READ permission for " + path + ", skipping this subtree");
            return;
        }
        StringBuffer aclOutput = new StringBuffer();
        List<ACLAugment> aclAugmentList = ACLAugment.generateACLAugmentList(acl);
        Iterator<ACLAugment> aclAugmentIterator = aclAugmentList.iterator();
        while (aclAugmentIterator.hasNext()) {
            ACLAugment aclAugment = aclAugmentIterator.next();
            aclOutput.append(aclAugment.getStringFromACL());
            if (!aclAugmentIterator.hasNext()) continue;
            aclOutput.append(", ");
        }
        output.add(path + " - " + aclOutput.toString());
        Collections.sort(children);
        if (path.equals("/")) {
            path = "";
        }
        for (String child : children) {
            this.getACLHeaderInner(path + "/" + child, output);
        }
    }

    public void groupQueriesByRootPath() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ZKDefaultQuery zkDefaultQuery = new ZKDefaultQuery();
        for (ZKQueryElement queryElement : this.zkAuditSet.getQueries()) {
            ZKQuery query = zkDefaultQuery.getValueOf(queryElement.getName());
            queryElement.setQuery(query);
            if (this.rootPathGroups.containsKey(queryElement.getRootPath())) {
                this.rootPathGroups.get(queryElement.getRootPath()).add(queryElement);
                continue;
            }
            ArrayList<ZKQueryElement> batchList = new ArrayList<ZKQueryElement>();
            batchList.add(queryElement);
            this.rootPathGroups.put(queryElement.getRootPath(), batchList);
        }
    }

    public void groupChecksByRootPath() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        for (ZKCheckElement checkElement : this.zkAuditSet.getChecks()) {
            if (this.rootPathCheckGroups.containsKey(checkElement.getRootPath())) {
                this.rootPathCheckGroups.get(checkElement.getRootPath()).add(checkElement);
                continue;
            }
            ArrayList<ZKCheckElement> batchList = new ArrayList<ZKCheckElement>();
            batchList.add(checkElement);
            this.rootPathCheckGroups.put(checkElement.getRootPath(), batchList);
        }
    }
}

