/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKClient;
import ch.cern.ZKPolicyDefs;
import ch.cern.ZKTreeNode;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZKExport {
    private static Logger logger = LogManager.getLogger(ZKExport.class);
    private ZKClient zk;

    public ZKExport(ZKClient zk) {
        this.zk = zk;
    }

    public void export(String rootPath, ZKPolicyDefs.ExportFormats format, boolean compactMode, File outputFile) {
        switch (format) {
            case json: {
                this.exportToJSON(outputFile, rootPath, compactMode);
                break;
            }
            case yaml: {
                this.exportToYAML(outputFile, rootPath);
                break;
            }
        }
    }

    private void exportToJSON(File outputFile, String rootPath, boolean compactMode) {
        ZKTreeNode root = new ZKTreeNode();
        try {
            this.toTreeStruct(rootPath, root);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
        try {
            ObjectMapper mapper = new ObjectMapper(new JsonFactory());
            if (compactMode) {
                mapper.writeValue(outputFile, (Object)root);
            } else {
                mapper.writerWithDefaultPrettyPrinter().writeValue(outputFile, (Object)root);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
    }

    private void exportToYAML(File outputFile, String rootPath) {
        ZKTreeNode root = new ZKTreeNode();
        try {
            this.toTreeStruct(rootPath, root);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
        try {
            ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
            mapper.writeValue(outputFile, (Object)root);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            logger.error("Exception occurred!", (Throwable)e);
        }
    }

    private void toTreeStruct(String path, ZKTreeNode currentNode) throws KeeperException, InterruptedException {
        List<ACL> acl;
        byte[] data;
        Stat stat = new Stat();
        try {
            data = this.zk.getData(path, null, stat);
            acl = this.zk.getACL(path, null);
        }
        catch (KeeperException.NoAuthException e) {
            return;
        }
        ArrayList<Byte> byteData = new ArrayList<Byte>();
        if (data != null) {
            for (byte dataItem : data) {
                byteData.add(dataItem);
            }
        }
        currentNode.setData(byteData);
        currentNode.setPath(path);
        currentNode.setAcl(acl);
        currentNode.setStat(stat);
        List<String> children = null;
        try {
            children = this.zk.getChildren(path, null);
        }
        catch (KeeperException.NoAuthException e) {
            return;
        }
        Collections.sort(children);
        if (path.equals("/")) {
            path = "";
        }
        Iterator<String> iterator = children.iterator();
        ArrayList<ZKTreeNode> childrenList = new ArrayList<ZKTreeNode>();
        while (iterator.hasNext()) {
            String child = iterator.next();
            ZKTreeNode childNode = new ZKTreeNode();
            this.toTreeStruct(path + "/" + child, childNode);
            childrenList.add(childNode);
        }
        currentNode.setChildren(childrenList);
    }
}

