/*
 * Decompiled with CFR 0.152.
 */
package ch.cern;

import ch.cern.ZKClient;
import ch.cern.ZKPolicyDefs;
import ch.cern.ZKQuery;
import ch.cern.ZKQueryElement;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;

public class ZKTree {
    private ZKClient zk = null;
    private String resetColor;
    private String matchColor;
    private String misMatchColor;

    public ZKTree(ZKClient zk) {
        this.zk = zk;
        this.resetColor = ZKPolicyDefs.Colors.valueOf("RESET").getANSIValue();
        this.matchColor = ZKPolicyDefs.Colors.valueOf(zk.getZKPConfig().getMatchColor()).getANSIValue();
        this.misMatchColor = ZKPolicyDefs.Colors.valueOf(zk.getZKPConfig().getMismatchColor()).getANSIValue();
    }

    public void queryTree(String rootPath, List<ZKQueryElement> queryElements, Hashtable<Integer, List<String>> queriesOutput) throws KeeperException, InterruptedException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        ArrayList<ZKQueryElement> invalidQueries = new ArrayList<ZKQueryElement>();
        ArrayList<ZKQueryElement> parentYesChildNoQueries = new ArrayList<ZKQueryElement>();
        for (ZKQueryElement zkQueryElement : queryElements) {
            block7: {
                try {
                    if (this.zk.exists(zkQueryElement.getRootPath(), null) == null) {
                        queriesOutput.get(zkQueryElement.hashCode()).add("The path " + zkQueryElement.getRootPath() + " does not exist.");
                        invalidQueries.add(zkQueryElement);
                    }
                    break block7;
                }
                catch (IllegalArgumentException e) {
                    queriesOutput.get(zkQueryElement.hashCode()).add("Invalid rootpath " + zkQueryElement.getRootPath() + " : " + e.getMessage());
                    invalidQueries.add(zkQueryElement);
                }
                continue;
            }
            if (!zkQueryElement.getName().equals("parentYesChildNo")) continue;
            this.queryTreeIntParentYesChildNo(zkQueryElement.getRootPath(), "", "", null, true, false, false, queriesOutput, zkQueryElement);
            parentYesChildNoQueries.add(zkQueryElement);
        }
        for (ZKQueryElement zkQueryElement : parentYesChildNoQueries) {
            queryElements.remove(zkQueryElement);
        }
        for (ZKQueryElement zkQueryElement : invalidQueries) {
            queryElements.remove(zkQueryElement);
        }
        if (queryElements.size() > 0) {
            this.queryTreeIntPreOrder(rootPath, "", "", queryElements, true, false, false, queriesOutput);
        }
    }

    private void queryTreeIntPreOrder(String path, String indent, String name, List<ZKQueryElement> queryElements, boolean isQueryRoot, boolean isLast, boolean isParentLast, Hashtable<Integer, List<String>> queriesOutput) throws KeeperException, InterruptedException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        List<String> children = null;
        try {
            children = this.zk.getChildren(path, null);
        }
        catch (KeeperException.NoAuthException e) {
            return;
        }
        List<ACL> znodeACLList = this.zk.getACL(path, null);
        Boolean isQueryRootSentinel = true;
        for (ZKQueryElement zkQueryElement : queryElements) {
            isQueryRootSentinel = false;
            String znodePrintColor = "";
            ZKQuery query = zkQueryElement.getQuery();
            znodePrintColor = query.query(znodeACLList, null, path, this.zk, zkQueryElement.getArgs()) ? this.matchColor : this.misMatchColor;
            if (isQueryRoot) {
                name = path.substring(1, path.length());
            } else {
                if (indent.length() > 0) {
                    indent = isParentLast ? indent.substring(0, indent.length() - ZKPolicyDefs.TerminalConstants.indentStepLength) + "      " : indent.substring(0, indent.length() - ZKPolicyDefs.TerminalConstants.indentStepLength) + "\u2502     ";
                }
                indent = isLast ? indent + "\u2514\u2500\u2500\u2500 " : indent + "\u251c\u2500\u2500\u2500 ";
            }
            queriesOutput.get(zkQueryElement.hashCode()).add(indent + znodePrintColor + "/" + name + this.resetColor);
        }
        if (path.equals("/")) {
            path = "";
        }
        Collections.sort(children);
        Iterator<String> iterator = children.iterator();
        while (iterator.hasNext()) {
            String child = iterator.next();
            this.queryTreeIntPreOrder(path + "/" + child, indent, child, queryElements, isQueryRootSentinel, !iterator.hasNext(), isLast, queriesOutput);
        }
    }

    private void queryTreeIntParentYesChildNo(String path, String indent, String name, List<ACL> parentACLList, boolean isQueryRoot, boolean isLast, boolean isParentLast, Hashtable<Integer, List<String>> queriesOutput, ZKQueryElement queryElement) throws KeeperException, InterruptedException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        List<String> children = null;
        try {
            children = this.zk.getChildren(path, null);
        }
        catch (KeeperException.NoAuthException e) {
            return;
        }
        String znodePrintColor = "";
        List<ACL> znodeACLList = this.zk.getACL(path, null);
        ZKQuery query = queryElement.getQuery();
        znodePrintColor = parentACLList == null || query.query(znodeACLList, parentACLList, path, this.zk, null) ? this.matchColor : this.misMatchColor;
        parentACLList = this.zk.getACL(path, null);
        if (path.equals("/")) {
            path = "";
        } else if (isQueryRoot) {
            name = path.substring(1, path.length());
        } else {
            if (indent.length() > 0) {
                indent = isParentLast ? indent.substring(0, indent.length() - ZKPolicyDefs.TerminalConstants.indentStepLength) + "      " : indent.substring(0, indent.length() - ZKPolicyDefs.TerminalConstants.indentStepLength) + "\u2502     ";
            }
            indent = isLast ? indent + znodePrintColor + "\u2514\u2500\u2500\u2500 " : indent + znodePrintColor + "\u251c\u2500\u2500\u2500 ";
        }
        queriesOutput.get(queryElement.hashCode()).add(indent + this.resetColor + "/" + name);
        Collections.sort(children);
        Iterator<String> iterator = children.iterator();
        while (iterator.hasNext()) {
            String child = iterator.next();
            this.queryTreeIntParentYesChildNo(path + "/" + child, indent, child, parentACLList, false, !iterator.hasNext(), isLast, queriesOutput, queryElement);
        }
    }

    public void queryFind(String rootPath, List<ZKQueryElement> queryElements, Hashtable<Integer, List<String>> queriesOutput) throws KeeperException, InterruptedException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        ArrayList<ZKQueryElement> invalidQueries = new ArrayList<ZKQueryElement>();
        ArrayList<ZKQueryElement> parentYesChildNoQueries = new ArrayList<ZKQueryElement>();
        for (ZKQueryElement zkQueryElement : queryElements) {
            block7: {
                try {
                    if (this.zk.exists(zkQueryElement.getRootPath(), null) == null) {
                        queriesOutput.get(zkQueryElement.hashCode()).add("The path " + zkQueryElement.getRootPath() + " does not exist.");
                        invalidQueries.add(zkQueryElement);
                    }
                    break block7;
                }
                catch (IllegalArgumentException e) {
                    queriesOutput.get(zkQueryElement.hashCode()).add("Invalid rootpath " + zkQueryElement.getRootPath() + " : " + e.getMessage());
                    invalidQueries.add(zkQueryElement);
                }
                continue;
            }
            if (!zkQueryElement.getName().equals("parentYesChildNo")) continue;
            this.queryFindIntParentYesChildNo(zkQueryElement.getRootPath(), null, queriesOutput, zkQueryElement);
            parentYesChildNoQueries.add(zkQueryElement);
        }
        for (ZKQueryElement zkQueryElement : parentYesChildNoQueries) {
            queryElements.remove(zkQueryElement);
        }
        for (ZKQueryElement zkQueryElement : invalidQueries) {
            queryElements.remove(zkQueryElement);
        }
        if (queryElements.size() > 0) {
            this.queryFindIntPreOrder(rootPath, queryElements, queriesOutput);
        }
    }

    private void queryFindIntPreOrder(String path, List<ZKQueryElement> queryElements, Hashtable<Integer, List<String>> queriesOutput) throws KeeperException, InterruptedException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        List<String> children = null;
        try {
            children = this.zk.getChildren(path, null);
        }
        catch (KeeperException.NoAuthException e) {
            for (ZKQueryElement zkQueryElement : queryElements) {
                queriesOutput.get(zkQueryElement.hashCode()).add("WARNING: No READ permission for " + path + ", skipping subtree");
            }
            return;
        }
        List<ACL> znodeACLList = this.zk.getACL(path, null);
        for (ZKQueryElement zkQueryElement : queryElements) {
            ZKQuery query = zkQueryElement.getQuery();
            if (!query.query(znodeACLList, null, path, this.zk, zkQueryElement.getArgs())) continue;
            queriesOutput.get(zkQueryElement.hashCode()).add(path);
        }
        if (path.equals("/")) {
            path = "";
        }
        Collections.sort(children);
        for (String child : children) {
            this.queryFindIntPreOrder(path + "/" + child, queryElements, queriesOutput);
        }
    }

    private void queryFindIntParentYesChildNo(String path, List<ACL> parentACLList, Hashtable<Integer, List<String>> queriesOutput, ZKQueryElement queryElement) throws KeeperException, InterruptedException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        List<String> children = null;
        try {
            children = this.zk.getChildren(path, null);
        }
        catch (KeeperException.NoAuthException e) {
            queriesOutput.get(queryElement.hashCode()).add("WARNING: No READ permission for " + path + ", skipping subtree");
            return;
        }
        List<ACL> znodeACLList = this.zk.getACL(path, null);
        ZKQuery query = queryElement.getQuery();
        if (parentACLList != null && !query.query(znodeACLList, parentACLList, path, this.zk, null)) {
            queriesOutput.get(queryElement.hashCode()).add(path);
        }
        parentACLList = this.zk.getACL(path, null);
        if (path.equals("/")) {
            path = "";
        }
        Collections.sort(children);
        for (String child : children) {
            this.queryFindIntParentYesChildNo(path + "/" + child, parentACLList, queriesOutput, queryElement);
        }
    }

    public String colorCodeExplanation() {
        String explanation = "";
        explanation = explanation + "* " + this.matchColor + this.zk.getZKPConfig().getMatchColor() + this.resetColor + ": znodes matching the query\n";
        explanation = explanation + "* " + this.misMatchColor + this.zk.getZKPConfig().getMismatchColor() + this.resetColor + ": znodes not matching the query\n";
        return explanation;
    }
}

