/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.dirq;

import ch.cern.dirq.Queue;
import ch.cern.mig.utils.RegExpFilenameFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class QueueIterator
implements Iterator<String> {
    protected Queue queue = null;
    protected ArrayList<String> dirs = new ArrayList();
    protected ArrayList<String> elts = new ArrayList();

    public QueueIterator(Queue queue) {
        File[] content;
        this.queue = queue;
        for (File dir : content = new File(queue.getPath()).listFiles(new RegExpFilenameFilter(Queue.DirectoryRegexp))) {
            this.dirs.add(dir.getName());
        }
        Collections.sort(this.dirs);
    }

    @Override
    public boolean hasNext() {
        if (!this.elts.isEmpty()) {
            return true;
        }
        return this.buildElements();
    }

    public abstract boolean buildElements();

    @Override
    public String next() {
        if (!this.elts.isEmpty()) {
            return this.elts.remove(0);
        }
        if (this.buildElements()) {
            return this.elts.remove(0);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
    }
}

