/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.mig.posix;

import ch.cern.mig.posix.FileStat;
import java.util.Arrays;
import java.util.List;

public class LinuxStat
extends FileStat {
    public long st_dev;
    public short __pad1;
    public int st_ino;
    public int st_mode;
    public int st_nlink;
    public int st_uid;
    public int st_gid;
    public long st_rdev;
    public short __pad2;
    public long st_size;
    public int st_blksize;
    public int st_blocks;
    public int __unused4;
    public int st_atim_sec;
    public int st_atim_nsec;
    public int st_mtim_sec;
    public int st_mtim_nsec;
    public int st_ctim_sec;
    public int st_ctim_nsec;
    public long __unused5;

    public List<String> getFieldOrder() {
        return Arrays.asList("st_dev", "__pad1", "st_ino", "st_mode", "st_nlink", "st_uid", "st_gid", "st_rdev", "__pad2", "st_size", "st_blksize", "st_blocks", "__unused4", "st_atim_sec", "st_atim_nsec", "st_mtim_sec", "st_mtim_nsec", "st_ctim_sec", "st_ctim_nsec", "__unused5");
    }

    @Override
    public String customRepr() {
        return String.format("%d-%d-%d-%x-%d-%d-%d-%d-%d-%d-%d-%d-%d", this.st_dev, this.st_ino, this.st_nlink, this.st_mode, this.st_uid, this.st_gid, this.st_rdev, this.st_size, this.st_blksize, this.st_blocks, this.st_atim_sec, this.st_mtim_sec, this.st_ctim_sec);
    }

    @Override
    public String systemCommand() {
        return "stat --format %d-%i-%h-%f-%u-%g-%t-%s-%o-%b-%X-%Y-%Z ";
    }

    @Override
    public long atime() {
        return this.st_atim_sec;
    }

    @Override
    public long blocks() {
        return this.st_blocks;
    }

    @Override
    public long blockSize() {
        return this.st_blksize;
    }

    @Override
    public long ctime() {
        return this.st_ctim_sec;
    }

    @Override
    public long dev() {
        return this.st_dev;
    }

    @Override
    public int gid() {
        return this.st_gid;
    }

    @Override
    public long ino() {
        return this.st_ino;
    }

    @Override
    public int mode() {
        return this.st_mode & 0xFFFF;
    }

    @Override
    public long mtime() {
        return this.st_mtim_sec;
    }

    @Override
    public int nlink() {
        return this.st_nlink;
    }

    @Override
    public long rdev() {
        return this.st_rdev;
    }

    @Override
    public long st_size() {
        return this.st_size;
    }

    @Override
    public int uid() {
        return this.st_uid;
    }
}

