/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.mig.posix;

import ch.cern.mig.posix.FileStat;
import java.util.Arrays;
import java.util.List;

public class MacOSStat
extends FileStat {
    public int st_dev;
    public int st_ino;
    public short st_mode;
    public short st_nlink;
    public int st_uid;
    public int st_gid;
    public int st_rdev;
    public long st_atime;
    public long st_atimensec;
    public long st_mtime;
    public long st_mtimensec;
    public long st_ctime;
    public long st_ctimensec;
    public long st_size;
    public long st_blocks;
    public int st_blksize;
    public int st_flags;
    public int st_gen;
    public int st_lspare;
    public long st_qspare0;
    public long st_qspare1;

    public List<String> getFieldOrder() {
        return Arrays.asList("st_dev", "st_ino", "st_mode", "st_nlink", "st_uid", "st_gid", "st_rdev", "st_atime", "st_atimensec", "st_mtime", "st_mtimensec", "st_ctime", "st_ctimensec", "st_size", "st_blocks", "st_blksize", "st_flags", "st_gen", "st_lspare", "st_qspare0", "st_qspare1");
    }

    @Override
    public String systemCommand() {
        return "stat -f %d-%i-%l-%u-%g-%r-%z-%k-%b-%a-%m-%c ";
    }

    @Override
    public String customRepr() {
        return String.format("%d-%d-%d-%d-%d-%d-%d-%d-%d-%d-%d-%d", this.st_dev, this.st_ino, this.st_nlink, this.st_uid, this.st_gid, this.st_rdev, this.st_size, this.st_blksize, this.st_blocks, this.st_atime, this.st_mtime, this.st_ctime);
    }

    @Override
    public long atime() {
        return this.st_atime;
    }

    @Override
    public long blocks() {
        return this.st_blocks;
    }

    @Override
    public long blockSize() {
        return this.st_blksize;
    }

    @Override
    public long ctime() {
        return this.st_ctime;
    }

    @Override
    public long dev() {
        return this.st_dev;
    }

    @Override
    public int gid() {
        return this.st_gid;
    }

    @Override
    public long ino() {
        return this.st_ino;
    }

    @Override
    public int mode() {
        return this.st_mode & 0xFFFF;
    }

    @Override
    public long mtime() {
        return this.st_mtime;
    }

    @Override
    public int nlink() {
        return this.st_nlink;
    }

    @Override
    public long rdev() {
        return this.st_rdev;
    }

    @Override
    public long st_size() {
        return this.st_size;
    }

    @Override
    public int uid() {
        return this.st_uid;
    }
}

