/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.dirq.test;

import ch.cern.dirq.QueueSimple;
import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.CommandLineInterface;
import com.lexicalscope.jewel.cli.Option;
import com.lexicalscope.jewel.cli.Unparsed;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class TestDirq {
    private static final List<String> TESTS = Arrays.asList("add", "count", "get", "iterate", "purge", "remove", "simple");
    private static final String DATE_FORMAT = "yyyy/MM/dd-kk:mm:ss";
    private static final int IRWIN_HALL_COUNT = 6;
    private static final long SECOND = 1000L;
    private static Long pid;
    private List<String> tests;
    private TestDirQArgs options;

    private TestDirQArgs parseArguments(String[] args) {
        TestDirQArgs parsed = null;
        try {
            parsed = (TestDirQArgs)CliFactory.parseArguments(TestDirQArgs.class, (String[])args);
            if (parsed.getList()) {
                System.out.print("Available tests:");
                for (String test : TESTS) {
                    System.out.print(" " + test);
                }
                System.out.println("");
            } else {
                if (parsed.getTest().equals("")) {
                    throw new ArgumentValidationException("missing test name");
                }
                if (!TESTS.contains(parsed.getTest())) {
                    throw new ArgumentValidationException("invalid test name: " + parsed.getTest());
                }
                if (parsed.getType().equals("normal")) {
                    throw new ArgumentValidationException("unsupported DirQ type: " + parsed.getType());
                }
                if (!parsed.getType().equals("simple")) {
                    throw new ArgumentValidationException("unexpected DirQ type: " + parsed.getType());
                }
                this.tests = new ArrayList<String>();
                this.tests.add(parsed.getTest());
            }
        }
        catch (ArgumentValidationException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return parsed;
    }

    private QueueSimple newDirq() throws IOException {
        if (!this.options.getType().equals("simple")) {
            throw new IllegalArgumentException("only DirQ simple is supported");
        }
        QueueSimple queue = new QueueSimple(this.options.getPath());
        if (this.options.getGranularity() > -1) {
            queue.setGranularity(this.options.getGranularity());
        }
        if (this.options.getRndhex() > -1) {
            queue.setRndHex(this.options.getRndhex());
        }
        if (this.options.getUmask() > -1) {
            queue.setUmask(this.options.getUmask());
        }
        return queue;
    }

    private void testCount() throws IOException {
        QueueSimple queue = this.newDirq();
        int count = queue.count();
        this.debug(String.format("queue has %d elements", count));
    }

    private void testPurge() throws IOException {
        this.debug("purging the queue...");
        QueueSimple queue = this.newDirq();
        if (this.options.getMaxlock() > -1) {
            queue.setMaxLock(this.options.getMaxlock());
        }
        if (this.options.getMaxtemp() > -1) {
            queue.setMaxTemp(this.options.getMaxtemp());
        }
        queue.purge();
    }

    private void testGet() throws IOException {
        this.debug("getting all elements in the queue (one pass)...");
        QueueSimple queue = this.newDirq();
        int done = 0;
        for (String element : queue) {
            if (!queue.lock(element)) continue;
            queue.get(element);
            queue.unlock(element);
            ++done;
        }
        this.debug(String.format("got %d elements", done));
    }

    private void testIterate() throws IOException {
        this.debug("iterating all elements in the queue (one pass)...");
        QueueSimple queue = this.newDirq();
        int done = 0;
        for (String element : queue) {
            if (!queue.lock(element)) continue;
            queue.unlock(element);
            ++done;
        }
        this.debug(String.format("iterated %d elements", done));
    }

    private String newBody(int size, boolean random) {
        int asize;
        if (random) {
            double rnd = 0.0;
            for (int i = 0; i < 12; ++i) {
                rnd += Math.random();
            }
            rnd -= 6.0;
            rnd /= 6.0;
            asize = size + (int)(rnd *= (double)size);
        } else {
            asize = size;
        }
        if (asize < 1) {
            return "";
        }
        char[] charArray = new char[asize];
        Arrays.fill(charArray, 'A');
        return new String(charArray);
    }

    private void testAdd() throws IOException {
        boolean random = this.options.isRandom();
        int size = this.options.getSize();
        int count = this.options.getCount();
        if (count > -1) {
            this.debug(String.format("adding %d elements to the queue...", count));
        } else {
            this.debug("adding elements to the queue forever...");
        }
        QueueSimple queue = this.newDirq();
        int done = 0;
        while (count == -1 || done < count) {
            String element = size > -1 ? this.newBody(size, random) : "Element " + ++done + " ;-)\n";
            queue.add(element);
        }
        this.debug(String.format("added %d elements", done));
    }

    private void testRemove() throws IOException {
        int count = this.options.getCount();
        if (count > -1) {
            this.debug(String.format("removing %d elements from the queue...", count));
        } else {
            this.debug("removing all elements from the queue (one pass)...");
        }
        QueueSimple queue = this.newDirq();
        int done = 0;
        if (count > -1) {
            block0: while (done < count) {
                for (String element : queue) {
                    if (!queue.lock(element)) continue;
                    queue.remove(element);
                    if (++done != count) continue;
                    continue block0;
                }
            }
        } else {
            for (String element : queue) {
                if (!queue.lock(element)) continue;
                queue.remove(element);
                ++done;
            }
            this.debug(String.format("removed %d elements", done));
        }
    }

    private void testSimple() throws IOException {
        int num;
        File path = new File(this.options.getPath());
        if (path.exists()) {
            TestDirq.die("directory exists: " + path);
        }
        if (this.options.getCount() == -1) {
            TestDirq.die("missing option: --count");
        }
        this.testAdd();
        this.testCount();
        this.testPurge();
        this.testGet();
        this.testRemove();
        this.testPurge();
        String[] children = path.list();
        int n = num = children == null ? 0 : children.length;
        if (num != 1) {
            throw new IllegalArgumentException("unexpected subdirs number: " + num);
        }
        TestDirq.recursiveDelete(path);
    }

    private void runTest(String name) throws IOException {
        long t1 = System.currentTimeMillis();
        if (name.equals("add")) {
            this.testAdd();
        } else if (name.equals("count")) {
            this.testCount();
        } else if (name.equals("get")) {
            this.testGet();
        } else if (name.equals("iterate")) {
            this.testIterate();
        } else if (name.equals("purge")) {
            this.testPurge();
        } else if (name.equals("remove")) {
            this.testRemove();
        } else if (name.equals("simple")) {
            this.testSimple();
        } else {
            throw new IllegalArgumentException("unexpected test name: " + name);
        }
        long t2 = System.currentTimeMillis();
        this.debug(String.format("done in %.4f seconds", (double)(t2 - t1) / 1000.0));
    }

    public static boolean recursiveDelete(File path) {
        if (path.isDirectory()) {
            String[] children = path.list();
            if (children == null) {
                return false;
            }
            for (int i = 0; i < children.length; ++i) {
                if (TestDirq.recursiveDelete(new File(path, children[i]))) continue;
                return false;
            }
        }
        return path.delete();
    }

    public void mainSimple(String[] args) throws IOException {
        this.options = this.parseArguments(args);
        File path = new File(this.options.getPath());
        TestDirq.recursiveDelete(path);
        try {
            this.testSimple();
        }
        catch (IOException e) {
            TestDirq.recursiveDelete(path);
            throw e;
        }
        TestDirq.recursiveDelete(path);
    }

    public void doMain(String[] args) throws InterruptedException, IOException {
        this.options = this.parseArguments(args);
        if (!this.options.getList()) {
            if (this.options.getPath().length() == 0) {
                TestDirq.die("Option is mandatory: -p/--path");
            }
            if (this.options.getSleep() > 0) {
                Thread.sleep((long)this.options.getSleep() * 1000L);
            }
            for (String test : this.tests) {
                this.runTest(test);
            }
        }
    }

    private static void die(String message) {
        throw new RuntimeException(message);
    }

    private void debug(String message) {
        if (this.options.isDebug()) {
            String now = new SimpleDateFormat(DATE_FORMAT).format(new Date());
            System.out.printf("# %s TestDirq[%d]: %s%n", now, pid, message);
            System.out.flush();
        }
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        new TestDirq().doMain(args);
    }

    static {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        String jvmName = runtimeBean.getName();
        pid = Long.valueOf(jvmName.split("@")[0]);
    }

    @CommandLineInterface(application="java-dirq-test")
    private static interface TestDirQArgs {
        @Option(shortName={"c"}, longName={"count"}, defaultValue={"-1"}, description="set the elements count")
        public int getCount();

        @Option(shortName={"d"}, longName={"debug"}, description="show debugging information")
        public boolean isDebug();

        @Option(longName={"header"}, description="set header for added elements")
        public boolean isHeader();

        @Option(helpRequest=true, longName={"help"}, description="display help")
        public boolean getHelp();

        @Option(shortName={"l"}, longName={"list"}, description="tests: add count size get iterate purge remove simple")
        public boolean getList();

        @Option(longName={"granularity"}, defaultValue={"-1"}, description="time granularity for intermediate directories (QueueSimple)")
        public int getGranularity();

        @Option(longName={"maxlock"}, defaultValue={"-1"}, description="maximum time for a locked element (or 0 to disable purging)")
        public int getMaxlock();

        @Option(longName={"maxtemp"}, defaultValue={"-1"}, description="maxmum time for a temporary element (or 0 to disable purging)")
        public int getMaxtemp();

        @Option(shortName={"p"}, longName={"path"}, defaultValue={""}, description="set the queue path")
        public String getPath();

        @Option(shortName={"r"}, longName={"random"}, description="randomize the body size")
        public boolean isRandom();

        @Option(longName={"rndhex"}, defaultValue={"-1"}, description="set the random hexadecimal digit for the queue")
        public int getRndhex();

        @Option(shortName={"s"}, longName={"size"}, defaultValue={"-1"}, description="set the body size for added elements")
        public int getSize();

        @Option(longName={"sleep"}, defaultValue={"0"}, description="sleep this amount of seconds before starting")
        public int getSleep();

        @Option(longName={"type"}, defaultValue={"simple"}, description="DirQ type (simple|normal)")
        public String getType();

        @Option(longName={"umask"}, defaultValue={"-1"}, description="set the umask for the queue")
        public int getUmask();

        @Unparsed(name="test", defaultValue={""})
        public String getTest();
    }
}

