/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.grids.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.customfields.GridCustomFieldHandler;
import ch.cern.eam.wshub.core.services.grids.entities.GridDDSpyFieldsResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridDataspy;
import ch.cern.eam.wshub.core.services.grids.entities.GridField;
import ch.cern.eam.wshub.core.services.grids.entities.GridMetadataRequestResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.impl.InforGrids;
import ch.cern.eam.wshub.core.services.grids.impl.JPAGrids;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class GridsServiceImpl
implements GridsService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private InforGrids inforGrids;
    private JPAGrids jpaGrids;
    private GridCustomFieldHandler gridCustomFieldHandler;

    public GridsServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.inforGrids = new InforGrids(applicationData, tools, this.inforws);
        if (tools.isDatabaseConnectionConfigured()) {
            this.jpaGrids = new JPAGrids(applicationData, tools, this.inforws);
        }
    }

    @Override
    public GridRequestResult executeQuery(InforContext context, GridRequest gridRequest) throws InforException {
        if (gridRequest.getUseNative().booleanValue() || !this.tools.isDatabaseConnectionConfigured()) {
            return this.inforGrids.executeQuery(context, gridRequest);
        }
        this.tools.demandDatabaseConnection();
        return this.jpaGrids.executeQuery(context, gridRequest);
    }

    @Override
    public GridMetadataRequestResult getGridMetadata(InforContext context, String gridCode, String viewType) throws InforException {
        this.tools.demandDatabaseConnection();
        return this.getGridMetadata(context, gridCode, viewType, "EN");
    }

    @Override
    public GridMetadataRequestResult getGridMetadata(InforContext context, String gridCode, String viewType, String language) throws InforException {
        this.tools.demandDatabaseConnection();
        if (gridCode == null || gridCode.trim().equals("")) {
            throw this.tools.generateFault("Grid code is a mandatory field.");
        }
        if (viewType == null || viewType.trim().equals("")) {
            throw this.tools.generateFault("View Type is a mandatory field.");
        }
        EntityManager em = this.tools.getEntityManager();
        try {
            GridMetadataRequestResult result = (GridMetadataRequestResult)em.find(GridMetadataRequestResult.class, (Object)gridCode);
            if (result == null) {
                throw new Exception();
            }
            GridDataspy[] gridDataspies = em.createNamedQuery("GridDataspy.GETGRIDDATASPIESS", GridDataspy.class).setParameter("gridid", (Object)gridCode).setParameter("userid", (Object)context.getCredentials().getUsername()).getResultList().toArray(new GridDataspy[0]);
            List selectedDataSpyList = Arrays.stream(gridDataspies).filter(ds -> ds.isDefaultDataspy()).collect(Collectors.toList());
            GridDataspy selectedDataSpy = gridDataspies[0];
            if (!selectedDataSpyList.isEmpty()) {
                selectedDataSpy = (GridDataspy)selectedDataSpyList.get(0);
            }
            result.setGridCode(gridCode);
            result.setGridDataspies(gridDataspies);
            result.setDataSpyId(selectedDataSpy.getCode());
            GridField[] gridFields = em.createNamedQuery("GridField.GETDDSPYFIELDS", GridField.class).setParameter("gridid", (Object)gridCode).setParameter("ddspyid", (Object)selectedDataSpy.getCode()).setParameter("viewtype", (Object)viewType).setParameter("language", (Object)(language != null ? language.toUpperCase() : "EN")).getResultList().toArray(new GridField[0]);
            if (JPAGrids.USE_CUSTOM_FIELDS.booleanValue()) {
                gridFields = (GridField[])Stream.of(gridFields, this.gridCustomFieldHandler.getCustomFieldsAsGridFields(selectedDataSpy.getCode())).flatMap(Stream::of).toArray(GridField[]::new);
            }
            result.setGridFields(gridFields);
            GridMetadataRequestResult gridMetadataRequestResult = result;
            return gridMetadataRequestResult;
        }
        catch (Exception e) {
            this.tools.log(Level.SEVERE, "Error while fetching grid metadata for gridCode " + gridCode);
            throw this.tools.generateFault("Couldn't fetch the metadata for this grid.");
        }
        finally {
            em.clear();
            em.close();
        }
    }

    @Override
    public GridDDSpyFieldsResult getDDspyFields(InforContext context, String gridCode, String viewType, String ddSpyId, String language) throws InforException {
        this.tools.demandDatabaseConnection();
        if (gridCode == null || gridCode.trim().equals("")) {
            throw this.tools.generateFault("Grid code is a mandatory field.");
        }
        if (ddSpyId == null || ddSpyId.trim().equals("")) {
            throw this.tools.generateFault("DataSpy id is a mandatory field.");
        }
        if (viewType == null || viewType.trim().equals("")) {
            throw this.tools.generateFault("View Type is a mandatory field.");
        }
        EntityManager em = this.tools.getEntityManager();
        try {
            GridDDSpyFieldsResult result = new GridDDSpyFieldsResult();
            GridField[] gridFields = em.createNamedQuery("GridField.GETDDSPYFIELDS", GridField.class).setParameter("gridid", (Object)gridCode).setParameter("ddspyid", (Object)ddSpyId).setParameter("viewtype", (Object)viewType).setParameter("language", (Object)(language != null ? language.toUpperCase() : "EN")).getResultList().toArray(new GridField[0]);
            if (JPAGrids.USE_CUSTOM_FIELDS.booleanValue()) {
                gridFields = (GridField[])Stream.of(gridFields, this.gridCustomFieldHandler.getCustomFieldsAsGridFields(ddSpyId)).flatMap(Stream::of).toArray(GridField[]::new);
            }
            result.setGridFields(gridFields);
            result.setDataSpyId(ddSpyId);
            GridDDSpyFieldsResult gridDDSpyFieldsResult = result;
            return gridDDSpyFieldsResult;
        }
        catch (Exception e) {
            this.tools.log(Level.SEVERE, "Error");
            throw this.tools.generateFault("Couldn't fetch the metadata for this grid.");
        }
        finally {
            em.clear();
            em.close();
        }
    }

    @Override
    public GridDataspy getDefaultDataspy(InforContext context, String gridCode, String viewType) throws InforException {
        this.tools.demandDatabaseConnection();
        if (gridCode == null || gridCode.trim().equals("")) {
            throw this.tools.generateFault("Grid code is a mandatory field.");
        }
        if (viewType == null || viewType.trim().equals("")) {
            throw this.tools.generateFault("View Type is a mandatory field.");
        }
        EntityManager em = this.tools.getEntityManager();
        try {
            GridDataspy gridDataspy;
            GridMetadataRequestResult result = (GridMetadataRequestResult)em.find(GridMetadataRequestResult.class, (Object)gridCode);
            if (result == null) {
                throw new Exception();
            }
            GridDataspy gridDataspy2 = gridDataspy = (GridDataspy)em.createNamedQuery("GridDataspy.GETDEFAULTDATASPY", GridDataspy.class).setParameter("gridid", (Object)gridCode).setParameter("userid", (Object)context.getCredentials().getUsername()).getSingleResult();
            return gridDataspy2;
        }
        catch (Exception e) {
            this.tools.log(Level.SEVERE, "Error while fetching default dataspy for grid code " + gridCode + " and view type " + viewType);
            throw this.tools.generateFault("Couldn't fetch the metadata for this grid.");
        }
        finally {
            em.clear();
            em.close();
        }
    }
}

