/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.documents.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.documents.DocumentsService;
import ch.cern.eam.wshub.core.services.documents.entities.InforDocument;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.List;
import net.datastream.schemas.mp_entities.document_001.Document;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.DOCUMENTENTITYID_Type;
import net.datastream.schemas.mp_fields.DOCUMENTENTITY_Type;
import net.datastream.schemas.mp_fields.DOCUMENTID_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_functions.mp0112_001.MP0112_AddDocumentAssociation_001;
import net.datastream.schemas.mp_functions.mp6001_001.MP6001_AddDocument_001;
import net.datastream.schemas.mp_results.mp0112_001.MP0112_AddDocumentAssociation_001_Result;
import net.datastream.schemas.mp_results.mp6001_001.MP6001_AddDocument_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class DocumentsServiceImpl
implements DocumentsService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public DocumentsServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public List<InforDocument> readInforDocuments(InforContext context, String entity, String objectCode) throws InforException {
        if (entity == null || entity.isEmpty() || objectCode == null || objectCode.isEmpty()) {
            throw this.tools.generateFault("Parameters not supplied correctly.");
        }
        return this.tools.getEntityManager().createNamedQuery("InforDocument.GET_DOCUMENTS", InforDocument.class).setParameter("code", (Object)objectCode).setParameter("entity", (Object)entity).getResultList();
    }

    @Override
    public String createInforDocumentAndAssociation(InforContext context, InforDocument doc, String entity, String objectCode) throws InforException {
        this.createInforDocument(doc, context);
        String result = this.createInforDocumentAssociation(doc.getCode(), entity, objectCode, context);
        return result;
    }

    @Override
    public String createInforDocument(InforDocument doc, InforContext context) throws InforException {
        MP6001_AddDocument_001 addDoc = new MP6001_AddDocument_001();
        Document document = new Document();
        document.setDOCUMENTID(new DOCUMENTID_Type());
        document.getDOCUMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        document.getDOCUMENTID().setDOCUMENTCODE(doc.getCode());
        document.getDOCUMENTID().setDESCRIPTION(doc.getDescription());
        if (doc.getFilename() != null) {
            document.setFILE(doc.getFilename());
        }
        if (doc.getDocClass() != null) {
            document.setCLASSID(new CLASSID_Type());
            document.getCLASSID().setCLASSCODE(doc.getDocClass());
        }
        if (doc.getFiletype() != null) {
            document.setFILETYPE(doc.getFiletype());
        }
        document.setDOCUMENTTYPE(new TYPE_Type());
        if (doc.getType() != null) {
            document.getDOCUMENTTYPE().setTYPECODE(doc.getType());
        } else {
            document.getDOCUMENTTYPE().setTYPECODE("F");
        }
        document.setOUTOFSERVICE("false");
        addDoc.setDocument(document);
        MP6001_AddDocument_001_Result result = this.inforws.addDocumentOp(addDoc, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant());
        return result.getResultData().getDOCUMENTID().getDOCUMENTCODE();
    }

    @Override
    public String createInforDocumentAssociation(String document, String entity, String objectCode, InforContext context) throws InforException {
        String inforObjectCode = objectCode;
        switch (entity) {
            case "OBJ": 
            case "PART": 
            case "LOC": {
                inforObjectCode = inforObjectCode + "#*";
                break;
            }
            case "PPM": {
                inforObjectCode = inforObjectCode + "#0";
                break;
            }
        }
        MP0112_AddDocumentAssociation_001 addDocAssoc = new MP0112_AddDocumentAssociation_001();
        addDocAssoc.setDOCUMENTENTITY(new DOCUMENTENTITY_Type());
        addDocAssoc.getDOCUMENTENTITY().setType("*");
        addDocAssoc.getDOCUMENTENTITY().setDOCUMENTENTITYID(new DOCUMENTENTITYID_Type());
        addDocAssoc.getDOCUMENTENTITY().getDOCUMENTENTITYID().setCode(inforObjectCode);
        addDocAssoc.getDOCUMENTENTITY().getDOCUMENTENTITYID().setDocument(document);
        addDocAssoc.getDOCUMENTENTITY().getDOCUMENTENTITYID().setRentity(entity);
        MP0112_AddDocumentAssociation_001_Result result = this.inforws.addDocumentAssociationOp(addDocAssoc, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant());
        return result.getDOCUMENTENTITYID().getDocument();
    }
}

