/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.material.PartService;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.BooleanType;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.part_001.Part;
import net.datastream.schemas.mp_entities.part_001.UserDefinedFields;
import net.datastream.schemas.mp_fields.CATEGORYID;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.COMMODITY_Type;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_fields.SUPPLIERID_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_fields.UOMID_Type;
import net.datastream.schemas.mp_fields.USERID_Type;
import net.datastream.schemas.mp_functions.mp0240_001.MP0240_AddPart_001;
import net.datastream.schemas.mp_functions.mp0241_001.MP0241_GetPart_001;
import net.datastream.schemas.mp_functions.mp0242_001.MP0242_SyncPart_001;
import net.datastream.schemas.mp_functions.mp0243_001.MP0243_DeletePart_001;
import net.datastream.schemas.mp_functions.mp2072_001.ChangePartNumber;
import net.datastream.schemas.mp_functions.mp2072_001.MP2072_ChangePartNumber_001;
import net.datastream.schemas.mp_results.mp0240_001.MP0240_AddPart_001_Result;
import net.datastream.schemas.mp_results.mp0241_001.MP0241_GetPart_001_Result;
import net.datastream.schemas.mp_results.mp0242_001.MP0242_SyncPart_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class PartServiceImpl
implements PartService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public PartServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public ch.cern.eam.wshub.core.services.material.entities.Part readPart(InforContext context, String partCode) throws InforException {
        MP0241_GetPart_001_Result getPartResult = null;
        MP0241_GetPart_001 getPart = new MP0241_GetPart_001();
        getPart.setPARTID(new PARTID_Type());
        getPart.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        getPart.getPARTID().setPARTCODE(partCode);
        getPartResult = context.getCredentials() != null ? this.inforws.getPartOp(getPart, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.applicationData.getTenant()) : this.inforws.getPartOp(getPart, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.applicationData.getTenant());
        Part partInfor = getPartResult.getResultData().getPart();
        ch.cern.eam.wshub.core.services.material.entities.Part part = new ch.cern.eam.wshub.core.services.material.entities.Part();
        if (partInfor.getPARTID() != null) {
            part.setCode(partInfor.getPARTID().getPARTCODE());
            part.setDescription(partInfor.getPARTID().getDESCRIPTION());
        }
        if (partInfor.getCLASSID() != null) {
            part.setClassCode(partInfor.getCLASSID().getCLASSCODE());
            part.setClassDesc(this.tools.getFieldDescriptionsTools().readClassDesc("PART", part.getClassCode()));
        }
        if (partInfor.getUOMID() != null) {
            part.setUOM(partInfor.getUOMID().getUOMCODE());
            part.setUOMDesc(this.tools.getFieldDescriptionsTools().readUOMDesc(part.getUOM()));
        }
        if (partInfor.getCATEGORYID() != null) {
            part.setCategoryCode(partInfor.getCATEGORYID().getCATEGORYCODE());
            part.setCategoryDesc(this.tools.getFieldDescriptionsTools().readCategoryDesc(part.getCategoryCode()));
        }
        if (partInfor.getPRIMARYCOMMODITY() != null) {
            part.setCommodityCode(partInfor.getPRIMARYCOMMODITY().getCOMMODITYCODE());
            part.setCommodityDesc(this.tools.getFieldDescriptionsTools().readCommodityDesc(part.getCommodityCode()));
        }
        if (partInfor.getTRACKMETHOD() != null) {
            part.setTrackingMethod(partInfor.getTRACKMETHOD().getTYPECODE());
        }
        if (partInfor.getBYASSET() != null) {
            part.setTrackByAsset(this.tools.getDataTypeTools().decodeBoolean(partInfor.getBYASSET()));
        }
        if (partInfor.getREPAIRABLE() != null) {
            part.setTrackCores(this.tools.getDataTypeTools().decodeBoolean(partInfor.getREPAIRABLE()));
        }
        if (partInfor.getBYLOT() != null) {
            part.setTrackByLot(this.tools.getDataTypeTools().decodeBoolean(partInfor.getBYLOT()));
        }
        if (partInfor.getLONGDESCRIPTION() != null) {
            part.setLongDescription(partInfor.getLONGDESCRIPTION());
        }
        part.setCustomFields(this.tools.getCustomFieldsTools().readInforCustomFields(partInfor.getUSERDEFINEDAREA()));
        part.setUserDefinedFields(this.tools.getUDFTools().readInforUserDefinedFields(partInfor.getUserDefinedFields()));
        return part;
    }

    @Override
    public String createPart(InforContext context, ch.cern.eam.wshub.core.services.material.entities.Part partParam) throws InforException {
        Part partInfor = new Part();
        if (partParam.getCustomFields() != null && partParam.getCustomFields().length > 0) {
            if (partParam.getClassCode() != null && !partParam.getClassCode().trim().equals("")) {
                partInfor.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getCustomFields(context, "PART", partParam.getClassCode()));
            } else {
                partInfor.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getCustomFields(context, "PART", "*"));
            }
        }
        partInfor.setUserDefinedFields(new UserDefinedFields());
        this.initializeInforPartObject(partInfor, partParam, context);
        MP0240_AddPart_001 addPart = new MP0240_AddPart_001();
        addPart.setPart(partInfor);
        MP0240_AddPart_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.addPartOp(addPart, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.applicationData.getTenant()) : this.inforws.addPartOp(addPart, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.applicationData.getTenant());
        return result.getPARTID().getPARTCODE();
    }

    @Override
    public String updatePart(InforContext context, ch.cern.eam.wshub.core.services.material.entities.Part partParam) throws InforException {
        if (partParam.getNewCode() != null && !partParam.getNewCode().trim().equals("")) {
            MP2072_ChangePartNumber_001 changePartNumber = new MP2072_ChangePartNumber_001();
            changePartNumber.setChangePartNumber(new ChangePartNumber());
            changePartNumber.getChangePartNumber().setOLDPARTID(new PARTID_Type());
            changePartNumber.getChangePartNumber().getOLDPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            changePartNumber.getChangePartNumber().getOLDPARTID().setPARTCODE(partParam.getCode());
            changePartNumber.getChangePartNumber().setNEWPARTID(new PARTID_Type());
            changePartNumber.getChangePartNumber().getNEWPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            changePartNumber.getChangePartNumber().getNEWPARTID().setPARTCODE(partParam.getNewCode());
            if (context.getCredentials() != null) {
                this.inforws.changePartNumberOp(changePartNumber, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.applicationData.getTenant());
            } else {
                this.inforws.changePartNumberOp(changePartNumber, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.applicationData.getTenant());
            }
            return partParam.getNewCode();
        }
        Part partInfor = new Part();
        MP0241_GetPart_001_Result getPartResult = null;
        MP0241_GetPart_001 getPart = new MP0241_GetPart_001();
        getPart.setPARTID(new PARTID_Type());
        getPart.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        getPart.getPARTID().setPARTCODE(partParam.getCode());
        getPartResult = context.getCredentials() != null ? this.inforws.getPartOp(getPart, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.applicationData.getTenant()) : this.inforws.getPartOp(getPart, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.applicationData.getTenant());
        partInfor = getPartResult.getResultData().getPart();
        if (!(partParam.getClassCode() == null || partInfor.getCLASSID() != null && partParam.getClassCode().toUpperCase().equals(partInfor.getCLASSID().getCLASSCODE()))) {
            partInfor.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getCustomFields(context, "PART", partParam.getClassCode().toUpperCase()));
        }
        this.initializeInforPartObject(partInfor, partParam, context);
        MP0242_SyncPart_001 syncPart = new MP0242_SyncPart_001();
        syncPart.setPart(partInfor);
        MP0242_SyncPart_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.syncPartOp(syncPart, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.applicationData.getTenant()) : this.inforws.syncPartOp(syncPart, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.applicationData.getTenant());
        return result.getResultData().getPart().getPARTID().getPARTCODE();
    }

    private void initializeInforPartObject(Part partInfor, ch.cern.eam.wshub.core.services.material.entities.Part partParam, InforContext context) throws InforException {
        if (partInfor.getPARTID() == null) {
            partInfor.setPARTID(new PARTID_Type());
            partInfor.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            partInfor.getPARTID().setPARTCODE(partParam.getCode().toUpperCase().trim());
        }
        if (partParam.getDescription() != null) {
            partInfor.getPARTID().setDESCRIPTION(partParam.getDescription());
        }
        if (partParam.getLongDescription() != null) {
            partInfor.setLONGDESCRIPTION(partParam.getLongDescription());
        }
        if (partParam.getUOM() != null) {
            partInfor.setUOMID(new UOMID_Type());
            partInfor.getUOMID().setUOMCODE(partParam.getUOM().trim());
        }
        if (partParam.getClassCode() != null) {
            if (partParam.getClassCode().trim().equals("")) {
                partInfor.setCLASSID(null);
            } else {
                partInfor.setCLASSID(new CLASSID_Type());
                partInfor.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
                partInfor.getCLASSID().setCLASSCODE(partParam.getClassCode().toUpperCase().trim());
            }
        }
        if (partParam.getCategoryCode() != null) {
            if (partParam.getCategoryCode().trim().equals("")) {
                partInfor.setCATEGORYID(null);
            } else {
                partInfor.setCATEGORYID(new CATEGORYID());
                partInfor.getCATEGORYID().setCATEGORYCODE(partParam.getCategoryCode().toUpperCase().trim());
            }
        }
        this.tools.getCustomFieldsTools().updateInforCustomFields(partInfor.getUSERDEFINEDAREA(), partParam.getCustomFields());
        this.tools.getUDFTools().updateInforUserDefinedFields(partInfor.getUserDefinedFields(), partParam.getUserDefinedFields());
        if (partParam.getTrackByAsset() != null) {
            partInfor.setBYASSET(this.tools.getDataTypeTools().encodeBoolean(partParam.getTrackByAsset(), BooleanType.PLUS_MINUS));
        }
        if (partParam.getOutOfService() != null) {
            partInfor.setOUTOFSERVICE(this.tools.getDataTypeTools().encodeBoolean(partParam.getOutOfService(), BooleanType.TRUE_FALSE));
        }
        if (partParam.getTrackAsKit() != null) {
            partInfor.setKIT(this.tools.getDataTypeTools().encodeBoolean(partParam.getTrackAsKit(), BooleanType.TRUE_FALSE));
        }
        if (partParam.getTrackByLot() != null) {
            partInfor.setBYLOT(this.tools.getDataTypeTools().encodeBoolean(partParam.getTrackByLot(), BooleanType.PLUS_MINUS));
        }
        if (partParam.getPreventReorders() != null) {
            partInfor.setPREVENTREORDERS(this.tools.getDataTypeTools().encodeBoolean(partParam.getPreventReorders(), BooleanType.TRUE_FALSE));
        }
        if (partParam.getTrackCores() != null) {
            partInfor.setREPAIRABLE(this.tools.getDataTypeTools().encodeBoolean(partParam.getTrackCores(), BooleanType.TRUE_FALSE));
        }
        if (partParam.getCommodityCode() != null) {
            partInfor.setPRIMARYCOMMODITY(new COMMODITY_Type());
            partInfor.getPRIMARYCOMMODITY().setCOMMODITYCODE(partParam.getCommodityCode());
            partInfor.getPRIMARYCOMMODITY().setORGANIZATIONID(this.tools.getOrganization(context));
        }
        if (partParam.getTrackingMethod() != null) {
            partInfor.setTRACKMETHOD(new TYPE_Type());
            partInfor.getTRACKMETHOD().setTYPECODE(partParam.getTrackingMethod());
        } else {
            partInfor.setTRACKMETHOD(new TYPE_Type());
            partInfor.getTRACKMETHOD().setTYPECODE("TRPQ");
        }
        if (partParam.getPriceType() != null) {
            partInfor.setPRICETYPE(new TYPE_Type());
            partInfor.getPRICETYPE().setTYPECODE(partParam.getPriceType());
        }
        if (partParam.getAveragePrice() != null) {
            partInfor.setAVERAGEPRICE(this.tools.getDataTypeTools().encodeAmount(partParam.getAveragePrice(), "Average Price"));
        }
        if (partParam.getStandardPrice() != null) {
            partInfor.setSTANDARDPRICE(this.tools.getDataTypeTools().encodeAmount(partParam.getStandardPrice(), "Standard Price"));
        }
        if (partParam.getLastPrice() != null) {
            partInfor.setLASTPRICE(this.tools.getDataTypeTools().encodeAmount(partParam.getLastPrice(), "Last Price"));
        }
        if (partParam.getBuyerCode() != null) {
            partInfor.setBUYER(new USERID_Type());
            partInfor.getBUYER().setUSERCODE(partParam.getBuyerCode());
        }
        if (partParam.getPreferredSupplier() != null) {
            partInfor.setPREFERREDSUPPLIER(new SUPPLIERID_Type());
            partInfor.getPREFERREDSUPPLIER().setORGANIZATIONID(this.tools.getOrganization(context));
            partInfor.getPREFERREDSUPPLIER().setSUPPLIERCODE(partParam.getPreferredSupplier());
        }
    }

    @Override
    public String deletePart(InforContext context, String partCode) throws InforException {
        MP0243_DeletePart_001 deletePart = new MP0243_DeletePart_001();
        deletePart.setPARTID(new PARTID_Type());
        deletePart.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        deletePart.getPARTID().setPARTCODE(partCode);
        if (context.getCredentials() != null) {
            this.inforws.deletePartOp(deletePart, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.applicationData.getTenant());
        } else {
            this.inforws.deletePartOp(deletePart, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.applicationData.getTenant());
        }
        return partCode;
    }
}

