/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.material.PickTicketService;
import ch.cern.eam.wshub.core.services.material.entities.PickTicket;
import ch.cern.eam.wshub.core.services.material.entities.PickTicketPart;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.picklist_001.PickList;
import net.datastream.schemas.mp_entities.picklistpart_001.PickListPart;
import net.datastream.schemas.mp_fields.ACTIVITYCODE;
import net.datastream.schemas.mp_fields.ACTIVITYID;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_fields.PICKLISTPARTID_Type;
import net.datastream.schemas.mp_fields.PICKLIST_Type;
import net.datastream.schemas.mp_fields.STATUS_Type;
import net.datastream.schemas.mp_fields.STOREID_Type;
import net.datastream.schemas.mp_fields.USERID_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_fields.WORKORDERACTIVITY;
import net.datastream.schemas.mp_functions.mp0211_001.MP0211_GetPickList_001;
import net.datastream.schemas.mp_functions.mp0296_001.MP0296_AddPickList_001;
import net.datastream.schemas.mp_functions.mp0297_001.MP0297_SyncPickList_001;
import net.datastream.schemas.mp_functions.mp1223_001.MP1223_AddPickListPart_001;
import net.datastream.schemas.mp_results.mp0211_001.MP0211_GetPickList_001_Result;
import net.datastream.schemas.mp_results.mp0296_001.MP0296_AddPickList_001_Result;
import net.datastream.schemas.mp_results.mp0297_001.MP0297_SyncPickList_001_Result;
import net.datastream.schemas.mp_results.mp1223_001.MP1223_AddPickListPart_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;
import org.openapplications.oagis_segments.QUANTITY;

public class PickTicketServiceImpl
implements PickTicketService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public PickTicketServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createPickTicket(InforContext context, PickTicket pickTicketParam) throws InforException {
        MP0296_AddPickList_001 createPickTicket = new MP0296_AddPickList_001();
        MP0296_AddPickList_001_Result result = new MP0296_AddPickList_001_Result();
        pickTicketParam.setCode("");
        createPickTicket.setPickList(this.pickTicket2pickList(context, pickTicketParam));
        result = context.getCredentials() != null ? this.inforws.addPickListOp(createPickTicket, this.applicationData.getOrganization(), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.applicationData.getTenant()) : this.inforws.addPickListOp(createPickTicket, this.applicationData.getOrganization(), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.applicationData.getTenant());
        return result.getPICKLISTID().getPICKLIST();
    }

    private PickList pickTicket2pickList(InforContext context, PickTicket pickTicket) throws InforException {
        PickList pickList = new PickList();
        pickList.setDATEREQUIRED(this.tools.getDataTypeTools().encodeInforDate(pickTicket.getRequestedEndDate(), "Date Required"));
        pickList.setSTOREID(new STOREID_Type());
        pickList.getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
        pickList.getSTOREID().setSTORECODE(pickTicket.getStoreCode());
        pickList.setSTATUS(new STATUS_Type());
        pickList.getSTATUS().setSTATUSCODE(pickTicket.getStatus());
        pickList.setPICKLISTID(new PICKLIST_Type());
        pickList.getPICKLISTID().setPICKLISTDESC(pickTicket.getDescription());
        pickList.getPICKLISTID().setPICKLIST(pickTicket.getCode());
        if (pickTicket.getAssetCode() != null) {
            pickList.setASSETID(new EQUIPMENTID_Type());
            pickList.getASSETID().setEQUIPMENTCODE(pickTicket.getAssetCode());
            pickList.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context));
        }
        if (pickTicket.getWorkorderCode() != null) {
            pickList.setWORKORDERACTIVITY(new WORKORDERACTIVITY());
            pickList.getWORKORDERACTIVITY().setACTIVITYID(new ACTIVITYID());
            pickList.getWORKORDERACTIVITY().getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
            pickList.getWORKORDERACTIVITY().getACTIVITYID().getACTIVITYCODE().setValue(pickTicket.getActivityNumber().longValue());
            pickList.getWORKORDERACTIVITY().getACTIVITYID().setWORKORDERID(new WOID_Type());
            pickList.getWORKORDERACTIVITY().getACTIVITYID().getWORKORDERID().setJOBNUM(pickTicket.getWorkorderCode());
        }
        if (pickTicket.getClassCode() != null) {
            pickList.setCLASSID(new CLASSID_Type());
            pickList.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            pickList.getCLASSID().setCLASSCODE(pickTicket.getClassCode());
        }
        pickList.setORIGINID(new USERID_Type());
        pickList.getORIGINID().setUSERCODE(pickTicket.getOriginCode());
        return pickList;
    }

    private PickTicket pickList2pickTicket(PickList pickList) throws InforException {
        PickTicket pickTicket = new PickTicket();
        pickTicket.setRequestedEndDate(pickTicket.getRequestedEndDate());
        pickTicket.setStoreCode(pickList.getSTOREID().getSTORECODE());
        pickTicket.setStatus(pickList.getSTATUS().getSTATUSCODE());
        pickTicket.setCode(pickList.getPICKLISTID().getPICKLIST());
        pickTicket.setDescription(pickList.getPICKLISTID().getPICKLISTDESC());
        pickTicket.setAssetCode(pickList.getASSETID().getEQUIPMENTCODE());
        pickTicket.setWorkorderCode(pickList.getWORKORDERACTIVITY().getACTIVITYID().getWORKORDERID().getJOBNUM());
        pickTicket.setActivityNumber(pickList.getWORKORDERACTIVITY().getACTIVITYID().getACTIVITYCODE().getValue());
        pickTicket.setClassCode(pickList.getCLASSID().getCLASSCODE());
        pickTicket.setOriginCode(pickList.getORIGINID().getUSERCODE());
        return pickTicket;
    }

    @Override
    public String updatePickTicket(InforContext context, PickTicket pickTicketParam) throws InforException {
        MP0297_SyncPickList_001 syncPickTicket = new MP0297_SyncPickList_001();
        PickList pickList = this.readPickTicket(context, pickTicketParam.getCode());
        if (pickTicketParam.getStatus() != null) {
            pickList.getSTATUS().setSTATUSCODE(pickTicketParam.getStatus());
        }
        syncPickTicket.setPickList(pickList);
        MP0297_SyncPickList_001_Result result = context.getCredentials() != null ? this.inforws.syncPickListOp(syncPickTicket, this.applicationData.getOrganization(), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.applicationData.getTenant()) : this.inforws.syncPickListOp(syncPickTicket, this.applicationData.getOrganization(), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.applicationData.getTenant());
        return result.getResultData().getPICKLISTID().getPICKLIST();
    }

    public PickList readPickTicket(InforContext context, String code) throws InforException {
        MP0211_GetPickList_001 getPickList = new MP0211_GetPickList_001();
        getPickList.setPICKLISTID(new PICKLIST_Type());
        getPickList.getPICKLISTID().setPICKLIST(code);
        MP0211_GetPickList_001_Result pickListResult = context.getCredentials() != null ? this.inforws.getPickListOp(getPickList, this.applicationData.getOrganization(), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.applicationData.getTenant()) : this.inforws.getPickListOp(getPickList, this.applicationData.getOrganization(), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.applicationData.getTenant());
        return pickListResult.getResultData().getPickList();
    }

    @Override
    public String addPartToPickTicket(InforContext context, PickTicketPart pickTicketPartParam) throws InforException {
        MP1223_AddPickListPart_001 addPickListPart = new MP1223_AddPickListPart_001();
        addPickListPart.setPickListPart(new PickListPart());
        QUANTITY quantity1 = new QUANTITY();
        quantity1.setVALUE(new BigDecimal(pickTicketPartParam.getQuantity()));
        quantity1.setUOM("default");
        quantity1.setSIGN("+");
        quantity1.setQualifier("OTHER");
        quantity1.setNUMOFDEC(new BigDecimal(0).toBigInteger());
        addPickListPart.getPickListPart().setQUANTITYREQUIRED(quantity1);
        PICKLISTPARTID_Type picklist_type = new PICKLISTPARTID_Type();
        picklist_type.setPARTID(new PARTID_Type());
        picklist_type.getPARTID().setPARTCODE(pickTicketPartParam.getPartCode());
        picklist_type.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
        picklist_type.setPICKLISTID(new PICKLIST_Type());
        picklist_type.getPICKLISTID().setPICKLIST(pickTicketPartParam.getPickTicket());
        addPickListPart.getPickListPart().setPICKLISTPARTID(picklist_type);
        MP1223_AddPickListPart_001_Result result = context.getCredentials() != null ? this.inforws.addPickListPartOp(addPickListPart, this.applicationData.getOrganization(), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.applicationData.getTenant()) : this.inforws.addPickListPartOp(addPickListPart, this.applicationData.getOrganization(), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.applicationData.getTenant());
        return result.toString();
    }
}

