/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.workorders.CaseService;
import ch.cern.eam.wshub.core.services.workorders.entities.InforCase;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.casemanagement_001.CaseDetails;
import net.datastream.schemas.mp_entities.casemanagement_001.CaseManagement;
import net.datastream.schemas.mp_entities.casemanagement_001.TrackingDetails;
import net.datastream.schemas.mp_fields.CASEID_Type;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.DEPARTMENTID_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.Employee_Type;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import net.datastream.schemas.mp_fields.PERSONID_Type;
import net.datastream.schemas.mp_fields.STATUS_Type;
import net.datastream.schemas.mp_fields.StandardUserDefinedFields;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_fields.USERDEFINEDCODEID_Type;
import net.datastream.schemas.mp_functions.mp3640_001.MP3640_AddCaseManagement_001;
import net.datastream.schemas.mp_functions.mp3641_001.MP3641_SyncCaseManagement_001;
import net.datastream.schemas.mp_functions.mp3642_001.MP3642_DeleteCaseManagement_001;
import net.datastream.schemas.mp_functions.mp3643_001.MP3643_GetCaseManagement_001;
import net.datastream.schemas.mp_results.mp3640_001.MP3640_AddCaseManagement_001_Result;
import net.datastream.schemas.mp_results.mp3641_001.MP3641_SyncCaseManagement_001_Result;
import net.datastream.schemas.mp_results.mp3643_001.MP3643_GetCaseManagement_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class CaseServiceImpl
implements CaseService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public CaseServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public InforCase readCase(InforContext context, String caseID) throws InforException {
        MP3643_GetCaseManagement_001 getCase = new MP3643_GetCaseManagement_001();
        getCase.setCASEID(new CASEID_Type());
        getCase.getCASEID().setCASECODE(caseID);
        getCase.getCASEID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP3643_GetCaseManagement_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.getCaseManagementOp(getCase, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant()) : this.inforws.getCaseManagementOp(getCase, this.tools.getOrganizationCode(context), null, "", new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.applicationData.getTenant());
        CaseManagement caseManagement = result.getResultData().getCaseManagement();
        InforCase caseMT = new InforCase();
        if (caseManagement.getCASEID() != null) {
            caseMT.setDescription(caseManagement.getCASEID().getDESCRIPTION());
            caseMT.setCode(caseManagement.getCASEID().getCASECODE());
        }
        if (caseManagement.getEQUIPMENTID() != null) {
            caseMT.setEquipmentCode(caseManagement.getEQUIPMENTID().getEQUIPMENTCODE());
            caseMT.setEquipmentDesc(caseManagement.getEQUIPMENTID().getDESCRIPTION());
        }
        if (caseManagement.getCASETYPE() != null) {
            caseMT.setTypeCode(caseManagement.getCASETYPE().getTYPECODE());
            caseMT.setTypeDesc(caseManagement.getCASETYPE().getDESCRIPTION());
        }
        if (caseManagement.getSTATUS() != null) {
            caseMT.setStatusCode(caseManagement.getSTATUS().getSTATUSCODE());
            caseMT.setStatusDesc(caseManagement.getSTATUS().getDESCRIPTION());
        }
        if (caseManagement.getDEPARTMENTID() != null) {
            caseMT.setDepartmentCode(caseManagement.getDEPARTMENTID().getDEPARTMENTCODE());
            caseMT.setDepartmentDesc(caseManagement.getDEPARTMENTID().getDESCRIPTION());
        }
        if (caseManagement.getTrackingDetails() != null && caseManagement.getTrackingDetails().getPERSONRESPONSIBLE() != null) {
            caseMT.setResponsibleCode(caseManagement.getTrackingDetails().getPERSONRESPONSIBLE().getEMPLOYEECODE());
            caseMT.setResponsibleDesc(caseManagement.getTrackingDetails().getPERSONRESPONSIBLE().getDESCRIPTION());
            caseMT.setResponsibleEMail(caseManagement.getTrackingDetails().getEMAIL());
        }
        if (caseManagement.getTrackingDetails() != null && caseManagement.getTrackingDetails().getASSIGNEDTO() != null) {
            caseMT.setAssignedToCode(caseManagement.getTrackingDetails().getASSIGNEDTO().getPERSONCODE());
            caseMT.setAssignedToDesc(caseManagement.getTrackingDetails().getASSIGNEDTO().getDESCRIPTION());
            caseMT.setAssignedToEMail(caseManagement.getTrackingDetails().getASSIGNEDTOEMAIL());
        }
        if (caseManagement.getCaseDetails() != null && caseManagement.getCaseDetails().getCASECLASSID() != null) {
            caseMT.setClassCode(caseManagement.getCaseDetails().getCASECLASSID().getCLASSCODE());
            caseMT.setClassDesc(caseManagement.getCaseDetails().getCASECLASSID().getDESCRIPTION());
        }
        if (caseManagement.getCaseDetails() != null && caseManagement.getCaseDetails().getWORKADDRESS() != null) {
            caseMT.setWorkaddress(caseManagement.getCaseDetails().getWORKADDRESS());
        }
        if (caseManagement.getCaseDetails() != null && caseManagement.getCaseDetails().getCASEPRIORITY() != null) {
            caseMT.setPriority(caseManagement.getCaseDetails().getCASEPRIORITY().getENTITY());
        }
        caseMT.setCustomFields(this.tools.getCustomFieldsTools().readInforCustomFields(caseManagement.getUSERDEFINEDAREA()));
        caseMT.setUserDefinedFields(this.tools.getUDFTools().readInforUserDefinedFields(caseManagement.getStandardUserDefinedFields()));
        if (caseManagement.getCaseDetails() != null && caseManagement.getCaseDetails().getLOCATIONID() != null) {
            caseMT.setLocationCode(caseManagement.getCaseDetails().getLOCATIONID().getLOCATIONCODE());
            caseMT.setLocationDesc(caseManagement.getCaseDetails().getLOCATIONID().getDESCRIPTION());
        }
        if (caseManagement.getTrackingDetails() != null) {
            caseMT.setScheduledStartDate(this.tools.getDataTypeTools().decodeInforDate(caseManagement.getTrackingDetails().getSCHEDULEDSTARTDATE()));
            caseMT.setScheduledEndDate(this.tools.getDataTypeTools().decodeInforDate(caseManagement.getTrackingDetails().getSCHEDULEDENDDATE()));
            caseMT.setRequestedStartDate(this.tools.getDataTypeTools().decodeInforDate(caseManagement.getTrackingDetails().getREQUESTEDSTART()));
            caseMT.setRequestedEndDate(this.tools.getDataTypeTools().decodeInforDate(caseManagement.getTrackingDetails().getREQUESTEDEND()));
            caseMT.setStartDate(this.tools.getDataTypeTools().decodeInforDate(caseManagement.getTrackingDetails().getSTARTDATE()));
            caseMT.setCompletedDate(this.tools.getDataTypeTools().decodeInforDate(caseManagement.getTrackingDetails().getCOMPLETEDDATE()));
            caseMT.setDaterequested(this.tools.getDataTypeTools().decodeInforDate(caseManagement.getTrackingDetails().getDATEREQUESTED()));
        }
        if (caseManagement.getCREATEDBY() != null) {
            caseMT.setCreatedBy(caseManagement.getCREATEDBY().getUSERCODE());
        }
        if (caseManagement.getCREATEDDATE() != null) {
            caseMT.setCreateDate(this.tools.getDataTypeTools().decodeInforDate(caseManagement.getCREATEDDATE()));
        }
        if (caseManagement.getDATEUPDATED() != null) {
            caseMT.setUpdatedDate(this.tools.getDataTypeTools().decodeInforDate(caseManagement.getDATEUPDATED()));
        }
        if (caseManagement.getCaseDetails() != null) {
            caseMT.setEventstartdate(this.tools.getDataTypeTools().decodeInforDate(caseManagement.getCaseDetails().getEVENTSTARTDATE()));
            caseMT.setEventenddate(this.tools.getDataTypeTools().decodeInforDate(caseManagement.getCaseDetails().getEVENTENDDATE()));
        }
        if (caseManagement.getRecordid() != null) {
            caseMT.setUpdateCount(caseManagement.getRecordid());
        }
        return caseMT;
    }

    @Override
    public String createCase(InforContext context, InforCase caseMT) throws InforException {
        CaseManagement caseManagement = new CaseManagement();
        caseManagement.setStandardUserDefinedFields(new StandardUserDefinedFields());
        this.initCaseObject(caseManagement, caseMT, context);
        MP3640_AddCaseManagement_001 addCase = new MP3640_AddCaseManagement_001();
        addCase.setCaseManagement(caseManagement);
        MP3640_AddCaseManagement_001_Result addCaseResult = null;
        addCaseResult = context.getCredentials() != null ? this.inforws.addCaseManagementOp(addCase, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant()) : this.inforws.addCaseManagementOp(addCase, this.tools.getOrganizationCode(context), null, "", new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.applicationData.getTenant());
        return addCaseResult.getResultData().getCASEID().getCASECODE();
    }

    @Override
    public String deleteCase(InforContext context, String caseID) throws InforException {
        MP3642_DeleteCaseManagement_001 deleteCase = new MP3642_DeleteCaseManagement_001();
        deleteCase.setCASEID(new CASEID_Type());
        deleteCase.getCASEID().setCASECODE(caseID);
        deleteCase.getCASEID().setORGANIZATIONID(this.tools.getOrganization(context));
        if (context.getCredentials() != null) {
            this.inforws.deleteCaseManagementOp(deleteCase, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant());
        } else {
            this.inforws.deleteCaseManagementOp(deleteCase, this.tools.getOrganizationCode(context), null, "", new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.applicationData.getTenant());
        }
        return caseID;
    }

    @Override
    public synchronized String updateCase(InforContext context, InforCase caseMT) throws InforException {
        MP3643_GetCaseManagement_001 getCase = new MP3643_GetCaseManagement_001();
        getCase.setCASEID(new CASEID_Type());
        getCase.getCASEID().setCASECODE(caseMT.getCode());
        getCase.getCASEID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP3643_GetCaseManagement_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.getCaseManagementOp(getCase, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant()) : this.inforws.getCaseManagementOp(getCase, this.tools.getOrganizationCode(context), null, "", new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.applicationData.getTenant());
        CaseManagement caseManagement = result.getResultData().getCaseManagement();
        if (caseManagement.getRecordid().longValue() != caseMT.getUpdateCount()) {
            throw this.tools.generateFault("The record has been updated by another user.");
        }
        this.initCaseObject(caseManagement, caseMT, context);
        MP3641_SyncCaseManagement_001 syncCase = new MP3641_SyncCaseManagement_001();
        syncCase.setCaseManagement(caseManagement);
        MP3641_SyncCaseManagement_001_Result syncCaseResult = null;
        syncCaseResult = context.getCredentials() != null ? this.inforws.syncCaseManagementOp(syncCase, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant()) : this.inforws.syncCaseManagementOp(syncCase, this.tools.getOrganizationCode(context), null, "", new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.applicationData.getTenant());
        return syncCaseResult.getResultData().getCASEID().getCASECODE();
    }

    private void initCaseObject(CaseManagement caseInfor, InforCase caseMT, InforContext context) throws InforException {
        if (caseInfor.getCASEID() == null) {
            caseInfor.setCASEID(new CASEID_Type());
            caseInfor.getCASEID().setORGANIZATIONID(this.tools.getOrganization(context));
            caseInfor.getCASEID().setCASECODE("0");
        }
        if (caseMT.getDescription() != null) {
            caseInfor.getCASEID().setDESCRIPTION(caseMT.getDescription());
        }
        if (caseMT.getEquipmentCode() != null) {
            if (caseMT.getEquipmentCode().trim().equals("")) {
                caseInfor.setEQUIPMENTID(null);
            } else {
                caseInfor.setEQUIPMENTID(new EQUIPMENTID_Type());
                caseInfor.getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
                caseInfor.getEQUIPMENTID().setEQUIPMENTCODE(caseMT.getEquipmentCode().toUpperCase().trim());
            }
        }
        if (caseMT.getStatusCode() != null) {
            caseInfor.setSTATUS(new STATUS_Type());
            caseInfor.getSTATUS().setSTATUSCODE(caseMT.getStatusCode().toUpperCase().trim());
            caseInfor.setRSTATUS(new STATUS_Type());
            caseInfor.getRSTATUS().setSTATUSCODE(caseMT.getStatusCode().toUpperCase().trim());
        }
        if (caseMT.getTypeCode() != null) {
            caseInfor.setCASETYPE(new TYPE_Type());
            caseInfor.getCASETYPE().setTYPECODE(caseMT.getTypeCode().toUpperCase().trim());
        }
        if (caseMT.getDepartmentCode() != null) {
            caseInfor.setDEPARTMENTID(new DEPARTMENTID_Type());
            caseInfor.getDEPARTMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            caseInfor.getDEPARTMENTID().setDEPARTMENTCODE(caseMT.getDepartmentCode().toUpperCase().trim());
        }
        if (caseMT.getClassCode() != null) {
            if (caseInfor.getCaseDetails() == null) {
                caseInfor.setCaseDetails(new CaseDetails());
            }
            if (caseInfor.getCaseDetails().getCASECLASSID() == null) {
                caseInfor.getCaseDetails().setCASECLASSID(new CLASSID_Type());
            }
            caseInfor.getCaseDetails().getCASECLASSID().setCLASSCODE(caseMT.getClassCode());
            caseInfor.getCaseDetails().getCASECLASSID().setDESCRIPTION(caseMT.getClassDesc());
            caseInfor.getCaseDetails().getCASECLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            if (caseMT.getPriority() != null) {
                USERDEFINEDCODEID_Type t = new USERDEFINEDCODEID_Type();
                caseInfor.getCaseDetails().setCASEPRIORITY(new USERDEFINEDCODEID_Type());
                caseInfor.getCaseDetails().getCASEPRIORITY().setENTITY(caseMT.getPriority());
            }
        }
        if (caseMT.getWorkaddress() != null) {
            if (caseInfor.getCaseDetails() == null) {
                caseInfor.setCaseDetails(new CaseDetails());
            }
            caseInfor.getCaseDetails().setWORKADDRESS(caseMT.getWorkaddress());
        }
        if (caseMT.getResponsibleCode() != null) {
            if (caseInfor.getTrackingDetails() == null) {
                caseInfor.setTrackingDetails(new TrackingDetails());
            }
            if (caseInfor.getTrackingDetails().getPERSONRESPONSIBLE() == null) {
                caseInfor.getTrackingDetails().setPERSONRESPONSIBLE(new Employee_Type());
            }
            caseInfor.getTrackingDetails().getPERSONRESPONSIBLE().setEMPLOYEECODE(caseMT.getResponsibleCode());
            caseInfor.getTrackingDetails().getPERSONRESPONSIBLE().setDESCRIPTION(caseMT.getResponsibleDesc());
            caseInfor.getTrackingDetails().setEMAIL(caseMT.getResponsibleEMail());
        }
        if (caseMT.getAssignedToCode() != null) {
            if (caseInfor.getTrackingDetails() == null) {
                caseInfor.setTrackingDetails(new TrackingDetails());
            }
            if (caseInfor.getTrackingDetails().getASSIGNEDTO() == null) {
                caseInfor.getTrackingDetails().setASSIGNEDTO(new PERSONID_Type());
            }
            caseInfor.getTrackingDetails().getASSIGNEDTO().setPERSONCODE(caseMT.getAssignedToCode());
            caseInfor.getTrackingDetails().getASSIGNEDTO().setDESCRIPTION(caseMT.getAssignedToDesc());
            caseInfor.getTrackingDetails().setASSIGNEDTOEMAIL(caseMT.getAssignedToEMail());
        }
        if (caseMT.getLocationCode() != null) {
            if (caseInfor.getCaseDetails() == null) {
                caseInfor.setCaseDetails(new CaseDetails());
            }
            if (caseMT.getLocationCode().equals("")) {
                caseInfor.getCaseDetails().setLOCATIONID(null);
            } else {
                caseInfor.getCaseDetails().setLOCATIONID(new LOCATIONID_Type());
                caseInfor.getCaseDetails().getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                caseInfor.getCaseDetails().getLOCATIONID().setLOCATIONCODE(caseMT.getLocationCode().trim());
            }
        }
        this.tools.getUDFTools().updateInforUserDefinedFields(caseInfor.getStandardUserDefinedFields(), caseMT.getUserDefinedFields());
        if (caseMT.getScheduledStartDate() != null) {
            if (caseInfor.getTrackingDetails() == null) {
                caseInfor.setTrackingDetails(new TrackingDetails());
            }
            caseInfor.getTrackingDetails().setSCHEDULEDSTARTDATE(this.tools.getDataTypeTools().encodeInforDate(caseMT.getScheduledStartDate(), "Scheduling Start Date"));
        }
        if (caseMT.getScheduledEndDate() != null) {
            if (caseInfor.getTrackingDetails() == null) {
                caseInfor.setTrackingDetails(new TrackingDetails());
            }
            caseInfor.getTrackingDetails().setSCHEDULEDENDDATE(this.tools.getDataTypeTools().encodeInforDate(caseMT.getScheduledEndDate(), "Scheduling Completed Date"));
        }
        if (caseMT.getRequestedStartDate() != null) {
            if (caseInfor.getTrackingDetails() == null) {
                caseInfor.setTrackingDetails(new TrackingDetails());
            }
            caseInfor.getTrackingDetails().setREQUESTEDSTART(this.tools.getDataTypeTools().encodeInforDate(caseMT.getRequestedStartDate(), "Requested Start Date"));
        }
        if (caseMT.getRequestedEndDate() != null) {
            if (caseInfor.getTrackingDetails() == null) {
                caseInfor.setTrackingDetails(new TrackingDetails());
            }
            caseInfor.getTrackingDetails().setREQUESTEDEND(this.tools.getDataTypeTools().encodeInforDate(caseMT.getRequestedEndDate(), "Requested End Date"));
        }
        if (caseMT.getStartDate() != null) {
            if (caseInfor.getTrackingDetails() == null) {
                caseInfor.setTrackingDetails(new TrackingDetails());
            }
            caseInfor.getTrackingDetails().setSTARTDATE(this.tools.getDataTypeTools().encodeInforDate(caseMT.getStartDate(), "Start Date"));
        }
        if (caseMT.getCompletedDate() != null) {
            if (caseInfor.getTrackingDetails() == null) {
                caseInfor.setTrackingDetails(new TrackingDetails());
            }
            caseInfor.getTrackingDetails().setCOMPLETEDDATE(this.tools.getDataTypeTools().encodeInforDate(caseMT.getCompletedDate(), "Completed Date"));
        }
        if (caseMT.getDaterequested() != null) {
            if (caseInfor.getTrackingDetails() == null) {
                caseInfor.setTrackingDetails(new TrackingDetails());
            }
            caseInfor.getTrackingDetails().setDATEREQUESTED(this.tools.getDataTypeTools().encodeInforDate(caseMT.getDaterequested(), "Requested Date"));
        }
        if (caseMT.getEventstartdate() != null) {
            if (caseInfor.getCaseDetails() == null) {
                caseInfor.setCaseDetails(new CaseDetails());
            }
            caseInfor.getCaseDetails().setEVENTSTARTDATE(this.tools.getDataTypeTools().encodeInforDate(caseMT.getEventstartdate(), "Event Start Date"));
        }
        if (caseMT.getEventenddate() != null) {
            if (caseInfor.getCaseDetails() == null) {
                caseInfor.setCaseDetails(new CaseDetails());
            }
            caseInfor.getCaseDetails().setEVENTENDDATE(this.tools.getDataTypeTools().encodeInforDate(caseMT.getEventenddate(), "Event End Date"));
        }
    }
}

