/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.grids.GridsService;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequest;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestRow;
import ch.cern.eam.wshub.core.services.grids.impl.GridsServiceImpl;
import ch.cern.eam.wshub.core.services.workorders.ChecklistService;
import ch.cern.eam.wshub.core.services.workorders.entities.Activity;
import ch.cern.eam.wshub.core.services.workorders.entities.Finding;
import ch.cern.eam.wshub.core.services.workorders.entities.TaskplanCheckList;
import ch.cern.eam.wshub.core.services.workorders.entities.WorkOrderActivityCheckList;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.BooleanType;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.persistence.EntityManager;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.taskchecklist_001.TaskChecklist;
import net.datastream.schemas.mp_fields.ACTIVITYCODE;
import net.datastream.schemas.mp_fields.ACTIVITYID;
import net.datastream.schemas.mp_fields.ASPECTID_Type;
import net.datastream.schemas.mp_fields.CATEGORYID;
import net.datastream.schemas.mp_fields.CHECKLISTID_Type;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.FINDINGID_Type;
import net.datastream.schemas.mp_fields.POINTTYPEID_Type;
import net.datastream.schemas.mp_fields.TASKLISTID_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_fields.UOMID_Type;
import net.datastream.schemas.mp_fields.USERDEFINEDCODEID_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_functions.mp7913_001.MP7913_SyncWorkOrderActivityCheckList_001;
import net.datastream.schemas.mp_functions.mp7914_001.MP7914_GetWorkOrderActivityCheckList_001;
import net.datastream.schemas.mp_functions.mp7916_001.MP7916_AddTaskChecklist_001;
import net.datastream.schemas.mp_functions.mp8000_001.MP8000_CreateFollowUpWorkOrder_001;
import net.datastream.schemas.mp_results.mp7914_001.MP7914_GetWorkOrderActivityCheckList_001_Result;
import net.datastream.schemas.mp_results.mp8000_001.MP8000_CreateFollowUpWorkOrder_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class ChecklistServiceImpl
implements ChecklistService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private GridsService gridsService;

    public ChecklistServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.gridsService = new GridsServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public String updateWorkOrderChecklist(InforContext context, WorkOrderActivityCheckList workOrderActivityCheckList) throws InforException {
        MP7914_GetWorkOrderActivityCheckList_001 getwoactchl = new MP7914_GetWorkOrderActivityCheckList_001();
        getwoactchl.setCHECKLISTCODE(workOrderActivityCheckList.getCheckListCode());
        MP7914_GetWorkOrderActivityCheckList_001_Result getresult = context.getCredentials() != null ? this.inforws.getWorkOrderActivityCheckListOp(getwoactchl, "*", this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant()) : this.inforws.getWorkOrderActivityCheckListOp(getwoactchl, "*", null, null, new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.applicationData.getTenant());
        net.datastream.schemas.mp_entities.workorderactivitychecklist_001.WorkOrderActivityCheckList workOrderActivityCheckListInfor = getresult.getResultData().getWorkOrderActivityCheckList();
        if (workOrderActivityCheckList.getFollowUp() != null) {
            workOrderActivityCheckListInfor.setFOLLOWUP(this.tools.getDataTypeTools().encodeBoolean(workOrderActivityCheckList.getFollowUp(), BooleanType.PLUS_MINUS));
        }
        switch (workOrderActivityCheckList.getType()) {
            case "01": {
                if ("COMPLETED".equalsIgnoreCase(workOrderActivityCheckList.getResult())) {
                    workOrderActivityCheckListInfor.setCOMPLETED("true");
                    break;
                }
                workOrderActivityCheckListInfor.setCOMPLETED("false");
                break;
            }
            case "02": {
                workOrderActivityCheckListInfor.setYES(String.valueOf("YES".equals(workOrderActivityCheckList.getResult())));
                workOrderActivityCheckListInfor.setNO(String.valueOf("NO".equals(workOrderActivityCheckList.getResult())));
                break;
            }
            case "03": {
                if (workOrderActivityCheckList.getFinding() != null) {
                    workOrderActivityCheckListInfor.setFINDINGID(new FINDINGID_Type());
                    workOrderActivityCheckListInfor.getFINDINGID().setFINDINGCODE(workOrderActivityCheckList.getFinding());
                    break;
                }
                workOrderActivityCheckListInfor.setFINDINGID(null);
                break;
            }
            case "04": {
                workOrderActivityCheckListInfor.setRESULTVALUE(this.tools.getDataTypeTools().encodeQuantity(workOrderActivityCheckList.getResult(), "Checklists Value"));
                break;
            }
            case "05": {
                workOrderActivityCheckListInfor.setRESULTVALUE(this.tools.getDataTypeTools().encodeQuantity(workOrderActivityCheckList.getResult(), "Checklists Value"));
                break;
            }
            case "06": {
                if (workOrderActivityCheckList.getFinding() != null) {
                    workOrderActivityCheckListInfor.setFINDINGID(new FINDINGID_Type());
                    workOrderActivityCheckListInfor.getFINDINGID().setFINDINGCODE(workOrderActivityCheckList.getFinding());
                } else {
                    workOrderActivityCheckListInfor.setFINDINGID(null);
                }
                workOrderActivityCheckListInfor.setRESULTVALUE(this.tools.getDataTypeTools().encodeQuantity(workOrderActivityCheckList.getResult(), "Checklists Value"));
                break;
            }
        }
        if (workOrderActivityCheckList.getNotes() != null) {
            workOrderActivityCheckListInfor.setNOTES(workOrderActivityCheckList.getNotes());
        }
        MP7913_SyncWorkOrderActivityCheckList_001 syncwoactchl = new MP7913_SyncWorkOrderActivityCheckList_001();
        syncwoactchl.setWorkOrderActivityCheckList(workOrderActivityCheckListInfor);
        if (context.getCredentials() != null) {
            this.inforws.syncWorkOrderActivityCheckListOp(syncwoactchl, "*", this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant());
        } else {
            this.inforws.syncWorkOrderActivityCheckListOp(syncwoactchl, "*", null, null, new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.applicationData.getTenant());
        }
        return null;
    }

    @Override
    public String createTaskplanChecklist(InforContext context, TaskplanCheckList taskChecklist) throws InforException {
        TaskChecklist taskChecklistInfor = new TaskChecklist();
        taskChecklistInfor.setTASKLISTID(new TASKLISTID_Type());
        taskChecklistInfor.getTASKLISTID().setORGANIZATIONID(this.tools.getOrganization(context));
        taskChecklistInfor.getTASKLISTID().setTASKCODE(taskChecklist.getTaskPlanCode());
        if (taskChecklist.getTaskPlanRevision() == null) {
            taskChecklistInfor.getTASKLISTID().setTASKREVISION(Long.valueOf(0L));
        } else {
            taskChecklistInfor.getTASKLISTID().setTASKREVISION(Long.valueOf(this.tools.getDataTypeTools().encodeLong(taskChecklist.getTaskPlanRevision(), "Task Revision")));
        }
        taskChecklistInfor.setCHECKLISTID(new CHECKLISTID_Type());
        taskChecklistInfor.getCHECKLISTID().setCHECKLISTCODE("0");
        taskChecklistInfor.getCHECKLISTID().setDESCRIPTION(taskChecklist.getChecklistDesc());
        taskChecklistInfor.setSEQUENCE(this.tools.getDataTypeTools().encodeLong(taskChecklist.getSequence(), "Sequence number"));
        taskChecklistInfor.setTYPE(new TYPE_Type());
        taskChecklistInfor.getTYPE().setTYPECODE(taskChecklist.getType());
        taskChecklistInfor.setREQUIREDTOCLOSEDOC(new USERDEFINEDCODEID_Type());
        taskChecklistInfor.getREQUIREDTOCLOSEDOC().setUSERDEFINEDCODE(taskChecklist.getRequiredEntry());
        taskChecklistInfor.setEQUIPMENTLEVEL(new USERDEFINEDCODEID_Type());
        taskChecklistInfor.getEQUIPMENTLEVEL().setUSERDEFINEDCODE(taskChecklist.getEquipmentLevel());
        if (taskChecklist.getFindings() != null) {
            taskChecklistInfor.setPOSSIBLEFINDINGS(taskChecklist.getFindings());
        }
        if (taskChecklist.getUOM() != null) {
            taskChecklistInfor.setUOMID(new UOMID_Type());
            taskChecklistInfor.getUOMID().setUOMCODE(taskChecklist.getUOM());
        }
        if (taskChecklist.getAspectCode() != null) {
            taskChecklistInfor.setASPECTID(new ASPECTID_Type());
            taskChecklistInfor.getASPECTID().setASPECTCODE(taskChecklist.getAspectCode());
        }
        if (taskChecklist.getPointType() != null) {
            taskChecklistInfor.setPOINTTYPEID(new POINTTYPEID_Type());
            taskChecklistInfor.getPOINTTYPEID().setPOINTTYPECODE(taskChecklist.getPointType());
        }
        taskChecklistInfor.setREPEATINGOCCURRENCES(taskChecklist.getRepeatingOccurrences());
        if (taskChecklist.getFollowUpTaskPlan() != null) {
            taskChecklistInfor.setFOLLOWUPTASKID(new TASKLISTID_Type());
            taskChecklistInfor.getFOLLOWUPTASKID().setORGANIZATIONID(this.tools.getOrganization(context));
            taskChecklistInfor.getFOLLOWUPTASKID().setTASKCODE(taskChecklist.getFollowUpTaskPlan());
            if (taskChecklist.getFollowUpTaskPlanRevision() != null) {
                taskChecklistInfor.getFOLLOWUPTASKID().setTASKREVISION(Long.valueOf(this.tools.getDataTypeTools().encodeLong(taskChecklist.getFollowUpTaskPlanRevision(), "Follow Up Task Plan Revision")));
            } else {
                taskChecklistInfor.getFOLLOWUPTASKID().setTASKREVISION(Long.valueOf(0L));
            }
        }
        if (taskChecklist.getClassCode() != null && !taskChecklist.getClassCode().trim().equals("")) {
            taskChecklistInfor.setCLASSID(new CLASSID_Type());
            taskChecklistInfor.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            taskChecklistInfor.getCLASSID().setCLASSCODE(taskChecklist.getClassCode());
        }
        if (taskChecklist.getCategoryCode() != null && !taskChecklist.getCategoryCode().trim().equals("")) {
            taskChecklistInfor.setCATEGORYID(new CATEGORYID());
            taskChecklistInfor.getCATEGORYID().setCATEGORYCODE(taskChecklist.getCategoryCode());
        }
        MP7916_AddTaskChecklist_001 addTaskChecklist = new MP7916_AddTaskChecklist_001();
        addTaskChecklist.setTaskChecklist(taskChecklistInfor);
        if (context.getCredentials() != null) {
            this.inforws.addTaskChecklistOp(addTaskChecklist, "*", this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant());
        } else {
            this.inforws.addTaskChecklistOp(addTaskChecklist, "*", null, null, new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.applicationData.getTenant());
        }
        return "OK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkOrderActivityCheckList[] readWorkOrderChecklists(InforContext context, Activity activity) throws InforException {
        LinkedList<WorkOrderActivityCheckList> checklists = new LinkedList<WorkOrderActivityCheckList>();
        GridRequest gridRequest = new GridRequest("3315", "WSJOBS_ACK", "3369");
        gridRequest.setRowCount("1000");
        gridRequest.setUseNative(false);
        gridRequest.getParams().put("param.workordernum", activity.getWorkOrderNumber());
        gridRequest.getParams().put("param.activity", activity.getActivityCode());
        gridRequest.getParams().put("param.jobseq", "0");
        GridRequestResult gridRequestResult = this.gridsService.executeQuery(context, gridRequest);
        for (GridRequestRow gridRequestRow : gridRequestResult.getRows()) {
            Finding findingTemp;
            EntityManager em;
            LinkedList<Finding> findings;
            String[] possibleFindings;
            String required;
            WorkOrderActivityCheckList checklistTemp = new WorkOrderActivityCheckList();
            checklistTemp.setWorkOrderCode(activity.getWorkOrderNumber());
            checklistTemp.setActivityCode(activity.getActivityCode());
            checklistTemp.setCheckListCode(GridTools.getCellContent("checklistcode", gridRequestRow));
            checklistTemp.setSequence(GridTools.getCellContent("checklistsequence", gridRequestRow));
            checklistTemp.setEquipmentCode(GridTools.getCellContent("equipment", gridRequestRow));
            checklistTemp.setEquipmentDesc(GridTools.getCellContent("equipmentdesc", gridRequestRow));
            checklistTemp.setType(GridTools.getCellContent("checklisttype", gridRequestRow));
            String followUp = GridTools.getCellContent("followup", gridRequestRow);
            if ("true".equals(followUp)) {
                checklistTemp.setFollowUp("+");
            } else {
                checklistTemp.setFollowUp("-");
            }
            String followUpWorkOrderActivity = GridTools.getCellContent("followupwoactivity", gridRequestRow);
            if (this.tools.getDataTypeTools().isNotEmpty(followUpWorkOrderActivity)) {
                checklistTemp.setFollowUpWorkOrder(followUpWorkOrderActivity.split("-")[0]);
            }
            if ("Yes".equals(required = GridTools.getCellContent("requiredtoclosedocument", gridRequestRow))) {
                checklistTemp.setRequiredToClose(true);
            } else {
                checklistTemp.setRequiredToClose(false);
            }
            checklistTemp.setNotes(GridTools.getCellContent("notes", gridRequestRow));
            checklistTemp.setDesc(GridTools.getCellContent("checklistdescription", gridRequestRow));
            if (checklistTemp.getType().equals("01")) {
                if ("true".equals(GridTools.getCellContent("completed", gridRequestRow))) {
                    checklistTemp.setResult("COMPLETED");
                } else {
                    checklistTemp.setResult(null);
                }
            }
            if (checklistTemp.getType().equals("02")) {
                if (GridTools.getCellContent("yes", gridRequestRow) != null && GridTools.getCellContent("yes", gridRequestRow).equals("true")) {
                    checklistTemp.setResult("YES");
                }
                if (GridTools.getCellContent("no", gridRequestRow) != null && GridTools.getCellContent("no", gridRequestRow).equals("true")) {
                    checklistTemp.setResult("NO");
                }
            }
            if (checklistTemp.getType().equals("03")) {
                checklistTemp.setFinding(GridTools.getCellContent("finding", gridRequestRow));
                possibleFindings = GridTools.getCellContent("possiblefindings", gridRequestRow).split(",");
                findings = new LinkedList<Finding>();
                for (String findingCode : possibleFindings) {
                    em = this.tools.getEntityManager();
                    try {
                        findingTemp = (Finding)em.find(Finding.class, (Object)findingCode);
                        findings.add(findingTemp);
                    }
                    catch (Exception e) {
                        this.tools.log(Level.SEVERE, "Error in readWOActivityChecklists");
                    }
                    finally {
                        em.close();
                    }
                }
                checklistTemp.setPossibleFindings(findings.toArray(new Finding[findings.size()]));
            }
            if (checklistTemp.getType().equals("04")) {
                checklistTemp.setResult(GridTools.getCellContent("value", gridRequestRow));
                checklistTemp.setUOM(GridTools.getCellContent("uom", gridRequestRow));
            }
            if (checklistTemp.getType().equals("05")) {
                checklistTemp.setResult(GridTools.getCellContent("value", gridRequestRow));
                checklistTemp.setUOM(GridTools.getCellContent("uom", gridRequestRow));
            }
            if (checklistTemp.getType().equals("06")) {
                checklistTemp.setResult(GridTools.getCellContent("value", gridRequestRow));
                checklistTemp.setUOM(GridTools.getCellContent("uom", gridRequestRow));
                checklistTemp.setFinding(GridTools.getCellContent("finding", gridRequestRow));
                possibleFindings = GridTools.getCellContent("possiblefindings", gridRequestRow).split(",");
                findings = new LinkedList();
                for (String findingCode : possibleFindings) {
                    em = this.tools.getEntityManager();
                    try {
                        findingTemp = (Finding)em.find(Finding.class, (Object)findingCode);
                        findings.add(findingTemp);
                    }
                    catch (Exception e) {
                        this.tools.log(Level.SEVERE, "Error in readWOActivityChecklists");
                    }
                    finally {
                        em.close();
                    }
                }
                checklistTemp.setPossibleFindings(findings.toArray(new Finding[findings.size()]));
            }
            checklists.add(checklistTemp);
        }
        return checklists.toArray(new WorkOrderActivityCheckList[0]);
    }

    private String getValue(ResultSet v_result) throws SQLException {
        Double value = v_result.getDouble("ack_value");
        if (v_result.wasNull()) {
            return null;
        }
        return Double.toString(value);
    }

    @Override
    public Long createFollowUpWorkOrders(InforContext context, Activity activity) throws InforException {
        Long activityNumber;
        MP8000_CreateFollowUpWorkOrder_001 createFUWO = new MP8000_CreateFollowUpWorkOrder_001();
        try {
            activityNumber = Long.valueOf(activity.getActivityCode());
        }
        catch (Exception e) {
            throw new InforException("Activity code '" + activity.getActivityCode() + "' is not a valid number.", e.getCause(), null);
        }
        createFUWO.setACTIVITYID(new ACTIVITYID());
        createFUWO.getACTIVITYID().setWORKORDERID(new WOID_Type());
        createFUWO.getACTIVITYID().getWORKORDERID().setJOBNUM(activity.getWorkOrderNumber());
        createFUWO.getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
        createFUWO.getACTIVITYID().getACTIVITYCODE().setValue(activityNumber.longValue());
        createFUWO.getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP8000_CreateFollowUpWorkOrder_001_Result createFUWOResult = context.getCredentials() != null ? this.inforws.createFollowUpWorkOrderOp(createFUWO, "*", this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant()) : this.inforws.createFollowUpWorkOrderOp(createFUWO, "*", null, null, new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.applicationData.getTenant());
        return createFUWOResult.getResultData().getWORKORDERCOUNT();
    }
}

