/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.EquipmentWarrantyCoverageService;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.BooleanType;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.warrantycoverage_001.CoverageByDate;
import net.datastream.schemas.mp_entities.warrantycoverage_001.EquipmentWarranty;
import net.datastream.schemas.mp_entities.warrantycoverage_001.WarrantyCoverage;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.WARRANTYID_Type;
import net.datastream.schemas.mp_functions.mp0344_001.MP0344_AddWarrantyCoverage_001;
import net.datastream.schemas.mp_functions.mp0345_001.MP0345_SyncWarrantyCoverage_001;
import net.datastream.schemas.mp_functions.mp3238_001.MP3238_GetWarrantyCoverage_001;
import net.datastream.schemas.mp_results.mp0344_001.MP0344_AddWarrantyCoverage_001_Result;
import net.datastream.schemas.mp_results.mp0345_001.MP0345_SyncWarrantyCoverage_001_Result;
import net.datastream.schemas.mp_results.mp3238_001.MP3238_GetWarrantyCoverage_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class EquipmentWarrantyCoverageServiceImpl
implements EquipmentWarrantyCoverageService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public EquipmentWarrantyCoverageServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createEquipmentWarrantyCoverage(InforContext context, ch.cern.eam.wshub.core.services.equipment.entities.EquipmentWarranty equipmentWarrantyParam) throws InforException {
        EquipmentWarranty equipmentWarranty = new EquipmentWarranty();
        if (equipmentWarrantyParam.getEquipmentCode() != null && !equipmentWarrantyParam.getEquipmentCode().trim().equals("")) {
            equipmentWarranty.setASSETID(new EQUIPMENTID_Type());
            equipmentWarranty.getASSETID().setORGANIZATIONID(this.tools.getOrganization(context));
            equipmentWarranty.getASSETID().setEQUIPMENTCODE(equipmentWarrantyParam.getEquipmentCode());
        }
        if (equipmentWarrantyParam.getWarrantyCode() != null && !equipmentWarrantyParam.getWarrantyCode().trim().equals("")) {
            equipmentWarranty.setWARRANTYID(new WARRANTYID_Type());
            equipmentWarranty.getWARRANTYID().setORGANIZATIONID(this.tools.getOrganization(context));
            equipmentWarranty.getWARRANTYID().setWARRANTYCODE(equipmentWarrantyParam.getWarrantyCode());
        }
        if (equipmentWarrantyParam.getCoverageType() == null || !equipmentWarrantyParam.getCoverageType().toUpperCase().equals("CALENDAR") && !equipmentWarrantyParam.getCoverageType().toUpperCase().equals("D")) {
            throw this.tools.generateFault("Coverage type other than 'Calendar' is not supported. Please contact CMMS Support.");
        }
        equipmentWarranty.setCoverageByDate(new CoverageByDate());
        equipmentWarranty.getCoverageByDate().setSTARTDATE(this.tools.getDataTypeTools().formatDate(equipmentWarrantyParam.getStartDate(), "Start Date"));
        equipmentWarranty.getCoverageByDate().setEXPIRATIONDATE(this.tools.getDataTypeTools().formatDate(equipmentWarrantyParam.getExpirationDate(), "Expiration Date"));
        equipmentWarranty.getCoverageByDate().setWARRANTYDURATIONDAYS(Double.valueOf(this.tools.getDataTypeTools().encodeDouble(equipmentWarrantyParam.getDuration(), "Duration")));
        equipmentWarranty.getCoverageByDate().setTHRESHHOLDDAYS(this.tools.getDataTypeTools().encodeQuantity(equipmentWarrantyParam.getThreshold(), "Threshold"));
        if (equipmentWarrantyParam.getActive() != null) {
            equipmentWarranty.setISWARRANTYACTIVE(this.tools.getDataTypeTools().encodeBoolean(equipmentWarrantyParam.getActive(), BooleanType.TRUE_FALSE));
        } else {
            equipmentWarranty.setISWARRANTYACTIVE("false");
        }
        MP0344_AddWarrantyCoverage_001 addwarrantycoverage = new MP0344_AddWarrantyCoverage_001();
        addwarrantycoverage.setEquipmentWarranty(equipmentWarranty);
        MP0344_AddWarrantyCoverage_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.addWarrantyCoverageOp(addwarrantycoverage, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant()) : this.inforws.addWarrantyCoverageOp(addwarrantycoverage, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.applicationData.getTenant());
        return result.getResultData().getWARRANTYCOVERAGESEQNUM() + "";
    }

    @Override
    public String updateEquipmentWarrantyCoverage(InforContext context, ch.cern.eam.wshub.core.services.equipment.entities.EquipmentWarranty equipmentWarrantyParam) throws InforException {
        MP3238_GetWarrantyCoverage_001 getwarrantycoverege = new MP3238_GetWarrantyCoverage_001();
        MP3238_GetWarrantyCoverage_001_Result getwarrantycoveregeResult = new MP3238_GetWarrantyCoverage_001_Result();
        if (equipmentWarrantyParam.getSequenceNumber() == null) {
            this.tools.demandDatabaseConnection();
            try (EntityManager em = this.tools.getEntityManager();){
                TypedQuery eqwarr = em.createNamedQuery("GETEQPWARRANTY", ch.cern.eam.wshub.core.services.equipment.entities.EquipmentWarranty.class);
                eqwarr.setParameter("equipmentCode", (Object)equipmentWarrantyParam.getEquipmentCode().trim().toUpperCase());
                eqwarr.setParameter("warrantyCode", (Object)equipmentWarrantyParam.getWarrantyCode());
                equipmentWarrantyParam.setSequenceNumber(((ch.cern.eam.wshub.core.services.equipment.entities.EquipmentWarranty)eqwarr.getSingleResult()).getSequenceNumber());
            }
        }
        getwarrantycoverege.setWARRANTYCOVERAGESEQNUM(Long.parseLong(equipmentWarrantyParam.getSequenceNumber()));
        getwarrantycoveregeResult = context.getCredentials() != null ? this.inforws.getWarrantyCoverageOp(getwarrantycoverege, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant()) : this.inforws.getWarrantyCoverageOp(getwarrantycoverege, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.applicationData.getTenant());
        WarrantyCoverage warrantyCoverege = getwarrantycoveregeResult.getResultData().getWarrantyCoverage();
        if (warrantyCoverege.getEquipmentWarranty().getCoverageByDate() != null) {
            if (equipmentWarrantyParam.getStartDate() != null) {
                warrantyCoverege.getEquipmentWarranty().getCoverageByDate().setSTARTDATE(this.tools.getDataTypeTools().formatDate(equipmentWarrantyParam.getStartDate(), "Start Date"));
            }
            if (equipmentWarrantyParam.getExpirationDate() != null) {
                warrantyCoverege.getEquipmentWarranty().getCoverageByDate().setEXPIRATIONDATE(this.tools.getDataTypeTools().formatDate(equipmentWarrantyParam.getExpirationDate(), "Expiration Date"));
            }
            if (equipmentWarrantyParam.getDuration() != null) {
                warrantyCoverege.getEquipmentWarranty().getCoverageByDate().setWARRANTYDURATIONDAYS(Double.valueOf(this.tools.getDataTypeTools().encodeDouble(equipmentWarrantyParam.getDuration(), "Duration")));
            }
            if (equipmentWarrantyParam.getThreshold() != null) {
                warrantyCoverege.getEquipmentWarranty().getCoverageByDate().setTHRESHHOLDDAYS(this.tools.getDataTypeTools().encodeQuantity(equipmentWarrantyParam.getThreshold(), "Threshold"));
            }
        }
        if (warrantyCoverege.getEquipmentWarranty().getCoverageByUsage() != null) {
            // empty if block
        }
        if (equipmentWarrantyParam.getActive() != null) {
            warrantyCoverege.getEquipmentWarranty().setISWARRANTYACTIVE(this.tools.getDataTypeTools().encodeBoolean(equipmentWarrantyParam.getActive(), BooleanType.TRUE_FALSE));
        }
        MP0345_SyncWarrantyCoverage_001 syncwarrantycoverege = new MP0345_SyncWarrantyCoverage_001();
        syncwarrantycoverege.setWarrantyCoverage(warrantyCoverege);
        MP0345_SyncWarrantyCoverage_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.syncWarrantyCoverageOp(syncwarrantycoverege, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.applicationData.getTenant()) : this.inforws.syncWarrantyCoverageOp(syncwarrantycoverege, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.applicationData.getTenant());
        return result.getResultData().getWARRANTYCOVERAGESEQNUM() + "";
    }
}

