/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.material.PartLotService;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.lot_001.Lot;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.LOTID_Type;
import net.datastream.schemas.mp_functions.mp1201_001.MP1201_AddLot_001;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class PartLotServiceImpl
implements PartLotService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public PartLotServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createLot(InforContext context, ch.cern.eam.wshub.core.services.material.entities.Lot lot) throws InforException {
        Lot lotInfor = new Lot();
        lotInfor.setLOTID(new LOTID_Type());
        lotInfor.getLOTID().setLOTCODE(lot.getCode());
        lotInfor.getLOTID().setDESCRIPTION(lot.getDesc());
        lotInfor.getLOTID().setORGANIZATIONID(this.tools.getOrganization(context));
        this.tools.getDataTypeTools();
        if (DataTypeTools.isNotEmpty(lot.getClassCode())) {
            lotInfor.setCLASSID(new CLASSID_Type());
            lotInfor.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            lotInfor.getCLASSID().setCLASSCODE(lot.getClassCode());
        }
        if (lot.getExpirationDate() != null) {
            lotInfor.setEXPIRATIONDATE(this.tools.getDataTypeTools().encodeInforDate(lot.getExpirationDate(), "Lot Expiration Date"));
        }
        if (lot.getManufacturerLot() != null) {
            lotInfor.setMANUFACTLOT(lot.getManufacturerLot());
        }
        MP1201_AddLot_001 addlot = new MP1201_AddLot_001();
        addlot.setLot(lotInfor);
        if (context.getCredentials() != null) {
            this.inforws.addLotOp(addlot, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context));
        } else {
            this.inforws.addLotOp(addlot, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return lot.getCode();
    }
}

