/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.comments.CommentService;
import ch.cern.eam.wshub.core.services.comments.entities.Comment;
import ch.cern.eam.wshub.core.services.comments.impl.CommentServiceImpl;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.workorders.WorkOrderService;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.standardworkorder_001.StandardWorkOrder;
import net.datastream.schemas.mp_entities.workorder_001.UserDefinedFields;
import net.datastream.schemas.mp_entities.workorder_001.WorkOrder;
import net.datastream.schemas.mp_fields.ACTIONCODEID;
import net.datastream.schemas.mp_fields.CAUSECODEID;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.COSTCODEID_Type;
import net.datastream.schemas.mp_fields.DEPARTMENTID_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.FAILURECODEID;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_fields.PERSONID_Type;
import net.datastream.schemas.mp_fields.PRIORITY;
import net.datastream.schemas.mp_fields.PROBLEMCODEID;
import net.datastream.schemas.mp_fields.PROJECTID_Type;
import net.datastream.schemas.mp_fields.ROUTE_Type;
import net.datastream.schemas.mp_fields.STATUS_Type;
import net.datastream.schemas.mp_fields.STDWOID_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_functions.mp0023_001.MP0023_AddWorkOrder_001;
import net.datastream.schemas.mp_functions.mp0024_001.MP0024_GetWorkOrder_001;
import net.datastream.schemas.mp_functions.mp0025_001.MP0025_SyncWorkOrder_001;
import net.datastream.schemas.mp_functions.mp0026_001.MP0026_GetWorkOrderDefault_001;
import net.datastream.schemas.mp_functions.mp0055_001.MP0055_DeleteWorkOrder_001;
import net.datastream.schemas.mp_functions.mp7082_001.MP7082_GetStandardWorkOrder_001;
import net.datastream.schemas.mp_functions.mp7161_001.MP7161_ChangeWorkOrderStatus_001;
import net.datastream.schemas.mp_results.mp0023_001.MP0023_AddWorkOrder_001_Result;
import net.datastream.schemas.mp_results.mp0024_001.MP0024_GetWorkOrder_001_Result;
import net.datastream.schemas.mp_results.mp0026_001.MP0026_GetWorkOrderDefault_001_Result;
import net.datastream.schemas.mp_results.mp0026_001.ResultData;
import net.datastream.schemas.mp_results.mp7082_001.MP7082_GetStandardWorkOrder_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class WorkOrderServiceImpl
implements WorkOrderService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private CommentService comments;

    public WorkOrderServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.comments = new CommentServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public BatchResponse<String> createWorkOrderBatch(InforContext context, List<ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder> workOrderParam) throws InforException {
        List callableList = workOrderParam.stream().map(wo -> () -> this.createWorkOrder(context, (ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder)wo)).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public BatchResponse<ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder> readWorkOrderBatch(InforContext context, List<String> workOrderNumbers) {
        List callableList = workOrderNumbers.stream().map(workOrderNumber -> () -> this.readWorkOrder(context, (String)workOrderNumber)).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public BatchResponse<String> updateWorkOrderBatch(InforContext context, List<ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder> workOrders) throws InforException {
        List callableList = workOrders.stream().map(workOrder -> () -> this.updateWorkOrder(context, (ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder)workOrder)).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public BatchResponse<String> deleteWorkOrderBatch(InforContext context, List<String> workOrderNumbers) throws InforException {
        List callableList = workOrderNumbers.stream().map(workOrderNumber -> () -> this.deleteWorkOrder(context, (String)workOrderNumber)).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder readWorkOrder(InforContext context, String number) throws InforException {
        MP0024_GetWorkOrder_001 getWorkOrder = new MP0024_GetWorkOrder_001();
        WOID_Type woid = new WOID_Type();
        woid.setJOBNUM(number);
        woid.setORGANIZATIONID(this.tools.getOrganization(context));
        getWorkOrder.setWORKORDERID(woid);
        MP0024_GetWorkOrder_001_Result getWOResult = null;
        getWOResult = context.getCredentials() != null ? this.inforws.getWorkOrderOp(getWorkOrder, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.getWorkOrderOp(getWorkOrder, this.tools.getOrganizationCode(context), null, "", new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        WorkOrder inforWorkOrder = getWOResult.getResultData().getWorkOrder();
        ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workOrder = new ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder();
        if (getWOResult.getResultData().getEVENTTYPE() != null) {
            workOrder.setEventType(getWOResult.getResultData().getEVENTTYPE());
        }
        if (inforWorkOrder.getWORKORDERID() != null) {
            workOrder.setDescription(inforWorkOrder.getWORKORDERID().getDESCRIPTION());
            workOrder.setNumber(inforWorkOrder.getWORKORDERID().getJOBNUM());
        }
        if (inforWorkOrder.getCLASSID() != null) {
            workOrder.setClassCode(inforWorkOrder.getCLASSID().getCLASSCODE());
            workOrder.setClassDesc(this.tools.getFieldDescriptionsTools().readClassDesc("EVNT", workOrder.getClassCode()));
        }
        if (inforWorkOrder.getSTATUS() != null) {
            workOrder.setStatusCode(inforWorkOrder.getSTATUS().getSTATUSCODE());
            workOrder.setStatusDesc(inforWorkOrder.getSTATUS().getDESCRIPTION());
        }
        if (inforWorkOrder.getTYPE() != null) {
            workOrder.setTypeCode(inforWorkOrder.getTYPE().getTYPECODE());
            workOrder.setTypeDesc(inforWorkOrder.getTYPE().getDESCRIPTION());
        }
        if (inforWorkOrder.getDEPARTMENTID() != null) {
            workOrder.setDepartmentCode(inforWorkOrder.getDEPARTMENTID().getDEPARTMENTCODE());
            workOrder.setDepartmentDesc(this.tools.getFieldDescriptionsTools().readDepartmentDesc(workOrder.getDepartmentCode()));
        }
        if (inforWorkOrder.getEQUIPMENTID() != null) {
            workOrder.setEquipmentCode(inforWorkOrder.getEQUIPMENTID().getEQUIPMENTCODE());
            workOrder.setEquipmentDesc(inforWorkOrder.getEQUIPMENTID().getDESCRIPTION());
        }
        if (inforWorkOrder.getPROJECTID() != null) {
            workOrder.setProjectCode(inforWorkOrder.getPROJECTID().getPROJECTCODE());
            workOrder.setProjectDesc(inforWorkOrder.getPROJECTID().getDESCRIPTION());
        }
        if (inforWorkOrder.getPRIORITY() != null) {
            workOrder.setPriorityCode(inforWorkOrder.getPRIORITY().getPRIORITYCODE());
            workOrder.setPriorityDesc(inforWorkOrder.getPRIORITY().getDESCRIPTION());
        }
        workOrder.setCustomFields(this.tools.getCustomFieldsTools().readInforCustomFields(inforWorkOrder.getUSERDEFINEDAREA()));
        if (inforWorkOrder.getLOCATIONID() != null) {
            workOrder.setLocationCode(inforWorkOrder.getLOCATIONID().getLOCATIONCODE());
            workOrder.setLocationDesc(inforWorkOrder.getLOCATIONID().getDESCRIPTION());
        }
        if (inforWorkOrder.getPROBLEMCODEID() != null) {
            workOrder.setProblemCode(inforWorkOrder.getPROBLEMCODEID().getPROBLEMCODE());
        }
        if (inforWorkOrder.getREPORTED() != null) {
            workOrder.setReportedDate(this.tools.getDataTypeTools().decodeInforDate(inforWorkOrder.getREPORTED()));
        }
        if (inforWorkOrder.getREQUESTEDSTART() != null) {
            workOrder.setRequestedStartDate(this.tools.getDataTypeTools().decodeInforDate(inforWorkOrder.getREQUESTEDSTART()));
        }
        if (inforWorkOrder.getSTARTDATE() != null) {
            workOrder.setStartDate(this.tools.getDataTypeTools().decodeInforDate(inforWorkOrder.getSTARTDATE()));
        }
        if (inforWorkOrder.getREQUESTEDEND() != null) {
            workOrder.setRequestedEndDate(this.tools.getDataTypeTools().decodeInforDate(inforWorkOrder.getREQUESTEDEND()));
        }
        if (inforWorkOrder.getTARGETDATE() != null) {
            workOrder.setScheduledStartDate(this.tools.getDataTypeTools().decodeInforDate(inforWorkOrder.getTARGETDATE()));
        }
        if (inforWorkOrder.getSCHEDEND() != null) {
            workOrder.setScheduledEndDate(this.tools.getDataTypeTools().decodeInforDate(inforWorkOrder.getSCHEDEND()));
        }
        if (inforWorkOrder.getCOMPLETEDDATE() != null) {
            workOrder.setCompletedDate(this.tools.getDataTypeTools().decodeInforDate(inforWorkOrder.getCOMPLETEDDATE()));
        }
        if (inforWorkOrder.getDUEDATE() != null) {
            workOrder.setDueDate(this.tools.getDataTypeTools().decodeInforDate(inforWorkOrder.getDUEDATE()));
        }
        if (inforWorkOrder.getPROBLEMCODEID() != null) {
            workOrder.setProblemCode(inforWorkOrder.getPROBLEMCODEID().getPROBLEMCODE());
        }
        if (inforWorkOrder.getFAILURECODEID() != null) {
            workOrder.setFailureCode(inforWorkOrder.getFAILURECODEID().getFAILURECODE());
        }
        if (inforWorkOrder.getCAUSECODEID() != null) {
            workOrder.setCauseCode(inforWorkOrder.getCAUSECODEID().getCAUSECODE());
        }
        if (inforWorkOrder.getCOSTCODEID() != null) {
            workOrder.setCostCode(inforWorkOrder.getCOSTCODEID().getCOSTCODE());
            workOrder.setCostCodeDesc(inforWorkOrder.getCOSTCODEID().getDESCRIPTION());
        }
        if (inforWorkOrder.getACTIONCODEID() != null) {
            workOrder.setActionCode(inforWorkOrder.getACTIONCODEID().getACTIONCODE());
        }
        if (inforWorkOrder.getSTANDARDWO() != null) {
            workOrder.setStandardWO(inforWorkOrder.getSTANDARDWO().getSTDWOCODE());
        }
        if (inforWorkOrder.getREQUESTEDBY() != null) {
            workOrder.setReportedBy(inforWorkOrder.getREQUESTEDBY().getPERSONCODE());
            workOrder.setReportedByDesc(this.tools.getFieldDescriptionsTools().readPersonDesc(workOrder.getReportedBy()));
        }
        if (inforWorkOrder.getSCHEDGROUP() != null) {
            workOrder.setAssignedBy(inforWorkOrder.getSCHEDGROUP());
        }
        if (inforWorkOrder.getASSIGNEDTO() != null) {
            workOrder.setAssignedTo(inforWorkOrder.getASSIGNEDTO().getPERSONCODE());
            workOrder.setAssignedToDesc(this.tools.getFieldDescriptionsTools().readPersonDesc(workOrder.getAssignedTo()));
        }
        if (inforWorkOrder.getPARENTWO() != null) {
            workOrder.setParentWO(inforWorkOrder.getPARENTWO().getJOBNUM());
            workOrder.setParentWODesc(inforWorkOrder.getPARENTWO().getDESCRIPTION());
        }
        if (inforWorkOrder.getCREATEDDATE() != null) {
            workOrder.setCreatedDate(this.tools.getDataTypeTools().decodeInforDate(inforWorkOrder.getCREATEDDATE()));
        }
        if (inforWorkOrder.getTARGETVALUE() != null) {
            workOrder.setTargetValue(this.tools.getDataTypeTools().decodeAmount(inforWorkOrder.getTARGETVALUE()));
        }
        if (inforWorkOrder.getDOWNTIMEHOURS() != null) {
            workOrder.setDowntimeHours(this.tools.getDataTypeTools().decodeQuantity(inforWorkOrder.getDOWNTIMEHOURS()));
        }
        workOrder.setUpdateCount(inforWorkOrder.getRecordid().toString());
        workOrder.setUserDefinedFields(this.tools.getUDFTools().readInforUserDefinedFields(inforWorkOrder.getUserDefinedFields()));
        return workOrder;
    }

    @Override
    public ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder readWorkOrderDefault(InforContext context, String number) throws InforException {
        MP0026_GetWorkOrderDefault_001 getWorkOrderDefault = new MP0026_GetWorkOrderDefault_001();
        getWorkOrderDefault.setORGANIZATIONID(new ORGANIZATIONID_Type());
        getWorkOrderDefault.getORGANIZATIONID().setORGANIZATIONCODE(context.getOrganizationCode());
        MP0026_GetWorkOrderDefault_001_Result getWODefaultResult = null;
        getWODefaultResult = context.getCredentials() != null ? this.inforws.getWorkOrderDefaultOp(getWorkOrderDefault, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.getWorkOrderDefaultOp(getWorkOrderDefault, this.tools.getOrganizationCode(context), null, "", new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        ResultData resultData = getWODefaultResult.getResultData();
        ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workOrder = new ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder();
        if (resultData.getSTATUS() != null) {
            workOrder.setStatusCode(resultData.getSTATUS().getSTATUSCODE());
        }
        if (resultData.getTYPE() != null) {
            workOrder.setTypeCode(resultData.getTYPE().getTYPECODE());
        }
        if (resultData.getTARGETDATE() != null) {
            workOrder.setScheduledStartDate(this.tools.getDataTypeTools().decodeInforDate(resultData.getTARGETDATE()));
        }
        if (resultData.getSCHEDEND() != null) {
            workOrder.setScheduledEndDate(this.tools.getDataTypeTools().decodeInforDate(resultData.getSCHEDEND()));
        }
        if (resultData.getREPORTED() != null) {
            workOrder.setReportedDate(this.tools.getDataTypeTools().decodeInforDate(resultData.getREPORTED()));
        }
        return workOrder;
    }

    @Override
    public ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder readStandardWorkOrder(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workorderParam) throws InforException {
        if (workorderParam.getStandardWO() != null && !workorderParam.getStandardWO().trim().equals("")) {
            MP7082_GetStandardWorkOrder_001 getStandardWorkOrder = new MP7082_GetStandardWorkOrder_001();
            getStandardWorkOrder.setSTANDARDWO(new STDWOID_Type());
            getStandardWorkOrder.getSTANDARDWO().setORGANIZATIONID(this.tools.getOrganization(context));
            getStandardWorkOrder.getSTANDARDWO().setSTDWOCODE(workorderParam.getStandardWO());
            MP7082_GetStandardWorkOrder_001_Result getSWOResult = context.getCredentials() != null ? this.inforws.getStandardWorkOrderOp(getStandardWorkOrder, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.getStandardWorkOrderOp(getStandardWorkOrder, this.tools.getOrganizationCode(context), null, "", new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
            StandardWorkOrder standardWO = getSWOResult.getResultData().getStandardWorkOrder();
            workorderParam.setDescription(standardWO.getSTANDARDWO() != null ? standardWO.getSTANDARDWO().getDESCRIPTION() : workorderParam.getDescription());
            workorderParam.setPriorityCode(standardWO.getPRIORITY() != null ? standardWO.getPRIORITY().getPRIORITYCODE() : workorderParam.getPriorityCode());
            workorderParam.setPriorityDesc(standardWO.getPRIORITY() != null ? standardWO.getPRIORITY().getDESCRIPTION() : workorderParam.getPriorityDesc());
            workorderParam.setProblemCode(standardWO.getPROBLEMCODEID() != null ? standardWO.getPROBLEMCODEID().getPROBLEMCODE() : workorderParam.getProblemCode());
            workorderParam.setClassCode(standardWO.getWORKORDERCLASSID() != null ? standardWO.getWORKORDERCLASSID().getCLASSCODE() : workorderParam.getClassCode());
            workorderParam.setClassDesc(standardWO.getWORKORDERCLASSID() != null ? standardWO.getWORKORDERCLASSID().getDESCRIPTION() : workorderParam.getClassDesc());
            workorderParam.setTypeCode(standardWO.getWORKORDERTYPE() != null ? standardWO.getWORKORDERTYPE().getTYPECODE() : workorderParam.getTypeCode());
            workorderParam.setTypeDesc(standardWO.getWORKORDERTYPE() != null ? standardWO.getWORKORDERTYPE().getDESCRIPTION() : workorderParam.getTypeDesc());
            workorderParam.setUserDefinedFields(this.tools.getUDFTools().readInforUserDefinedFields(standardWO.getUserDefinedFields()));
        }
        return workorderParam;
    }

    @Override
    public String createWorkOrder(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workorderParam) throws InforException {
        WorkOrder inforWorkOrder = new WorkOrder();
        if (workorderParam.getCustomFields() != null && workorderParam.getCustomFields().length > 0) {
            if (workorderParam.getClassCode() != null && !workorderParam.getClassCode().trim().equals("")) {
                inforWorkOrder.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getCustomFields(context, "EVNT", workorderParam.getClassCode()));
            } else {
                inforWorkOrder.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getCustomFields(context, "EVNT", "*"));
            }
        }
        inforWorkOrder.setUserDefinedFields(new UserDefinedFields());
        this.initializeInforWOObject(inforWorkOrder, workorderParam, context);
        if (workorderParam.getStandardWO() != null && !workorderParam.getStandardWO().trim().equals("")) {
            MP7082_GetStandardWorkOrder_001 getStandardWorkOrder = new MP7082_GetStandardWorkOrder_001();
            getStandardWorkOrder.setSTANDARDWO(new STDWOID_Type());
            getStandardWorkOrder.getSTANDARDWO().setORGANIZATIONID(this.tools.getOrganization(context));
            getStandardWorkOrder.getSTANDARDWO().setSTDWOCODE(workorderParam.getStandardWO());
            MP7082_GetStandardWorkOrder_001_Result getSWOResult = context.getCredentials() != null ? this.inforws.getStandardWorkOrderOp(getStandardWorkOrder, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.getStandardWorkOrderOp(getStandardWorkOrder, this.tools.getOrganizationCode(context), null, "", new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
            StandardWorkOrder standardWO = getSWOResult.getResultData().getStandardWorkOrder();
            inforWorkOrder.setPERMITREVIEWEDBY(standardWO.getPERMITREVIEWEDBY());
            if (workorderParam.getPriorityCode() == null) {
                inforWorkOrder.setPRIORITY(standardWO.getPRIORITY());
            }
            inforWorkOrder.setPROBLEMCODEID(standardWO.getPROBLEMCODEID());
            inforWorkOrder.setSAFETYREVIEWEDBY(standardWO.getSAFETYREVIEWEDBY());
            inforWorkOrder.setSTANDARDWO(standardWO.getSTANDARDWO());
            inforWorkOrder.setUSERDEFINEDAREA(standardWO.getUSERDEFINEDAREA());
            inforWorkOrder.setCLASSID(standardWO.getWORKORDERCLASSID());
            inforWorkOrder.setTYPE(standardWO.getWORKORDERTYPE());
            workorderParam.setUserDefinedFields(this.tools.getUDFTools().readInforUserDefinedFields(standardWO.getUserDefinedFields()));
        }
        MP0023_AddWorkOrder_001 addWO = new MP0023_AddWorkOrder_001();
        addWO.setWorkOrder(inforWorkOrder);
        inforWorkOrder.setFIXED("V");
        MP0023_AddWorkOrder_001_Result result = context.getCredentials() != null ? this.inforws.addWorkOrderOp(addWO, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.addWorkOrderOp(addWO, this.tools.getOrganizationCode(context), null, "", new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        if (workorderParam.getComment() != null && !workorderParam.getComment().trim().equals("")) {
            Comment comment = new Comment();
            comment.setEntityCode("EVNT");
            comment.setEntityKeyCode(result.getResultData().getJOBNUM());
            comment.setText(workorderParam.getComment());
            comment.setTypeCode("*");
            this.comments.createComment(context, comment);
        }
        return result.getResultData().getJOBNUM();
    }

    @Override
    public String updateWorkOrder(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workorderParam) throws InforException {
        MP0024_GetWorkOrder_001 req = new MP0024_GetWorkOrder_001();
        WOID_Type woid = new WOID_Type();
        woid.setJOBNUM(workorderParam.getNumber());
        woid.setORGANIZATIONID(this.tools.getOrganization(context));
        req.setWORKORDERID(woid);
        MP0024_GetWorkOrder_001_Result getWOResult = context.getCredentials() != null ? this.inforws.getWorkOrderOp(req, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.getWorkOrderOp(req, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        WorkOrder inforWorkOrder = getWOResult.getResultData().getWorkOrder();
        if (!(workorderParam.getClassCode() == null || inforWorkOrder.getCLASSID() != null && workorderParam.getClassCode().toUpperCase().equals(inforWorkOrder.getCLASSID().getCLASSCODE()))) {
            inforWorkOrder.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getCustomFields(context, "EVNT", workorderParam.getClassCode().toUpperCase()));
        }
        this.initializeInforWOObject(inforWorkOrder, workorderParam, context);
        MP0025_SyncWorkOrder_001 syncWO = new MP0025_SyncWorkOrder_001();
        syncWO.setWorkOrder(inforWorkOrder);
        if (context.getCredentials() != null) {
            this.inforws.syncWorkOrderOp(syncWO, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context));
        } else {
            this.inforws.syncWorkOrderOp(syncWO, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        }
        return inforWorkOrder.getWORKORDERID().getJOBNUM();
    }

    private void initializeInforWOObject(WorkOrder inforWorkOrder, ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workorderParam, InforContext context) throws InforException {
        if (inforWorkOrder.getWORKORDERID() == null) {
            inforWorkOrder.setWORKORDERID(new WOID_Type());
            inforWorkOrder.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
            inforWorkOrder.getWORKORDERID().setJOBNUM("0");
        }
        if (workorderParam.getDescription() != null) {
            inforWorkOrder.getWORKORDERID().setDESCRIPTION(workorderParam.getDescription());
        }
        if (workorderParam.getClassCode() != null) {
            if (workorderParam.getClassCode().trim().equals("")) {
                inforWorkOrder.setCLASSID(null);
            } else {
                inforWorkOrder.setCLASSID(new CLASSID_Type());
                inforWorkOrder.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
                inforWorkOrder.getCLASSID().setCLASSCODE(workorderParam.getClassCode().toUpperCase().trim());
            }
        }
        if (workorderParam.getStatusCode() != null) {
            inforWorkOrder.setSTATUS(new STATUS_Type());
            inforWorkOrder.getSTATUS().setSTATUSCODE(workorderParam.getStatusCode().trim());
        }
        if (workorderParam.getTypeCode() != null) {
            inforWorkOrder.setTYPE(new TYPE_Type());
            inforWorkOrder.getTYPE().setTYPECODE(workorderParam.getTypeCode().toUpperCase().trim());
        }
        if (workorderParam.getDepartmentCode() != null) {
            inforWorkOrder.setDEPARTMENTID(new DEPARTMENTID_Type());
            inforWorkOrder.getDEPARTMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            inforWorkOrder.getDEPARTMENTID().setDEPARTMENTCODE(workorderParam.getDepartmentCode().toUpperCase().trim());
        }
        if (workorderParam.getEquipmentCode() != null) {
            if (workorderParam.getEquipmentCode().trim().equals("")) {
                inforWorkOrder.setEQUIPMENTID(null);
            } else {
                inforWorkOrder.setEQUIPMENTID(new EQUIPMENTID_Type());
                inforWorkOrder.getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
                inforWorkOrder.getEQUIPMENTID().setEQUIPMENTCODE(workorderParam.getEquipmentCode().toUpperCase().trim());
            }
        }
        if (workorderParam.getProjectCode() != null) {
            if (workorderParam.getProjectCode().trim().equals("")) {
                inforWorkOrder.setPROJECTID(null);
            } else {
                inforWorkOrder.setPROJECTID(new PROJECTID_Type());
                inforWorkOrder.getPROJECTID().setORGANIZATIONID(this.tools.getOrganization(context));
                inforWorkOrder.getPROJECTID().setPROJECTCODE(workorderParam.getProjectCode().trim());
            }
        }
        if (workorderParam.getPriorityCode() != null) {
            inforWorkOrder.setPRIORITY(new PRIORITY());
            inforWorkOrder.getPRIORITY().setPRIORITYCODE(workorderParam.getPriorityCode().toUpperCase().trim());
        }
        if (workorderParam.getReportedDate() != null) {
            if (workorderParam.getReportedDate().getTime() == 0L) {
                inforWorkOrder.setREPORTED(null);
            } else {
                inforWorkOrder.setREPORTED(this.tools.getDataTypeTools().encodeInforDate(workorderParam.getReportedDate(), "Reported Date"));
            }
        }
        if (workorderParam.getRequestedStartDate() != null) {
            if (workorderParam.getRequestedStartDate().getTime() == 0L) {
                inforWorkOrder.setREQUESTEDSTART(null);
            } else {
                inforWorkOrder.setREQUESTEDSTART(this.tools.getDataTypeTools().encodeInforDate(workorderParam.getRequestedStartDate(), "Requested Start Date"));
            }
        }
        if (workorderParam.getRequestedEndDate() != null) {
            if (workorderParam.getRequestedEndDate().getTime() == 0L) {
                inforWorkOrder.setREQUESTEDEND(null);
            } else {
                inforWorkOrder.setREQUESTEDEND(this.tools.getDataTypeTools().encodeInforDate(workorderParam.getRequestedEndDate(), "Requested End Date"));
            }
        }
        if (workorderParam.getScheduledStartDate() != null) {
            if (workorderParam.getScheduledStartDate().getTime() == 0L) {
                inforWorkOrder.setTARGETDATE(null);
            } else {
                inforWorkOrder.setTARGETDATE(this.tools.getDataTypeTools().encodeInforDate(workorderParam.getScheduledStartDate(), "Scheduling Start Date"));
            }
        }
        if (workorderParam.getScheduledEndDate() != null) {
            if (workorderParam.getScheduledEndDate().getTime() == 0L) {
                inforWorkOrder.setSCHEDEND(null);
            } else {
                inforWorkOrder.setSCHEDEND(this.tools.getDataTypeTools().encodeInforDate(workorderParam.getScheduledEndDate(), "Scheduling End Date"));
            }
        }
        if (workorderParam.getStartDate() != null) {
            if (workorderParam.getStartDate().getTime() == 0L) {
                inforWorkOrder.setSTARTDATE(null);
            } else {
                inforWorkOrder.setSTARTDATE(this.tools.getDataTypeTools().encodeInforDate(workorderParam.getStartDate(), "Start Date"));
            }
        }
        if (workorderParam.getCompletedDate() != null) {
            inforWorkOrder.setCOMPLETEDDATE(this.tools.getDataTypeTools().encodeInforDate(workorderParam.getCompletedDate(), "Completed Date"));
        }
        if (workorderParam.getDueDate() != null) {
            inforWorkOrder.setDUEDATE(this.tools.getDataTypeTools().encodeInforDate(workorderParam.getDueDate(), "Due Date"));
        }
        this.tools.getCustomFieldsTools().updateInforCustomFields(inforWorkOrder.getUSERDEFINEDAREA(), workorderParam.getCustomFields());
        this.tools.getUDFTools().updateInforUserDefinedFields(inforWorkOrder.getUserDefinedFields(), workorderParam.getUserDefinedFields());
        if (workorderParam.getProblemCode() != null) {
            inforWorkOrder.setPROBLEMCODEID(new PROBLEMCODEID());
            inforWorkOrder.getPROBLEMCODEID().setPROBLEMCODE(workorderParam.getProblemCode().toUpperCase());
        }
        if (workorderParam.getFailureCode() != null) {
            if (workorderParam.getFailureCode().trim().equals("")) {
                inforWorkOrder.setFAILURECODEID(null);
            } else {
                inforWorkOrder.setFAILURECODEID(new FAILURECODEID());
                inforWorkOrder.getFAILURECODEID().setFAILURECODE(workorderParam.getFailureCode().toUpperCase().trim());
            }
        }
        if (workorderParam.getCauseCode() != null) {
            inforWorkOrder.setCAUSECODEID(new CAUSECODEID());
            inforWorkOrder.getCAUSECODEID().setCAUSECODE(workorderParam.getCauseCode().toUpperCase().trim());
        }
        if (workorderParam.getActionCode() != null) {
            inforWorkOrder.setACTIONCODEID(new ACTIONCODEID());
            inforWorkOrder.getACTIONCODEID().setACTIONCODE(workorderParam.getActionCode().toUpperCase().trim());
        }
        if (workorderParam.getCostCode() != null) {
            inforWorkOrder.setCOSTCODEID(new COSTCODEID_Type());
            inforWorkOrder.getCOSTCODEID().setCOSTCODE(workorderParam.getCostCode().toUpperCase().trim());
        }
        if (workorderParam.getLocationCode() != null) {
            inforWorkOrder.setLOCATIONID(new LOCATIONID_Type());
            inforWorkOrder.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
            inforWorkOrder.getLOCATIONID().setLOCATIONCODE(workorderParam.getLocationCode().toUpperCase().trim());
        }
        if (workorderParam.getAssignedBy() != null) {
            inforWorkOrder.setSCHEDGROUP(workorderParam.getAssignedBy());
        }
        if (workorderParam.getReportedBy() != null) {
            inforWorkOrder.setREQUESTEDBY(new PERSONID_Type());
            inforWorkOrder.getREQUESTEDBY().setPERSONCODE(workorderParam.getReportedBy());
        }
        if (workorderParam.getAssignedTo() != null) {
            inforWorkOrder.setASSIGNEDTO(new PERSONID_Type());
            inforWorkOrder.getASSIGNEDTO().setPERSONCODE(workorderParam.getAssignedTo());
        }
        if (workorderParam.getStandardWO() != null) {
            inforWorkOrder.setSTANDARDWO(new STDWOID_Type());
            inforWorkOrder.getSTANDARDWO().setORGANIZATIONID(this.tools.getOrganization(context));
            inforWorkOrder.getSTANDARDWO().setSTDWOCODE(workorderParam.getStandardWO().toUpperCase().trim());
        }
        if (workorderParam.getRoute() != null) {
            if (workorderParam.getRoute().equals("")) {
                inforWorkOrder.setROUTE(null);
            } else {
                inforWorkOrder.setROUTE(new ROUTE_Type());
                inforWorkOrder.getROUTE().setORGANIZATIONID(this.tools.getOrganization(context));
                inforWorkOrder.getROUTE().setROUTECODE(workorderParam.getRoute());
                inforWorkOrder.getROUTE().setROUTEREVISION(Long.valueOf(0L));
            }
        }
        if (workorderParam.getCreatedDate() != null) {
            inforWorkOrder.setCREATEDDATE(this.tools.getDataTypeTools().encodeInforDate(workorderParam.getCreatedDate(), "Created Date"));
        }
        if (workorderParam.getParentWO() != null) {
            inforWorkOrder.setPARENTWO(new WOID_Type());
            inforWorkOrder.getPARENTWO().setORGANIZATIONID(this.tools.getOrganization(context));
            inforWorkOrder.getPARENTWO().setJOBNUM(workorderParam.getParentWO().trim());
        }
        if (workorderParam.getProjectBudget() != null) {
            inforWorkOrder.setPROJBUD(workorderParam.getProjectBudget());
        }
        if (workorderParam.getTargetValue() != null) {
            inforWorkOrder.setTARGETVALUE(this.tools.getDataTypeTools().encodeAmount(workorderParam.getTargetValue(), "Target Value"));
        }
        if (workorderParam.getDowntimeHours() != null) {
            inforWorkOrder.setDOWNTIMEHOURS(this.tools.getDataTypeTools().encodeQuantity(workorderParam.getDowntimeHours(), "Downtime Hours"));
        }
    }

    @Override
    public String deleteWorkOrder(InforContext context, String workOrderNumber) throws InforException {
        MP0055_DeleteWorkOrder_001 deleteWO = new MP0055_DeleteWorkOrder_001();
        deleteWO.setWORKORDERID(new WOID_Type());
        deleteWO.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        deleteWO.getWORKORDERID().setJOBNUM(workOrderNumber);
        if (context.getCredentials() != null) {
            this.inforws.deleteWorkOrderOp(deleteWO, "*", this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context));
        } else {
            this.inforws.deleteWorkOrderOp(deleteWO, "*", null, null, new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        }
        return workOrderNumber;
    }

    @Override
    public String updateWorkOrderStatus(InforContext context, String workOrderNumber, String statusCode) throws InforException {
        MP7161_ChangeWorkOrderStatus_001 changeWOStatus = new MP7161_ChangeWorkOrderStatus_001();
        changeWOStatus.setWORKORDERID(new WOID_Type());
        changeWOStatus.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        changeWOStatus.getWORKORDERID().setJOBNUM(workOrderNumber);
        changeWOStatus.setNEWSTATUS(new STATUS_Type());
        changeWOStatus.getNEWSTATUS().setSTATUSCODE(statusCode);
        if (context.getCredentials() != null) {
            this.inforws.changeWorkOrderStatusOp(changeWOStatus, "*", this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context));
        } else {
            this.inforws.changeWorkOrderStatusOp(changeWOStatus, "*", null, null, new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        }
        return workOrderNumber;
    }
}

