/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.tools;

import ch.cern.eam.wshub.core.annotations.GridField;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestCell;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestResult;
import ch.cern.eam.wshub.core.services.grids.entities.GridRequestRow;
import ch.cern.eam.wshub.core.tools.Tools;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class GridTools {
    private Tools tools;

    public GridTools(Tools tools) {
        this.tools = tools;
    }

    public List<Map<String, String>> convertGridResultToMapList(List<String> columns, GridRequestResult gridRequestResult) {
        return Arrays.stream(gridRequestResult.getRows()).map(gridRequestRow -> Arrays.stream(gridRequestRow.getCell()).filter(cell -> columns.contains(cell.getCol()) || columns.contains(cell.getTag())).filter(cell -> cell.getContent() != null).collect(Collectors.toMap(GridRequestCell::getCol, GridRequestCell::getContent))).collect(Collectors.toList());
    }

    public <T> Map<String, T> convertGridResultToMap(Class<T> clazz, String key, Map<String, String> columns, GridRequestResult gridRequestResult) {
        HashMap<String, T> result = new HashMap<String, T>();
        if (gridRequestResult == null || gridRequestResult.getRows() == null) {
            return result;
        }
        for (GridRequestRow gridRequestRow : gridRequestResult.getRows()) {
            result.put(GridTools.getCellContent(key, gridRequestRow), this.convertCellListToObject(clazz, columns, Arrays.asList(gridRequestRow.getCell())));
        }
        return result;
    }

    public static Map<String, String> convertGridResultToMap(String key, String value, GridRequestResult gridRequestResult) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (gridRequestResult == null || gridRequestResult.getRows() == null) {
            return result;
        }
        for (GridRequestRow gridRequestRow : gridRequestResult.getRows()) {
            result.put(GridTools.getCellContent(key, gridRequestRow), GridTools.getCellContent(value, gridRequestRow));
        }
        return result;
    }

    public <T> List<T> converGridResultToObject(Class<T> clazz, Map<String, String> columns, GridRequestResult gridRequestResult) {
        LinkedList<T> result = new LinkedList<T>();
        if (gridRequestResult == null || gridRequestResult.getRows() == null) {
            return result;
        }
        for (GridRequestRow gridRequestRow : gridRequestResult.getRows()) {
            result.add(this.convertCellListToObject(clazz, columns, Arrays.asList(gridRequestRow.getCell())));
        }
        return result;
    }

    private <T> T convertCellListToObject(Class<T> clazz, Map<String, String> columns, List<GridRequestCell> gridRequestCellList) {
        if (columns == null) {
            return this.convertCellListToObjectAnnotation(clazz, gridRequestCellList);
        }
        return this.convertCellListToObjectMap(clazz, columns, gridRequestCellList);
    }

    private <T> T convertCellListToObjectMap(Class<T> clazz, Map<String, String> columns, List<GridRequestCell> gridRequestCellList) {
        try {
            T object = clazz.newInstance();
            for (String column : columns.keySet()) {
                Field field = object.getClass().getDeclaredField(columns.get(column));
                this.setValue(object, field, column, gridRequestCellList);
            }
            return object;
        }
        catch (Exception exception) {
            this.tools.log(Level.SEVERE, exception.getMessage());
            return null;
        }
    }

    private <T> T convertCellListToObjectAnnotation(Class<T> clazz, List<GridRequestCell> gridRequestCellList) {
        try {
            T object = clazz.newInstance();
            for (Field field : object.getClass().getDeclaredFields()) {
                GridField gridFieldAnnotation = field.getAnnotation(GridField.class);
                if (gridFieldAnnotation == null) continue;
                this.setValue(object, field, gridFieldAnnotation.name(), gridRequestCellList);
            }
            return object;
        }
        catch (Exception exception) {
            this.tools.log(Level.SEVERE, exception.getMessage());
            return null;
        }
    }

    private <T> void setValue(T object, Field field, String column, List<GridRequestCell> gridRequestCellList) throws Exception {
        String value = gridRequestCellList.stream().filter(cell -> cell.getCol().equals(column) || cell.getTag().equals(column)).filter(cell -> cell.getContent() != null).map(GridRequestCell::getContent).findFirst().orElse(null);
        field.setAccessible(true);
        if (field.getType() == Date.class) {
            field.set(object, this.tools.getDataTypeTools().convertStringToDate(value));
        } else if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            field.set(object, "true".equals(value));
        } else {
            field.set(object, value);
        }
    }

    public static String getCellContent(String cellid, GridRequestRow gridRequestRow) {
        if (gridRequestRow == null || gridRequestRow.getCell() == null) {
            return null;
        }
        return Arrays.stream(gridRequestRow.getCell()).filter(cell -> cell.getTag().equalsIgnoreCase(cellid) || cell.getCol().equalsIgnoreCase(cellid)).filter(cell -> cell.getContent() != null).map(GridRequestCell::getContent).findFirst().orElse(null);
    }
}

