/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.tools;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.entities.BatchSingleResponse;
import ch.cern.eam.wshub.core.services.entities.Credentials;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.CustomFieldsTools;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.ExceptionInfo;
import ch.cern.eam.wshub.core.tools.FieldDescriptionTools;
import ch.cern.eam.wshub.core.tools.GridTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.UserDefinedFieldsTools;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import javax.xml.ws.soap.SOAPFaultException;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_functions.MessageConfigType;
import net.datastream.schemas.mp_functions.MessageItemConfigType;
import net.datastream.schemas.mp_functions.SessionType;
import net.datastream.wsdls.inforws.InforWebServicesPT;
import org.w3c.dom.NodeList;
import org.xmlsoap.schemas.ws._2002._04.secext.ObjectFactory;
import org.xmlsoap.schemas.ws._2002._04.secext.Password;
import org.xmlsoap.schemas.ws._2002._04.secext.Security;
import org.xmlsoap.schemas.ws._2002._04.secext.Username;
import org.xmlsoap.schemas.ws._2002._04.secext.UsernameToken;

public class Tools {
    private ApplicationData applicationData;
    private InforWebServicesPT inforws;
    private ExecutorService executorService;
    private DataSource dataSource;
    private EntityManagerFactory entityManagerFactory;
    private Logger logger;
    private CustomFieldsTools customFieldsTools;
    private DataTypeTools dataTypeTools;
    private UserDefinedFieldsTools udfTools;
    private FieldDescriptionTools fieldDescriptionsTools;
    private GridTools gridTools;

    public Tools(ApplicationData applicationData, InforWebServicesPT inforWebServicesToolkitClient, ExecutorService executorService, DataSource dataSource, EntityManagerFactory entityManagerFactory, Logger logger) {
        this.applicationData = applicationData;
        this.inforws = inforWebServicesToolkitClient;
        this.executorService = executorService;
        this.dataSource = dataSource;
        this.entityManagerFactory = entityManagerFactory;
        this.customFieldsTools = new CustomFieldsTools(this, applicationData, this.inforws);
        this.dataTypeTools = new DataTypeTools(this);
        this.udfTools = new UserDefinedFieldsTools(this);
        this.fieldDescriptionsTools = new FieldDescriptionTools(this);
        this.gridTools = new GridTools(this);
        this.logger = logger;
    }

    public EntityManager getEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public CustomFieldsTools getCustomFieldsTools() {
        return this.customFieldsTools;
    }

    public DataTypeTools getDataTypeTools() {
        return this.dataTypeTools;
    }

    public UserDefinedFieldsTools getUDFTools() {
        return this.udfTools;
    }

    public FieldDescriptionTools getFieldDescriptionsTools() {
        return this.fieldDescriptionsTools;
    }

    public GridTools getGridTools() {
        return this.gridTools;
    }

    public void log(Level logLevel, String message) {
        if (this.logger != null) {
            this.logger.log(logLevel, message);
        }
    }

    public Security createSecurityHeader(InforContext context) throws InforException {
        ObjectFactory of = new ObjectFactory();
        Security security = of.createSecurity();
        Username un = of.createUsername();
        un.setValue(context.getCredentials().getUsername().toUpperCase());
        Password pass = of.createPassword();
        pass.setValue(context.getCredentials().getPassword());
        UsernameToken unt = of.createUsernameToken();
        unt.setPassword(pass);
        unt.setUsername(un);
        security.getAny().add(unt);
        return security;
    }

    public SessionType createInforSession(InforContext context) {
        SessionType session = new SessionType();
        session.setSessionId(context.getSessionID());
        return session;
    }

    public MessageConfigType createMessageConfig() {
        MessageConfigType messageConfigType = new MessageConfigType();
        MessageItemConfigType returnAlertsMessageItemConfigType = new MessageItemConfigType();
        returnAlertsMessageItemConfigType.setName("returnAlerts");
        returnAlertsMessageItemConfigType.setValue("false");
        messageConfigType.getConfigItem().add(returnAlertsMessageItemConfigType);
        return messageConfigType;
    }

    public ORGANIZATIONID_Type getOrganization(InforContext inforContext) {
        ORGANIZATIONID_Type org = new ORGANIZATIONID_Type();
        if (inforContext != null && inforContext.getOrganizationCode() != null) {
            org.setORGANIZATIONCODE(inforContext.getOrganizationCode());
        } else {
            org.setORGANIZATIONCODE(this.applicationData.getOrganization());
        }
        return org;
    }

    public String getOrganizationCode(InforContext inforContext) {
        if (inforContext != null && inforContext.getOrganizationCode() != null) {
            return inforContext.getOrganizationCode();
        }
        return this.applicationData.getOrganization();
    }

    public String getTenant(InforContext inforContext) {
        if (inforContext != null && inforContext.getTenant() != null) {
            return inforContext.getTenant();
        }
        return this.applicationData.getTenant();
    }

    public InforException generateFault(String reason) {
        return new InforException(reason, null, null);
    }

    public InforException generateFault(String reason, ExceptionInfo[] errors) {
        return new InforException(reason, null, errors);
    }

    public <T> BatchResponse<T> processCallables(List<Callable<T>> mylist) {
        List responseList = null;
        try {
            List<Future<T>> result = this.executorService.invokeAll(mylist);
            responseList = result.stream().map(future -> {
                try {
                    return new BatchSingleResponse(future.get(), null);
                }
                catch (ExecutionException exception) {
                    if (exception.getCause() instanceof SOAPFaultException) {
                        SOAPFaultException soapFaultException = (SOAPFaultException)exception.getCause();
                        return new BatchSingleResponse<Object>(null, this.decodeExceptionInfoList(soapFaultException));
                    }
                    return new BatchSingleResponse<Object>(null, exception.getCause().getMessage());
                }
                catch (Exception exception) {
                    return new BatchSingleResponse<Object>(null, "Server error");
                }
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BatchResponse response = new BatchResponse();
        response.setResponseList(responseList);
        return response;
    }

    public void processRunnables(List<Runnable> mylist) throws InforException {
        try {
            this.executorService.invokeAll(mylist.stream().map(runnable -> Executors.callable(runnable)).collect(Collectors.toList()));
        }
        catch (Exception exception) {
            this.log(Level.SEVERE, "Error during Tools.processRunnables() execution: " + exception.getMessage());
        }
    }

    private String decodeExceptionInfoList(SOAPFaultException soapFaultException) {
        String errorMessage = soapFaultException.getMessage();
        try {
            NodeList nodeList = soapFaultException.getFault().getDetail().getFirstChild().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                errorMessage = errorMessage + ", " + nodeList.item(i).getFirstChild().getLastChild().getTextContent();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return errorMessage;
    }

    public InforContext getInforContext(Credentials credentials, String sessionID) {
        if (credentials != null) {
            return new InforContext(credentials);
        }
        return new InforContext(sessionID);
    }

    public InforContext getInforContext(Credentials credentials) {
        return new InforContext(credentials);
    }

    public void closeConnection(Connection connection, Statement statement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log(Level.SEVERE, "Couldn't close the DB connection: " + e.getMessage());
        }
    }

    public void demandDatabaseConnection() throws InforException {
        if (this.entityManagerFactory == null || this.getDataSource() == null) {
            throw this.generateFault("This operation requires DB connection.");
        }
    }

    public boolean isDatabaseConnectionConfigured() {
        return this.entityManagerFactory != null && this.getDataSource() != null;
    }
}

