/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.PositionService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.positionequipment_001.FacilityConditionIndex;
import net.datastream.schemas.mp_entities.positionequipment_001.ManufacturerInfo;
import net.datastream.schemas.mp_entities.positionequipment_001.PositionEquipment;
import net.datastream.schemas.mp_entities.positionequipment_001.UserDefinedFields;
import net.datastream.schemas.mp_entities.positionequipment_001.Variables;
import net.datastream.schemas.mp_entities.positionhierarchy_002.AssetDependency;
import net.datastream.schemas.mp_entities.positionhierarchy_002.LocationDependency;
import net.datastream.schemas.mp_entities.positionhierarchy_002.NonDependentParents_Type;
import net.datastream.schemas.mp_entities.positionhierarchy_002.PositionDependency;
import net.datastream.schemas.mp_entities.positionhierarchy_002.PositionParentHierarchy;
import net.datastream.schemas.mp_entities.positionhierarchy_002.PrimarySystemDependency;
import net.datastream.schemas.mp_entities.positionhierarchy_002.SystemDependency;
import net.datastream.schemas.mp_fields.ASSETPARENT_Type;
import net.datastream.schemas.mp_fields.CATEGORYID;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.COSTCODEID_Type;
import net.datastream.schemas.mp_fields.CRITICALITYID_Type;
import net.datastream.schemas.mp_fields.DEPARTMENTID_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.LINEARREFERENCEDETAILS_Type;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import net.datastream.schemas.mp_fields.LOCATIONPARENT_Type;
import net.datastream.schemas.mp_fields.OBJECT_Type;
import net.datastream.schemas.mp_fields.PERSONID_Type;
import net.datastream.schemas.mp_fields.POSITIONPARENT_Type;
import net.datastream.schemas.mp_fields.STATUS_Type;
import net.datastream.schemas.mp_fields.SYSTEMPARENT_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_functions.mp0306_001.MP0306_AddPositionEquipment_001;
import net.datastream.schemas.mp_functions.mp0307_001.MP0307_GetPositionEquipment_001;
import net.datastream.schemas.mp_functions.mp0308_001.MP0308_SyncPositionEquipment_001;
import net.datastream.schemas.mp_functions.mp0309_001.MP0309_DeletePositionEquipment_001;
import net.datastream.schemas.mp_functions.mp0328_002.MP0328_GetPositionParentHierarchy_002;
import net.datastream.schemas.mp_results.mp0306_001.MP0306_AddPositionEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0307_001.MP0307_GetPositionEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0328_002.MP0328_GetPositionParentHierarchy_002_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class PositionServiceImpl
implements PositionService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public PositionServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createPosition(InforContext context, Equipment positionParam) throws InforException {
        PositionEquipment positionEquipment = new PositionEquipment();
        if (positionParam.getCustomFields() != null && positionParam.getCustomFields().length > 0) {
            if (positionParam.getClassCode() != null && !positionParam.getClassCode().trim().equals("")) {
                positionEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getCustomFields(context, "OBJ", positionParam.getClassCode()));
            } else {
                positionEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getCustomFields(context, "OBJ", "*"));
            }
        }
        positionEquipment.setUserDefinedFields(new UserDefinedFields());
        this.initializePositionObject(context, positionEquipment, positionParam, true);
        MP0306_AddPositionEquipment_001 addPosition = new MP0306_AddPositionEquipment_001();
        addPosition.setPositionEquipment(positionEquipment);
        MP0306_AddPositionEquipment_001_Result result = context.getCredentials() != null ? this.inforws.addPositionEquipmentOp(addPosition, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.addPositionEquipmentOp(addPosition, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return result.getResultData().getPOSITIONID().getEQUIPMENTCODE();
    }

    @Override
    public String deletePosition(InforContext context, String positionCode) throws InforException {
        MP0309_DeletePositionEquipment_001 deletePosition = new MP0309_DeletePositionEquipment_001();
        deletePosition.setPOSITIONID(new EQUIPMENTID_Type());
        deletePosition.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        deletePosition.getPOSITIONID().setEQUIPMENTCODE(positionCode);
        if (context.getCredentials() != null) {
            this.inforws.deletePositionEquipmentOp(deletePosition, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
        } else {
            this.inforws.deletePositionEquipmentOp(deletePosition, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return positionCode;
    }

    private PositionParentHierarchy readInforPositionParentHierarchy(InforContext context, String assetCode) throws InforException {
        MP0328_GetPositionParentHierarchy_002 getpositionph = new MP0328_GetPositionParentHierarchy_002();
        getpositionph.setPOSITIONID(new EQUIPMENTID_Type());
        getpositionph.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        getpositionph.getPOSITIONID().setEQUIPMENTCODE(assetCode);
        MP0328_GetPositionParentHierarchy_002_Result result = context.getCredentials() != null ? this.inforws.getPositionParentHierarchyOp(getpositionph, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.getPositionParentHierarchyOp(getpositionph, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return result.getResultData().getPositionParentHierarchy();
    }

    @Override
    public Equipment readPosition(InforContext context, String positionCode) throws InforException {
        MP0307_GetPositionEquipment_001 getPosition = new MP0307_GetPositionEquipment_001();
        getPosition.setPOSITIONID(new EQUIPMENTID_Type());
        getPosition.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        getPosition.getPOSITIONID().setEQUIPMENTCODE(positionCode);
        MP0307_GetPositionEquipment_001_Result getPositionResult = new MP0307_GetPositionEquipment_001_Result();
        getPositionResult = context.getCredentials() != null ? this.inforws.getPositionEquipmentOp(getPosition, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.getPositionEquipmentOp(getPosition, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        PositionEquipment positionEquipment = getPositionResult.getResultData().getPositionEquipment();
        Equipment position = new Equipment();
        if (positionEquipment.getPOSITIONID() != null) {
            position.setCode(positionEquipment.getPOSITIONID().getEQUIPMENTCODE());
            position.setDescription(positionEquipment.getPOSITIONID().getDESCRIPTION());
        }
        if (positionEquipment.getEQUIPMENTALIAS() != null) {
            position.setAlias(positionEquipment.getEQUIPMENTALIAS());
        }
        if (positionEquipment.getSTATUS() != null) {
            position.setStatusCode(positionEquipment.getSTATUS().getSTATUSCODE());
            position.setStatusDesc(positionEquipment.getSTATUS().getDESCRIPTION());
        }
        if (positionEquipment.getTYPE() != null) {
            position.setTypeCode(positionEquipment.getTYPE().getTYPECODE());
            position.setTypeDesc(positionEquipment.getTYPE().getDESCRIPTION());
        }
        if (positionEquipment.getCLASSID() != null) {
            position.setClassCode(positionEquipment.getCLASSID().getCLASSCODE());
            position.setClassDesc(positionEquipment.getCLASSID().getDESCRIPTION());
        }
        if (positionEquipment.getCATEGORYID() != null) {
            position.setCategoryCode(positionEquipment.getCATEGORYID().getCATEGORYCODE());
            position.setCategoryDesc(positionEquipment.getCATEGORYID().getDESCRIPTION());
        }
        if (positionEquipment.getASSIGNEDTO() != null) {
            position.setAssignedTo(positionEquipment.getASSIGNEDTO().getPERSONCODE());
            position.setAssignedToDesc(this.tools.getFieldDescriptionsTools().readPersonDesc(position.getAssignedTo()));
        }
        if (positionEquipment.getDEPARTMENTID() != null) {
            position.setDepartmentCode(positionEquipment.getDEPARTMENTID().getDEPARTMENTCODE());
            position.setDepartmentDesc(positionEquipment.getDEPARTMENTID().getDESCRIPTION());
        }
        if (positionEquipment.getCRITICALITYID() != null) {
            position.setCriticality(positionEquipment.getCRITICALITYID().getCRITICALITY());
        }
        if (positionEquipment.getCOMMISSIONDATE() != null) {
            position.setComissionDate(this.tools.getDataTypeTools().decodeInforDate(positionEquipment.getCOMMISSIONDATE()));
        }
        if (positionEquipment.getManufacturerInfo() != null) {
            position.setManufacturerCode(positionEquipment.getManufacturerInfo().getMANUFACTURERCODE());
            position.setSerialNumber(positionEquipment.getManufacturerInfo().getSERIALNUMBER());
            position.setModel(positionEquipment.getManufacturerInfo().getMODEL());
            position.setManufacturerDesc(this.tools.getFieldDescriptionsTools().readManufacturerDesc(position.getManufacturerCode()));
        }
        position.setCustomFields(this.tools.getCustomFieldsTools().readInforCustomFields(positionEquipment.getUSERDEFINEDAREA()));
        position.setUserDefinedFields(this.tools.getUDFTools().readInforUserDefinedFields(positionEquipment.getUserDefinedFields()));
        positionEquipment.setPositionParentHierarchy(this.readInforPositionParentHierarchy(context, positionCode));
        if (positionEquipment.getPositionParentHierarchy().getLOCATIONID() != null) {
            position.setHierarchyLocationCode(positionEquipment.getPositionParentHierarchy().getLOCATIONID().getLOCATIONCODE());
            position.setHierarchyLocationDesc(positionEquipment.getPositionParentHierarchy().getLOCATIONID().getDESCRIPTION());
        }
        if (positionEquipment.getPositionParentHierarchy().getPositionDependency() != null) {
            PositionDependency positionDep = positionEquipment.getPositionParentHierarchy().getPositionDependency();
            position.setHierarchyPositionCode(positionDep.getDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
            position.setHierarchyPositionDesc(positionDep.getDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
            position.setHierarchyPositionDependent("true");
            position.setHierarchyPositionCostRollUp(positionDep.getDEPENDENTPOSITION().getCOSTROLLUP());
            if (positionDep.getNONDEPENDENTASSET() != null) {
                position.setHierarchyAssetCode(positionDep.getNONDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
                position.setHierarchyAssetDesc(positionDep.getNONDEPENDENTASSET().getASSETID().getDESCRIPTION());
                position.setHierarchyAssetCostRollUp(positionDep.getNONDEPENDENTASSET().getCOSTROLLUP());
                position.setHierarchyAssetDependent("false");
            }
            if (positionDep.getNONDEPENDENTPRIMARYSYSTEM() != null) {
                position.setHierarchyPrimarySystemCode(positionDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
                position.setHierarchyPrimarySystemDesc(positionDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
                position.setHierarchyPrimarySystemCostRollUp(positionDep.getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP());
                position.setHierarchyPrimarySystemDependent("false");
            }
        } else if (positionEquipment.getPositionParentHierarchy().getAssetDependency() != null) {
            AssetDependency assetDep = positionEquipment.getPositionParentHierarchy().getAssetDependency();
            position.setHierarchyAssetCode(assetDep.getDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
            position.setHierarchyAssetDesc(assetDep.getDEPENDENTASSET().getASSETID().getDESCRIPTION());
            position.setHierarchyAssetCostRollUp(assetDep.getDEPENDENTASSET().getCOSTROLLUP());
            position.setHierarchyAssetDependent("true");
            if (assetDep.getNONDEPENDENTPOSITION() != null) {
                position.setHierarchyPositionCode(assetDep.getNONDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
                position.setHierarchyPositionDesc(assetDep.getNONDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
                position.setHierarchyPositionDependent("false");
                position.setHierarchyPositionCostRollUp(assetDep.getNONDEPENDENTPOSITION().getCOSTROLLUP());
            }
            if (assetDep.getNONDEPENDENTPRIMARYSYSTEM() != null) {
                position.setHierarchyPrimarySystemCode(assetDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
                position.setHierarchyPrimarySystemDesc(assetDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
                position.setHierarchyPrimarySystemCostRollUp(assetDep.getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP());
                position.setHierarchyPrimarySystemDependent("false");
            }
        } else if (positionEquipment.getPositionParentHierarchy().getSystemDependency() != null) {
            SystemDependency systemDep = positionEquipment.getPositionParentHierarchy().getSystemDependency();
            position.setHierarchyPrimarySystemCode(systemDep.getDEPENDENTSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
            position.setHierarchyPrimarySystemDesc(systemDep.getDEPENDENTSYSTEM().getSYSTEMID().getDESCRIPTION());
            position.setHierarchyPrimarySystemCostRollUp(systemDep.getDEPENDENTSYSTEM().getCOSTROLLUP());
            position.setHierarchyPrimarySystemDependent("true");
            if (systemDep.getNONDEPENDENTPOSITION() != null) {
                position.setHierarchyPositionCode(systemDep.getNONDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
                position.setHierarchyPositionDesc(systemDep.getNONDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
                position.setHierarchyPositionDependent("false");
                position.setHierarchyPositionCostRollUp(systemDep.getNONDEPENDENTPOSITION().getCOSTROLLUP());
            }
            if (systemDep.getNONDEPENDENTASSET() != null) {
                position.setHierarchyAssetCode(systemDep.getNONDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
                position.setHierarchyAssetDesc(systemDep.getNONDEPENDENTASSET().getASSETID().getDESCRIPTION());
                position.setHierarchyAssetCostRollUp(systemDep.getNONDEPENDENTASSET().getCOSTROLLUP());
                position.setHierarchyAssetDependent("false");
            }
        } else if (positionEquipment.getPositionParentHierarchy().getNonDependentParents() != null) {
            NonDependentParents_Type nonDepParents = positionEquipment.getPositionParentHierarchy().getNonDependentParents();
            if (nonDepParents.getNONDEPENDENTASSET() != null) {
                position.setHierarchyAssetCode(nonDepParents.getNONDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
                position.setHierarchyAssetDesc(nonDepParents.getNONDEPENDENTASSET().getASSETID().getDESCRIPTION());
                position.setHierarchyAssetCostRollUp(nonDepParents.getNONDEPENDENTASSET().getCOSTROLLUP());
                position.setHierarchyAssetDependent("false");
            }
            if (nonDepParents.getNONDEPENDENTPOSITION() != null) {
                position.setHierarchyPositionCode(nonDepParents.getNONDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
                position.setHierarchyPositionDesc(nonDepParents.getNONDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
                position.setHierarchyPositionDependent("false");
                position.setHierarchyPositionCostRollUp(nonDepParents.getNONDEPENDENTPOSITION().getCOSTROLLUP());
            }
            if (nonDepParents.getNONDEPENDENTPRIMARYSYSTEM() != null) {
                position.setHierarchyPrimarySystemCode(nonDepParents.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
                position.setHierarchyPrimarySystemDesc(nonDepParents.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
                position.setHierarchyPrimarySystemCostRollUp(nonDepParents.getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP());
                position.setHierarchyPrimarySystemDependent("false");
            }
        } else if (positionEquipment.getPositionParentHierarchy().getLocationDependency() != null) {
            LocationDependency locationDep = positionEquipment.getPositionParentHierarchy().getLocationDependency();
            position.setHierarchyLocationCode(locationDep.getDEPENDENTLOCATION().getLOCATIONID().getLOCATIONCODE());
            position.setHierarchyLocationDesc(locationDep.getDEPENDENTLOCATION().getLOCATIONID().getDESCRIPTION());
            if (locationDep.getNONDEPENDENTASSET() != null) {
                position.setHierarchyAssetCode(locationDep.getNONDEPENDENTASSET().getASSETID().getEQUIPMENTCODE());
                position.setHierarchyAssetDesc(locationDep.getNONDEPENDENTASSET().getASSETID().getDESCRIPTION());
                position.setHierarchyAssetCostRollUp(locationDep.getNONDEPENDENTASSET().getCOSTROLLUP());
                position.setHierarchyAssetDependent("false");
            }
            if (locationDep.getNONDEPENDENTPOSITION() != null) {
                position.setHierarchyPositionCode(locationDep.getNONDEPENDENTPOSITION().getPOSITIONID().getEQUIPMENTCODE());
                position.setHierarchyPositionDesc(locationDep.getNONDEPENDENTPOSITION().getPOSITIONID().getDESCRIPTION());
                position.setHierarchyPositionDependent("false");
                position.setHierarchyPositionCostRollUp(locationDep.getNONDEPENDENTPOSITION().getCOSTROLLUP());
            }
            if (locationDep.getNONDEPENDENTPRIMARYSYSTEM() != null) {
                position.setHierarchyPrimarySystemCode(locationDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
                position.setHierarchyPrimarySystemDesc(locationDep.getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
                position.setHierarchyPrimarySystemCostRollUp(locationDep.getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP());
                position.setHierarchyPrimarySystemDependent("false");
            }
        }
        if (positionEquipment.getVariables() != null) {
            position.setVariable1(positionEquipment.getVariables().getVARIABLE1());
            position.setVariable2(positionEquipment.getVariables().getVARIABLE2());
            position.setVariable3(positionEquipment.getVariables().getVARIABLE3());
            position.setVariable4(positionEquipment.getVariables().getVARIABLE4());
            position.setVariable5(positionEquipment.getVariables().getVARIABLE5());
            position.setVariable6(positionEquipment.getVariables().getVARIABLE6());
        }
        position.setInProduction(positionEquipment.getINPRODUCTION());
        return position;
    }

    private PositionEquipment readInforPosition(InforContext context, String positionCode) throws InforException {
        MP0307_GetPositionEquipment_001 getPosition = new MP0307_GetPositionEquipment_001();
        getPosition.setPOSITIONID(new EQUIPMENTID_Type());
        getPosition.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        getPosition.getPOSITIONID().setEQUIPMENTCODE(positionCode);
        MP0307_GetPositionEquipment_001_Result getAssetResult = new MP0307_GetPositionEquipment_001_Result();
        getAssetResult = context.getCredentials() != null ? this.inforws.getPositionEquipmentOp(getPosition, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.getPositionEquipmentOp(getPosition, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return getAssetResult.getResultData().getPositionEquipment();
    }

    @Override
    public String updatePosition(InforContext context, Equipment positionParam) throws InforException {
        PositionEquipment positionEquipment = this.readInforPosition(context, positionParam.getCode());
        if (!(positionParam.getClassCode() == null || positionEquipment.getCLASSID() != null && positionParam.getClassCode().toUpperCase().equals(positionEquipment.getCLASSID().getCLASSCODE()))) {
            positionEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getCustomFields(context, "OBJ", positionParam.getClassCode().toUpperCase()));
        }
        this.initializePositionObject(context, positionEquipment, positionParam, false);
        MP0308_SyncPositionEquipment_001 syncPosition = new MP0308_SyncPositionEquipment_001();
        syncPosition.setPositionEquipment(positionEquipment);
        if (context.getCredentials() != null) {
            this.inforws.syncPositionEquipmentOp(syncPosition, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
        } else {
            this.inforws.syncPositionEquipmentOp(syncPosition, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return positionParam.getCode();
    }

    private void initializePositionObject(InforContext context, PositionEquipment positionInfor, Equipment positionParam, boolean creationRequest) throws InforException {
        if (positionInfor.getPOSITIONID() == null) {
            positionInfor.setPOSITIONID(new EQUIPMENTID_Type());
            positionInfor.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context));
            positionInfor.getPOSITIONID().setEQUIPMENTCODE(positionParam.getCode().toUpperCase().trim());
        }
        if (positionParam.getAlias() != null) {
            positionInfor.setEQUIPMENTALIAS(positionParam.getAlias());
        }
        if (positionParam.getDescription() != null) {
            positionInfor.getPOSITIONID().setDESCRIPTION(positionParam.getDescription());
        }
        if (positionParam.getStatusCode() != null) {
            positionInfor.setSTATUS(new STATUS_Type());
            positionInfor.getSTATUS().setSTATUSCODE(positionParam.getStatusCode().toUpperCase().trim());
        }
        if (positionParam.getClassCode() != null) {
            if (positionParam.getClassCode().trim().equals("")) {
                positionInfor.setCLASSID(null);
            } else {
                positionInfor.setCLASSID(new CLASSID_Type());
                positionInfor.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
                positionInfor.getCLASSID().setCLASSCODE(positionParam.getClassCode().toUpperCase().trim());
            }
        }
        if (positionParam.getCategoryCode() != null) {
            positionInfor.setCATEGORYID(new CATEGORYID());
            positionInfor.getCATEGORYID().setCATEGORYCODE(positionParam.getCategoryCode().toUpperCase().trim());
        }
        if (positionParam.getComissionDate() != null) {
            positionInfor.setCOMMISSIONDATE(this.tools.getDataTypeTools().encodeInforDate(positionParam.getComissionDate(), "Comissioning Date"));
        }
        if (positionParam.getCostCode() != null) {
            positionInfor.setCOSTCODEID(new COSTCODEID_Type());
            positionInfor.getCOSTCODEID().setCOSTCODE(positionParam.getCostCode().toUpperCase().trim());
        }
        if (positionParam.getCriticality() != null) {
            positionInfor.setCRITICALITYID(new CRITICALITYID_Type());
            positionInfor.getCRITICALITYID().setCRITICALITY(positionParam.getCriticality().toUpperCase().trim());
        }
        if (positionParam.getDepartmentCode() != null) {
            positionInfor.setDEPARTMENTID(new DEPARTMENTID_Type());
            positionInfor.getDEPARTMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            positionInfor.getDEPARTMENTID().setDEPARTMENTCODE(positionParam.getDepartmentCode().toUpperCase().trim());
        }
        if (positionParam.getProfileCode() != null) {
            positionInfor.setPROFILEID(new OBJECT_Type());
            positionInfor.getPROFILEID().setORGANIZATIONID(this.tools.getOrganization(context));
            positionInfor.getPROFILEID().setOBJECTCODE(positionParam.getProfileCode());
        }
        if (positionParam.getManufacturerCode() != null || positionParam.getSerialNumber() != null || positionParam.getModel() != null || positionParam.getRevision() != null || positionParam.getxCoordinate() != null || positionParam.getyCoordinate() != null || positionParam.getzCoordinate() != null) {
            if (positionInfor.getManufacturerInfo() == null) {
                positionInfor.setManufacturerInfo(new ManufacturerInfo());
            }
            if (positionParam.getManufacturerCode() != null) {
                positionInfor.getManufacturerInfo().setMANUFACTURERCODE(positionParam.getManufacturerCode().toUpperCase());
            }
            if (positionParam.getModel() != null) {
                positionInfor.getManufacturerInfo().setMODEL(positionParam.getModel());
            }
            if (positionParam.getRevision() != null) {
                positionInfor.getManufacturerInfo().setMODELREVISION(positionParam.getRevision());
            }
            if (positionParam.getSerialNumber() != null) {
                positionInfor.getManufacturerInfo().setSERIALNUMBER(positionParam.getSerialNumber());
            }
            if (positionParam.getxCoordinate() != null) {
                positionInfor.getManufacturerInfo().setXCOORDINATE(this.tools.getDataTypeTools().encodeQuantity(positionParam.getxCoordinate(), "X-Coordinate"));
            }
            if (positionParam.getyCoordinate() != null) {
                positionInfor.getManufacturerInfo().setYCOORDINATE(this.tools.getDataTypeTools().encodeQuantity(positionParam.getyCoordinate(), "Y-Coordinate"));
            }
            if (positionParam.getzCoordinate() != null) {
                positionInfor.getManufacturerInfo().setZCOORDINATE(this.tools.getDataTypeTools().encodeQuantity(positionParam.getzCoordinate(), "Z-Coordiante"));
            }
        }
        if (positionParam.getUpdateCount() != null) {
            positionInfor.setRecordid(Long.decode(positionParam.getUpdateCount()));
        }
        if (positionParam.getMeterUnit() != null) {
            positionInfor.setMETERUNIT(positionParam.getMeterUnit());
        }
        if (positionParam.getEquipmentValue() != null) {
            // empty if block
        }
        if (positionParam.getLinearRefGeographicalRef() != null || positionParam.getLinearRefEquipmentLength() != null || positionParam.getLinearRefEquipmentLengthUOM() != null || positionParam.getLinearRefPrecision() != null || positionParam.getLinearRefUOM() != null) {
            positionInfor.setLINEARREFERENCEDETAILS(new LINEARREFERENCEDETAILS_Type());
            positionInfor.getLINEARREFERENCEDETAILS().setEQUIPMENTLENGTH(this.tools.getDataTypeTools().encodeQuantity(positionParam.getLinearRefEquipmentLength(), "Linear Ref. Equipment Length"));
            positionInfor.getLINEARREFERENCEDETAILS().setEQUIPMENTLENGTHUOM(positionParam.getLinearRefEquipmentLengthUOM());
            positionInfor.getLINEARREFERENCEDETAILS().setGEOGRAPHICALREFERENCE(positionParam.getLinearRefGeographicalRef());
            positionInfor.getLINEARREFERENCEDETAILS().setLINEARREFPRECISION(this.tools.getDataTypeTools().encodeBigInteger(positionParam.getLinearRefPrecision(), "Linear Ref. Precision"));
            positionInfor.getLINEARREFERENCEDETAILS().setLINEARREFUOM(positionParam.getLinearRefUOM());
        }
        if (positionParam.getAssignedTo() != null) {
            if (positionParam.getAssignedTo().trim().equals("")) {
                positionInfor.setASSIGNEDTO(null);
            } else {
                positionInfor.setASSIGNEDTO(new PERSONID_Type());
                positionInfor.getASSIGNEDTO().setPERSONCODE(positionParam.getAssignedTo());
            }
        }
        if (positionParam.getcGMP() != null) {
            positionInfor.setCGMP(positionParam.getcGMP());
        }
        if (positionParam.getDormantStart() != null || positionParam.getDormantEnd() != null || positionParam.getDormantReusePeriod() != null) {
            positionInfor.setDORMANT(new PositionEquipment.DORMANT());
            positionInfor.getDORMANT().setDORMANTSTART(this.tools.getDataTypeTools().formatDate(positionParam.getDormantStart(), "Dormant Start"));
            positionInfor.getDORMANT().setDORMANTEND(this.tools.getDataTypeTools().formatDate(positionParam.getDormantEnd(), "Dormant End"));
            positionInfor.getDORMANT().setDORMANTREUSE(positionParam.getDormantReusePeriod());
        }
        if (positionInfor.getVariables() == null) {
            positionInfor.setVariables(new Variables());
        }
        if (positionParam.getVariable1() != null) {
            positionInfor.getVariables().setVARIABLE1(positionParam.getVariable1());
        }
        if (positionParam.getVariable2() != null) {
            positionInfor.getVariables().setVARIABLE2(positionParam.getVariable2());
        }
        if (positionParam.getVariable3() != null) {
            positionInfor.getVariables().setVARIABLE3(positionParam.getVariable3());
        }
        if (positionParam.getVariable4() != null) {
            positionInfor.getVariables().setVARIABLE4(positionParam.getVariable4());
        }
        if (positionParam.getVariable5() != null) {
            positionInfor.getVariables().setVARIABLE5(positionParam.getVariable5());
        }
        if (positionParam.getVariable6() != null) {
            positionInfor.getVariables().setVARIABLE6(positionParam.getVariable6());
        }
        this.tools.getCustomFieldsTools().updateInforCustomFields(positionInfor.getUSERDEFINEDAREA(), positionParam.getCustomFields());
        this.tools.getUDFTools().updateInforUserDefinedFields(positionInfor.getUserDefinedFields(), positionParam.getUserDefinedFields());
        if (positionParam.getCostOfNeededRepairs() != null || positionParam.getReplacementValue() != null || positionParam.getFacilityConditionIndex() != null || positionParam.getServiceLifetime() != null || positionParam.getYearBuilt() != null) {
            if (positionInfor.getFacilityConditionIndex() == null) {
                positionInfor.setFacilityConditionIndex(new FacilityConditionIndex());
            }
            if (positionParam.getCostOfNeededRepairs() != null) {
                positionInfor.getFacilityConditionIndex().setCOSTOFNEEDEDREPAIRS(this.tools.getDataTypeTools().encodeAmount(positionParam.getCostOfNeededRepairs(), "Cost of Needed Repairs"));
            }
            if (positionParam.getReplacementValue() != null) {
                positionInfor.getFacilityConditionIndex().setREPLACEMENTVALUE(this.tools.getDataTypeTools().encodeAmount(positionParam.getReplacementValue(), "Replacement Value"));
            }
            if (positionParam.getFacilityConditionIndex() != null) {
                positionInfor.getFacilityConditionIndex().setFACILITYCONDITIONINDEX(this.tools.getDataTypeTools().encodeAmount(positionParam.getFacilityConditionIndex(), "Facility Condition Index"));
            }
            if (positionParam.getServiceLifetime() != null) {
                positionInfor.getFacilityConditionIndex().setSERVICELIFE(this.tools.getDataTypeTools().encodeQuantity(positionParam.getServiceLifetime(), "Service Life Time"));
            }
            if (positionParam.getYearBuilt() != null) {
                positionInfor.getFacilityConditionIndex().setYEARBUILT(this.tools.getDataTypeTools().encodeQuantity(positionParam.getYearBuilt(), "Service Life Time"));
            }
        }
        if (positionParam.getHierarchyAssetCode() != null || positionParam.getHierarchyPositionCode() != null || positionParam.getHierarchyLocationCode() != null) {
            this.initializePositionHierarchy(positionInfor, positionParam, context);
        }
        if (positionParam.getOutOfService() != null) {
            positionInfor.setOUTOFSERVICE(positionParam.getOutOfService());
        }
        if (positionParam.getTypeCode() != null) {
            positionInfor.setTYPE(new TYPE_Type());
            positionInfor.getTYPE().setTYPECODE(positionParam.getTypeCode());
        }
        if (positionParam.getInProduction() != null) {
            positionInfor.setINPRODUCTION(positionParam.getInProduction());
        }
        if (positionParam.getOriginalReceiptDate() != null) {
            positionInfor.setORIGINALRECEIPTDATE(this.tools.getDataTypeTools().formatDate(positionParam.getOriginalReceiptDate(), "Original Receipt Date"));
        }
        if (positionParam.getSafety() != null) {
            positionInfor.setSAFETY(positionParam.getSafety());
        }
        if (positionParam.getOriginalInstallDate() != null) {
            positionInfor.setORIGINALINSTALLDATE(this.tools.getDataTypeTools().encodeInforDate(positionParam.getOriginalInstallDate(), "Original Install Date"));
        }
    }

    private void initializePositionHierarchy(PositionEquipment positionInfor, Equipment positionParam, InforContext context) {
        PositionParentHierarchy positionParentHierarchy = new PositionParentHierarchy();
        this.tools.getDataTypeTools();
        if (DataTypeTools.isEmpty(positionParam.getHierarchyAssetDependent())) {
            positionParam.setHierarchyAssetDependent("FALSE");
        }
        this.tools.getDataTypeTools();
        if (DataTypeTools.isEmpty(positionParam.getHierarchyPositionDependent())) {
            positionParam.setHierarchyPositionDependent("FALSE");
        }
        this.tools.getDataTypeTools();
        if (DataTypeTools.isEmpty(positionParam.getHierarchyPrimarySystemDependent())) {
            positionParam.setHierarchyPrimarySystemDependent("FALSE");
        }
        positionParentHierarchy.setPOSITIONID(new EQUIPMENTID_Type());
        positionParentHierarchy.getPOSITIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        positionParentHierarchy.getPOSITIONID().setEQUIPMENTCODE(positionParam.getCode());
        positionParentHierarchy.setTYPE(new TYPE_Type());
        positionParentHierarchy.getTYPE().setTYPECODE(positionParam.getTypeCode());
        EQUIPMENTID_Type hierarchyAsset = new EQUIPMENTID_Type();
        hierarchyAsset.setORGANIZATIONID(this.tools.getOrganization(context));
        hierarchyAsset.setEQUIPMENTCODE(positionParam.getHierarchyAssetCode());
        EQUIPMENTID_Type hierarchyPosition = new EQUIPMENTID_Type();
        hierarchyPosition.setORGANIZATIONID(this.tools.getOrganization(context));
        hierarchyPosition.setEQUIPMENTCODE(positionParam.getHierarchyPositionCode());
        EQUIPMENTID_Type hierarchySystem = new EQUIPMENTID_Type();
        hierarchySystem.setORGANIZATIONID(this.tools.getOrganization(context));
        hierarchySystem.setEQUIPMENTCODE(positionParam.getHierarchyPrimarySystemCode());
        this.tools.getDataTypeTools();
        if (DataTypeTools.isTrueValue(positionParam.getHierarchyAssetDependent())) {
            positionParentHierarchy.setAssetDependency(new AssetDependency());
            this.tools.getDataTypeTools();
            if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPositionCode())) {
                positionParentHierarchy.getAssetDependency().setNONDEPENDENTPOSITION(this.createHierarchyPosition(positionParam, hierarchyPosition));
            }
            this.tools.getDataTypeTools();
            if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPrimarySystemCode())) {
                positionParentHierarchy.getAssetDependency().setNONDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(positionParam, hierarchySystem));
            }
            positionParentHierarchy.getAssetDependency().setDEPENDENTASSET(this.createHierarchyAsset(positionParam, hierarchyAsset));
        } else {
            this.tools.getDataTypeTools();
            if (DataTypeTools.isTrueValue(positionParam.getHierarchyPositionDependent())) {
                positionParentHierarchy.setPositionDependency(new PositionDependency());
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(positionParam.getHierarchyAssetCode())) {
                    positionParentHierarchy.getPositionDependency().setNONDEPENDENTASSET(this.createHierarchyAsset(positionParam, hierarchyAsset));
                }
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPrimarySystemCode())) {
                    positionParentHierarchy.getPositionDependency().setNONDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(positionParam, hierarchySystem));
                }
                positionParentHierarchy.getPositionDependency().setDEPENDENTPOSITION(this.createHierarchyPosition(positionParam, hierarchyPosition));
            } else {
                this.tools.getDataTypeTools();
                if (DataTypeTools.isTrueValue(positionParam.getHierarchyPrimarySystemDependent())) {
                    positionParentHierarchy.setPrimarySystemDependency(new PrimarySystemDependency());
                    this.tools.getDataTypeTools();
                    if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPositionCode())) {
                        positionParentHierarchy.getPrimarySystemDependency().setNONDEPENDENTPOSITION(this.createHierarchyPosition(positionParam, hierarchyPosition));
                    }
                    this.tools.getDataTypeTools();
                    if (DataTypeTools.isNotEmpty(positionParam.getHierarchyAssetCode())) {
                        positionParentHierarchy.getPrimarySystemDependency().setNONDEPENDENTASSET(this.createHierarchyAsset(positionParam, hierarchyAsset));
                    }
                    positionParentHierarchy.getPrimarySystemDependency().setDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(positionParam, hierarchySystem));
                } else {
                    this.tools.getDataTypeTools();
                    if (DataTypeTools.isFalseValue(positionParam.getHierarchyAssetDependent())) {
                        this.tools.getDataTypeTools();
                        if (DataTypeTools.isFalseValue(positionParam.getHierarchyPositionDependent())) {
                            this.tools.getDataTypeTools();
                            if (DataTypeTools.isFalseValue(positionParam.getHierarchyPrimarySystemDependent())) {
                                if (positionParam.getHierarchyLocationCode() == null) {
                                    positionParentHierarchy.setNonDependentParents(new NonDependentParents_Type());
                                    this.tools.getDataTypeTools();
                                    if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPositionCode())) {
                                        positionParentHierarchy.getNonDependentParents().setNONDEPENDENTPOSITION(this.createHierarchyPosition(positionParam, hierarchyPosition));
                                    }
                                    this.tools.getDataTypeTools();
                                    if (DataTypeTools.isNotEmpty(positionParam.getHierarchyAssetCode())) {
                                        positionParentHierarchy.getNonDependentParents().setNONDEPENDENTASSET(this.createHierarchyAsset(positionParam, hierarchyAsset));
                                    }
                                    this.tools.getDataTypeTools();
                                    if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPrimarySystemCode())) {
                                        positionParentHierarchy.getNonDependentParents().setNONDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(positionParam, hierarchySystem));
                                    }
                                } else {
                                    positionParentHierarchy.setLocationDependency(new LocationDependency());
                                    positionParentHierarchy.getLocationDependency().setDEPENDENTLOCATION(new LOCATIONPARENT_Type());
                                    positionParentHierarchy.getLocationDependency().getDEPENDENTLOCATION().setLOCATIONID(new LOCATIONID_Type());
                                    positionParentHierarchy.getLocationDependency().getDEPENDENTLOCATION().getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                                    positionParentHierarchy.getLocationDependency().getDEPENDENTLOCATION().getLOCATIONID().setLOCATIONCODE(positionParam.getHierarchyLocationCode());
                                    this.tools.getDataTypeTools();
                                    if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPositionCode())) {
                                        positionParentHierarchy.getLocationDependency().setNONDEPENDENTPOSITION(this.createHierarchyPosition(positionParam, hierarchyPosition));
                                    }
                                    this.tools.getDataTypeTools();
                                    if (DataTypeTools.isNotEmpty(positionParam.getHierarchyAssetCode())) {
                                        positionParentHierarchy.getLocationDependency().setNONDEPENDENTASSET(this.createHierarchyAsset(positionParam, hierarchyAsset));
                                    }
                                    this.tools.getDataTypeTools();
                                    if (DataTypeTools.isNotEmpty(positionParam.getHierarchyPrimarySystemCode())) {
                                        positionParentHierarchy.getLocationDependency().setNONDEPENDENTPRIMARYSYSTEM(this.createHierarchyPrymarySystem(positionParam, hierarchySystem));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        positionInfor.setPositionParentHierarchy(positionParentHierarchy);
    }

    private ASSETPARENT_Type createHierarchyAsset(Equipment positionParam, EQUIPMENTID_Type hierarchyAsset) {
        ASSETPARENT_Type assetType = new ASSETPARENT_Type();
        assetType.setASSETID(hierarchyAsset);
        assetType.setCOSTROLLUP(positionParam.getHierarchyAssetCostRollUp());
        return assetType;
    }

    private POSITIONPARENT_Type createHierarchyPosition(Equipment positionParam, EQUIPMENTID_Type hierarchyPosition) {
        POSITIONPARENT_Type positionType = new POSITIONPARENT_Type();
        positionType.setPOSITIONID(hierarchyPosition);
        positionType.setCOSTROLLUP(positionParam.getHierarchyPositionCostRollUp());
        return positionType;
    }

    private SYSTEMPARENT_Type createHierarchyPrymarySystem(Equipment positionParam, EQUIPMENTID_Type hierarchySystem) {
        SYSTEMPARENT_Type systemType = new SYSTEMPARENT_Type();
        systemType.setSYSTEMID(hierarchySystem);
        systemType.setCOSTROLLUP(positionParam.getHierarchyPrimarySystemCostRollUp());
        return systemType;
    }
}

