/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.SystemService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.systemequipment_001.FacilityConditionIndex;
import net.datastream.schemas.mp_entities.systemequipment_001.ManufacturerInfo;
import net.datastream.schemas.mp_entities.systemequipment_001.SystemEquipment;
import net.datastream.schemas.mp_entities.systemequipment_001.SystemParentHierarchy;
import net.datastream.schemas.mp_entities.systemequipment_001.UserDefinedFields;
import net.datastream.schemas.mp_entities.systemequipment_001.Variables;
import net.datastream.schemas.mp_fields.CATEGORYID;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.COSTCODEID_Type;
import net.datastream.schemas.mp_fields.CRITICALITYID_Type;
import net.datastream.schemas.mp_fields.DEPARTMENTID_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.LINEARREFERENCEDETAILS_Type;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import net.datastream.schemas.mp_fields.LOCATIONPARENT_Type;
import net.datastream.schemas.mp_fields.OBJECT_Type;
import net.datastream.schemas.mp_fields.PERSONID_Type;
import net.datastream.schemas.mp_fields.STATUS_Type;
import net.datastream.schemas.mp_fields.SYSTEMPARENT_Type;
import net.datastream.schemas.mp_fields.TYPE_Type;
import net.datastream.schemas.mp_functions.mp0311_001.MP0311_AddSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0312_001.MP0312_GetSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0313_001.MP0313_SyncSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0314_001.MP0314_DeleteSystemEquipment_001;
import net.datastream.schemas.mp_functions.mp0329_001.MP0329_GetSystemParentHierarchy_001;
import net.datastream.schemas.mp_results.mp0311_001.MP0311_AddSystemEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0312_001.MP0312_GetSystemEquipment_001_Result;
import net.datastream.schemas.mp_results.mp0329_001.MP0329_GetSystemParentHierarchy_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class SystemServiceImpl
implements SystemService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public SystemServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public Equipment readSystem(InforContext context, String systemCode) throws InforException {
        MP0312_GetSystemEquipment_001 getSystem = new MP0312_GetSystemEquipment_001();
        getSystem.setSYSTEMID(new EQUIPMENTID_Type());
        getSystem.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context));
        getSystem.getSYSTEMID().setEQUIPMENTCODE(systemCode);
        MP0312_GetSystemEquipment_001_Result getAssetResult = new MP0312_GetSystemEquipment_001_Result();
        getAssetResult = context.getCredentials() != null ? this.inforws.getSystemEquipmentOp(getSystem, "*", this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.getSystemEquipmentOp(getSystem, "*", null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        SystemEquipment systemEquipment = getAssetResult.getResultData().getSystemEquipment();
        Equipment system = new Equipment();
        if (systemEquipment.getSYSTEMID() != null) {
            system.setCode(systemEquipment.getSYSTEMID().getEQUIPMENTCODE());
            system.setDescription(systemEquipment.getSYSTEMID().getDESCRIPTION());
        }
        if (systemEquipment.getEQUIPMENTALIAS() != null) {
            system.setAlias(systemEquipment.getEQUIPMENTALIAS());
        }
        if (systemEquipment.getSTATUS() != null) {
            system.setStatusCode(systemEquipment.getSTATUS().getSTATUSCODE());
            system.setStatusDesc(systemEquipment.getSTATUS().getDESCRIPTION());
        }
        if (systemEquipment.getCLASSID() != null) {
            system.setClassCode(systemEquipment.getCLASSID().getCLASSCODE());
            system.setClassDesc(systemEquipment.getCLASSID().getDESCRIPTION());
        }
        if (systemEquipment.getCATEGORYID() != null) {
            system.setCategoryCode(systemEquipment.getCATEGORYID().getCATEGORYCODE());
            system.setCategoryDesc(systemEquipment.getCATEGORYID().getDESCRIPTION());
        }
        if (systemEquipment.getASSIGNEDTO() != null) {
            system.setAssignedTo(systemEquipment.getASSIGNEDTO().getPERSONCODE());
            system.setAssignedToDesc(this.tools.getFieldDescriptionsTools().readPersonDesc(system.getAssignedTo()));
        }
        if (systemEquipment.getTYPE() != null) {
            system.setTypeCode(systemEquipment.getTYPE().getTYPECODE());
            system.setTypeDesc(systemEquipment.getTYPE().getDESCRIPTION());
        }
        if (systemEquipment.getDEPARTMENTID() != null) {
            system.setDepartmentCode(systemEquipment.getDEPARTMENTID().getDEPARTMENTCODE());
            system.setDepartmentDesc(systemEquipment.getDEPARTMENTID().getDESCRIPTION());
        }
        if (systemEquipment.getCRITICALITYID() != null) {
            system.setCriticality(systemEquipment.getCRITICALITYID().getCRITICALITY());
        }
        if (systemEquipment.getCOMMISSIONDATE() != null) {
            system.setComissionDate(this.tools.getDataTypeTools().decodeInforDate(systemEquipment.getCOMMISSIONDATE()));
        }
        if (systemEquipment.getManufacturerInfo() != null) {
            system.setManufacturerCode(systemEquipment.getManufacturerInfo().getMANUFACTURERCODE());
            system.setSerialNumber(systemEquipment.getManufacturerInfo().getSERIALNUMBER());
            system.setModel(systemEquipment.getManufacturerInfo().getMODEL());
            system.setManufacturerDesc(this.tools.getFieldDescriptionsTools().readManufacturerDesc(system.getManufacturerCode()));
        }
        system.setCustomFields(this.tools.getCustomFieldsTools().readInforCustomFields(systemEquipment.getUSERDEFINEDAREA()));
        system.setUserDefinedFields(this.tools.getUDFTools().readInforUserDefinedFields(systemEquipment.getUserDefinedFields()));
        MP0329_GetSystemParentHierarchy_001 getsystemh = new MP0329_GetSystemParentHierarchy_001();
        getsystemh.setSYSTEMID(systemEquipment.getSYSTEMID());
        MP0329_GetSystemParentHierarchy_001_Result gethresult = context.getCredentials() != null ? this.inforws.getSystemParentHierarchyOp(getsystemh, "*", this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.getSystemParentHierarchyOp(getsystemh, "*", null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        systemEquipment.setSystemParentHierarchy(gethresult.getResultData().getSystemParentHierarchy());
        if (systemEquipment.getSystemParentHierarchy().getLOCATIONID() != null) {
            system.setHierarchyLocationCode(systemEquipment.getSystemParentHierarchy().getLOCATIONID().getLOCATIONCODE());
            system.setHierarchyLocationDesc(systemEquipment.getSystemParentHierarchy().getLOCATIONID().getDESCRIPTION());
        }
        if (systemEquipment.getSystemParentHierarchy().getDEPENDENTPRIMARYSYSTEM() != null) {
            system.setHierarchyPrimarySystemCode(systemEquipment.getSystemParentHierarchy().getDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
            system.setHierarchyPrimarySystemDesc(systemEquipment.getSystemParentHierarchy().getDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
            system.setHierarchyPrimarySystemDependent("true");
            system.setHierarchyPrimarySystemCostRollUp(systemEquipment.getSystemParentHierarchy().getDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP());
        } else if (systemEquipment.getSystemParentHierarchy().getNONDEPENDENTPRIMARYSYSTEM() != null) {
            system.setHierarchyPrimarySystemCode(systemEquipment.getSystemParentHierarchy().getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getEQUIPMENTCODE());
            system.setHierarchyPrimarySystemDesc(systemEquipment.getSystemParentHierarchy().getNONDEPENDENTPRIMARYSYSTEM().getSYSTEMID().getDESCRIPTION());
            system.setHierarchyPrimarySystemDependent("false");
            system.setHierarchyPrimarySystemCostRollUp(systemEquipment.getSystemParentHierarchy().getNONDEPENDENTPRIMARYSYSTEM().getCOSTROLLUP());
        }
        if (systemEquipment.getVariables() != null) {
            system.setVariable1(systemEquipment.getVariables().getVARIABLE1());
            system.setVariable2(systemEquipment.getVariables().getVARIABLE2());
            system.setVariable3(systemEquipment.getVariables().getVARIABLE3());
            system.setVariable4(systemEquipment.getVariables().getVARIABLE4());
            system.setVariable5(systemEquipment.getVariables().getVARIABLE5());
            system.setVariable6(systemEquipment.getVariables().getVARIABLE6());
        }
        system.setInProduction(systemEquipment.getINPRODUCTION());
        return system;
    }

    @Override
    public String updateSystem(InforContext context, Equipment systemParam) throws InforException {
        SystemEquipment systemEquipment = null;
        MP0312_GetSystemEquipment_001 getSystem = new MP0312_GetSystemEquipment_001();
        getSystem.setSYSTEMID(new EQUIPMENTID_Type());
        getSystem.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context));
        getSystem.getSYSTEMID().setEQUIPMENTCODE(systemParam.getCode());
        MP0312_GetSystemEquipment_001_Result getAssetResult = new MP0312_GetSystemEquipment_001_Result();
        getAssetResult = context.getCredentials() != null ? this.inforws.getSystemEquipmentOp(getSystem, "*", this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.getSystemEquipmentOp(getSystem, "*", null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        systemEquipment = getAssetResult.getResultData().getSystemEquipment();
        if (!(systemParam.getClassCode() == null || systemEquipment.getCLASSID() != null && systemParam.getClassCode().toUpperCase().equals(systemEquipment.getCLASSID().getCLASSCODE()))) {
            systemEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getCustomFields(context, "OBJ", systemParam.getClassCode().toUpperCase()));
        }
        this.initializeSystemObject(systemEquipment, systemParam, context);
        MP0313_SyncSystemEquipment_001 syncPosition = new MP0313_SyncSystemEquipment_001();
        syncPosition.setSystemEquipment(systemEquipment);
        if (context.getCredentials() != null) {
            this.inforws.syncSystemEquipmentOp(syncPosition, "*", this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
        } else {
            this.inforws.syncSystemEquipmentOp(syncPosition, "*", null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return systemParam.getCode();
    }

    @Override
    public String createSystem(InforContext context, Equipment systemParam) throws InforException {
        SystemEquipment systemEquipment = new SystemEquipment();
        if (systemParam.getCustomFields() != null && systemParam.getCustomFields().length > 0) {
            if (systemParam.getClassCode() != null && !systemParam.getClassCode().trim().equals("")) {
                systemEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getCustomFields(context, "OBJ", systemParam.getClassCode()));
            } else {
                systemEquipment.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getCustomFields(context, "OBJ", "*"));
            }
        }
        systemEquipment.setUserDefinedFields(new UserDefinedFields());
        this.initializeSystemObject(systemEquipment, systemParam, context);
        MP0311_AddSystemEquipment_001 addPosition = new MP0311_AddSystemEquipment_001();
        addPosition.setSystemEquipment(systemEquipment);
        MP0311_AddSystemEquipment_001_Result result = context.getCredentials() != null ? this.inforws.addSystemEquipmentOp(addPosition, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.addSystemEquipmentOp(addPosition, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return result.getResultData().getSYSTEMID().getEQUIPMENTCODE();
    }

    @Override
    public String deleteSystem(InforContext context, String systemCode) throws InforException {
        MP0314_DeleteSystemEquipment_001 deleteSystem = new MP0314_DeleteSystemEquipment_001();
        deleteSystem.setSYSTEMID(new EQUIPMENTID_Type());
        deleteSystem.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context));
        deleteSystem.getSYSTEMID().setEQUIPMENTCODE(systemCode);
        if (context.getCredentials() != null) {
            this.inforws.deleteSystemEquipmentOp(deleteSystem, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
        } else {
            this.inforws.deleteSystemEquipmentOp(deleteSystem, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return systemCode;
    }

    private void initializeSystemObject(SystemEquipment systemInfor, Equipment systemParam, InforContext context) throws InforException {
        if (systemInfor.getSYSTEMID() == null) {
            systemInfor.setSYSTEMID(new EQUIPMENTID_Type());
            systemInfor.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context));
            systemInfor.getSYSTEMID().setEQUIPMENTCODE(systemParam.getCode());
        }
        if (systemParam.getAlias() != null) {
            systemInfor.setEQUIPMENTALIAS(systemParam.getAlias());
        }
        if (systemParam.getDescription() != null) {
            systemInfor.getSYSTEMID().setDESCRIPTION(systemParam.getDescription());
        }
        if (systemParam.getTypeCode() != null) {
            systemInfor.setTYPE(new TYPE_Type());
            systemInfor.getTYPE().setTYPECODE(systemParam.getTypeCode());
        }
        if (systemParam.getStatusCode() != null) {
            systemInfor.setSTATUS(new STATUS_Type());
            systemInfor.getSTATUS().setSTATUSCODE(systemParam.getStatusCode());
        }
        if (systemParam.getClassCode() != null) {
            if (systemParam.getClassCode().trim().equals("")) {
                systemInfor.setCLASSID(null);
            } else {
                systemInfor.setCLASSID(new CLASSID_Type());
                systemInfor.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
                systemInfor.getCLASSID().setCLASSCODE(systemParam.getClassCode());
            }
        }
        if (systemParam.getCategoryCode() != null) {
            systemInfor.setCATEGORYID(new CATEGORYID());
            systemInfor.getCATEGORYID().setCATEGORYCODE(systemParam.getCategoryCode());
        }
        if (systemParam.getComissionDate() != null) {
            systemInfor.setCOMMISSIONDATE(this.tools.getDataTypeTools().encodeInforDate(systemParam.getComissionDate(), "Commission Date"));
        }
        if (systemParam.getCostCode() != null) {
            systemInfor.setCOSTCODEID(new COSTCODEID_Type());
            systemInfor.getCOSTCODEID().setCOSTCODE(systemParam.getCostCode());
        }
        if (systemParam.getCriticality() != null) {
            systemInfor.setCRITICALITYID(new CRITICALITYID_Type());
            systemInfor.getCRITICALITYID().setCRITICALITY(systemParam.getCriticality());
        }
        if (systemParam.getDepartmentCode() != null) {
            systemInfor.setDEPARTMENTID(new DEPARTMENTID_Type());
            systemInfor.getDEPARTMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            systemInfor.getDEPARTMENTID().setDEPARTMENTCODE(systemParam.getDepartmentCode());
        }
        if (systemParam.getProfileCode() != null) {
            systemInfor.setPROFILEID(new OBJECT_Type());
            systemInfor.getPROFILEID().setORGANIZATIONID(this.tools.getOrganization(context));
            systemInfor.getPROFILEID().setOBJECTCODE(systemParam.getProfileCode());
        }
        if (systemParam.getManufacturerCode() != null || systemParam.getSerialNumber() != null || systemParam.getModel() != null || systemParam.getRevision() != null || systemParam.getxCoordinate() != null || systemParam.getyCoordinate() != null || systemParam.getzCoordinate() != null) {
            if (systemInfor.getManufacturerInfo() == null) {
                systemInfor.setManufacturerInfo(new ManufacturerInfo());
            }
            if (systemParam.getManufacturerCode() != null) {
                systemInfor.getManufacturerInfo().setMANUFACTURERCODE(systemParam.getManufacturerCode().toUpperCase());
            }
            if (systemParam.getModel() != null) {
                systemInfor.getManufacturerInfo().setMODEL(systemParam.getModel());
            }
            if (systemParam.getRevision() != null) {
                systemInfor.getManufacturerInfo().setMODELREVISION(systemParam.getRevision());
            }
            if (systemParam.getSerialNumber() != null) {
                systemInfor.getManufacturerInfo().setSERIALNUMBER(systemParam.getSerialNumber());
            }
            if (systemParam.getxCoordinate() != null) {
                systemInfor.getManufacturerInfo().setXCOORDINATE(this.tools.getDataTypeTools().encodeQuantity(systemParam.getxCoordinate(), "X-Coordinate"));
            }
            if (systemParam.getyCoordinate() != null) {
                systemInfor.getManufacturerInfo().setYCOORDINATE(this.tools.getDataTypeTools().encodeQuantity(systemParam.getyCoordinate(), "Y-Coordinate"));
            }
            if (systemParam.getzCoordinate() != null) {
                systemInfor.getManufacturerInfo().setZCOORDINATE(this.tools.getDataTypeTools().encodeQuantity(systemParam.getzCoordinate(), "Z-Coordiante"));
            }
        }
        if (systemParam.getUpdateCount() != null) {
            systemInfor.setRecordid(Long.decode(systemParam.getUpdateCount()));
        }
        if (systemParam.getMeterUnit() != null) {
            systemInfor.setMETERUNIT(systemParam.getMeterUnit());
        }
        if (systemParam.getLinearRefGeographicalRef() != null || systemParam.getLinearRefEquipmentLength() != null || systemParam.getLinearRefEquipmentLengthUOM() != null || systemParam.getLinearRefPrecision() != null || systemParam.getLinearRefUOM() != null) {
            systemInfor.setLINEARREFERENCEDETAILS(new LINEARREFERENCEDETAILS_Type());
            systemInfor.getLINEARREFERENCEDETAILS().setEQUIPMENTLENGTH(this.tools.getDataTypeTools().encodeQuantity(systemParam.getLinearRefEquipmentLength(), "Linear Ref. Equipment Length"));
            systemInfor.getLINEARREFERENCEDETAILS().setEQUIPMENTLENGTHUOM(systemParam.getLinearRefEquipmentLengthUOM());
            systemInfor.getLINEARREFERENCEDETAILS().setGEOGRAPHICALREFERENCE(systemParam.getLinearRefGeographicalRef());
            systemInfor.getLINEARREFERENCEDETAILS().setLINEARREFPRECISION(this.tools.getDataTypeTools().encodeBigInteger(systemParam.getLinearRefPrecision(), "Linear Ref. Precision"));
            systemInfor.getLINEARREFERENCEDETAILS().setLINEARREFUOM(systemParam.getLinearRefUOM());
        }
        if (systemParam.getAssignedTo() != null) {
            if (systemParam.getAssignedTo().trim().equals("")) {
                systemInfor.setASSIGNEDTO(null);
            } else {
                systemInfor.setASSIGNEDTO(new PERSONID_Type());
                systemInfor.getASSIGNEDTO().setPERSONCODE(systemParam.getAssignedTo());
            }
        }
        if (systemParam.getcGMP() != null) {
            systemInfor.setCGMP(systemParam.getcGMP());
        }
        if (systemParam.getDormantStart() != null || systemParam.getDormantEnd() != null || systemParam.getDormantReusePeriod() != null) {
            systemInfor.setDORMANT(new SystemEquipment.DORMANT());
            systemInfor.getDORMANT().setDORMANTSTART(this.tools.getDataTypeTools().formatDate(systemParam.getDormantStart(), "Dormant Start"));
            systemInfor.getDORMANT().setDORMANTEND(this.tools.getDataTypeTools().formatDate(systemParam.getDormantEnd(), "Dormant End"));
            systemInfor.getDORMANT().setDORMANTREUSE(systemParam.getDormantReusePeriod());
        }
        systemInfor.setVariables(new Variables());
        if (systemParam.getVariable1() != null) {
            systemInfor.getVariables().setVARIABLE1(systemParam.getVariable1());
        }
        if (systemParam.getVariable2() != null) {
            systemInfor.getVariables().setVARIABLE2(systemParam.getVariable2());
        }
        if (systemParam.getVariable3() != null) {
            systemInfor.getVariables().setVARIABLE3(systemParam.getVariable3());
        }
        if (systemParam.getVariable4() != null) {
            systemInfor.getVariables().setVARIABLE4(systemParam.getVariable4());
        }
        if (systemParam.getVariable5() != null) {
            systemInfor.getVariables().setVARIABLE5(systemParam.getVariable5());
        }
        if (systemParam.getVariable6() != null) {
            systemInfor.getVariables().setVARIABLE6(systemParam.getVariable6());
        }
        this.tools.getCustomFieldsTools().updateInforCustomFields(systemInfor.getUSERDEFINEDAREA(), systemParam.getCustomFields());
        this.tools.getUDFTools().updateInforUserDefinedFields(systemInfor.getUserDefinedFields(), systemParam.getUserDefinedFields());
        if (systemParam.getOutOfService() != null) {
            systemInfor.setOUTOFSERVICE(systemParam.getOutOfService());
        }
        if (systemParam.getCostOfNeededRepairs() != null || systemParam.getReplacementValue() != null || systemParam.getFacilityConditionIndex() != null || systemParam.getServiceLifetime() != null || systemParam.getYearBuilt() != null) {
            if (systemInfor.getFacilityConditionIndex() == null) {
                systemInfor.setFacilityConditionIndex(new FacilityConditionIndex());
            }
            if (systemParam.getCostOfNeededRepairs() != null) {
                systemInfor.getFacilityConditionIndex().setCOSTOFNEEDEDREPAIRS(this.tools.getDataTypeTools().encodeAmount(systemParam.getCostOfNeededRepairs(), "Cost of Needed Repairs"));
            }
            if (systemParam.getReplacementValue() != null) {
                systemInfor.getFacilityConditionIndex().setREPLACEMENTVALUE(this.tools.getDataTypeTools().encodeAmount(systemParam.getReplacementValue(), "Replacement Value"));
            }
            if (systemParam.getFacilityConditionIndex() != null) {
                systemInfor.getFacilityConditionIndex().setFACILITYCONDITIONINDEX(this.tools.getDataTypeTools().encodeAmount(systemParam.getFacilityConditionIndex(), "Facility Condition Index"));
            }
            if (systemParam.getServiceLifetime() != null) {
                systemInfor.getFacilityConditionIndex().setSERVICELIFE(this.tools.getDataTypeTools().encodeQuantity(systemParam.getServiceLifetime(), "Service Life Time"));
            }
            if (systemParam.getYearBuilt() != null) {
                systemInfor.getFacilityConditionIndex().setYEARBUILT(this.tools.getDataTypeTools().encodeQuantity(systemParam.getYearBuilt(), "Service Life Time"));
            }
        }
        if (systemInfor.getTYPE().getTYPECODE().equals("S")) {
            this.populateSystemHierarchy(context, systemParam, systemInfor);
        }
        if (systemParam.getInProduction() != null) {
            systemInfor.setINPRODUCTION(systemParam.getInProduction());
        }
        if (systemParam.getOriginalReceiptDate() != null) {
            systemInfor.setORIGINALRECEIPTDATE(this.tools.getDataTypeTools().formatDate(systemParam.getOriginalReceiptDate(), "Original Receipt Date"));
        }
        if (systemParam.getSafety() != null) {
            systemInfor.setSAFETY(systemParam.getSafety());
        }
        if (systemParam.getOriginalInstallDate() != null) {
            systemInfor.setORIGINALINSTALLDATE(this.tools.getDataTypeTools().encodeInforDate(systemParam.getOriginalInstallDate(), "Original Install Date"));
        }
    }

    private void populateSystemHierarchy(InforContext context, Equipment systemParam, SystemEquipment systemInfor) {
        SystemParentHierarchy systemParentHierarchy = new SystemParentHierarchy();
        systemParentHierarchy.setSYSTEMID(new EQUIPMENTID_Type());
        systemParentHierarchy.getSYSTEMID().setORGANIZATIONID(this.tools.getOrganization(context));
        systemParentHierarchy.getSYSTEMID().setEQUIPMENTCODE(systemParam.getCode());
        systemParentHierarchy.setTYPE(new TYPE_Type());
        systemParentHierarchy.getTYPE().setTYPECODE("S");
        this.tools.getDataTypeTools();
        if (DataTypeTools.isNotEmpty(systemParam.getHierarchyPrimarySystemCode())) {
            this.tools.getDataTypeTools();
            if (DataTypeTools.isEmpty(systemParam.getHierarchyPrimarySystemDependent())) {
                systemParam.setHierarchyAssetDependent("FALSE");
            }
            EQUIPMENTID_Type hierarchySystem = new EQUIPMENTID_Type();
            hierarchySystem.setORGANIZATIONID(this.tools.getOrganization(context));
            hierarchySystem.setEQUIPMENTCODE(systemParam.getHierarchyPrimarySystemCode());
            this.tools.getDataTypeTools();
            if (DataTypeTools.isTrueValue(systemParam.getHierarchyPrimarySystemDependent())) {
                SYSTEMPARENT_Type systemType = new SYSTEMPARENT_Type();
                systemType.setSYSTEMID(hierarchySystem);
                systemType.setCOSTROLLUP(systemParam.getHierarchyPrimarySystemCostRollUp());
                systemParentHierarchy.setDEPENDENTPRIMARYSYSTEM(systemType);
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(systemParam.getHierarchyLocationCode())) {
                    systemParentHierarchy.setLOCATIONID(new LOCATIONID_Type());
                    systemParentHierarchy.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                    systemParentHierarchy.getLOCATIONID().setLOCATIONCODE(systemParam.getHierarchyLocationCode());
                }
            } else {
                SYSTEMPARENT_Type systemType = new SYSTEMPARENT_Type();
                systemType.setSYSTEMID(hierarchySystem);
                systemType.setCOSTROLLUP(systemParam.getHierarchyPrimarySystemCostRollUp());
                systemParentHierarchy.setNONDEPENDENTPRIMARYSYSTEM(systemType);
                this.tools.getDataTypeTools();
                if (DataTypeTools.isNotEmpty(systemParam.getHierarchyLocationCode())) {
                    systemParentHierarchy.setDEPENDENTLOCATION(new LOCATIONPARENT_Type());
                    systemParentHierarchy.getDEPENDENTLOCATION().setLOCATIONID(new LOCATIONID_Type());
                    systemParentHierarchy.getDEPENDENTLOCATION().getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                    systemParentHierarchy.getDEPENDENTLOCATION().getLOCATIONID().setLOCATIONCODE(systemParam.getHierarchyLocationCode());
                }
            }
        } else {
            this.tools.getDataTypeTools();
            if (DataTypeTools.isNotEmpty(systemParam.getHierarchyLocationCode())) {
                systemParentHierarchy.setDEPENDENTLOCATION(new LOCATIONPARENT_Type());
                systemParentHierarchy.getDEPENDENTLOCATION().setLOCATIONID(new LOCATIONID_Type());
                systemParentHierarchy.getDEPENDENTLOCATION().getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
                systemParentHierarchy.getDEPENDENTLOCATION().getLOCATIONID().setLOCATIONCODE(systemParam.getHierarchyLocationCode());
            }
        }
        systemInfor.setSystemParentHierarchy(systemParentHierarchy);
    }
}

