/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.tools;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.CustomField;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.CODEDESCFIELD;
import net.datastream.schemas.mp_fields.CUSTOMFIELD;
import net.datastream.schemas.mp_fields.ENTITYCODEFIELD;
import net.datastream.schemas.mp_fields.USERDEFINEDAREA;
import net.datastream.schemas.mp_functions.mp9501_001.CUSTOMFIELDREQ;
import net.datastream.schemas.mp_functions.mp9501_001.MP9501_GetCustomFields_001;
import net.datastream.schemas.mp_results.mp9501_001.MP9501_GetCustomFields_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class CustomFieldsTools {
    private Tools tools;
    private ApplicationData applicationData;
    private InforWebServicesPT inforws;
    private static Map<String, String[][]> map;

    public CustomFieldsTools(Tools tools, ApplicationData applicationData, InforWebServicesPT inforws) {
        this.tools = tools;
        this.applicationData = applicationData;
        this.inforws = inforws;
        map = new HashMap<String, String[][]>();
    }

    public CustomField decodeInforCustomField(CUSTOMFIELD customFieldInfor) {
        CustomField customField = new CustomField();
        customField.setClassCode(customFieldInfor.getCLASSID().getCLASSCODE());
        customField.setEntityCode(customFieldInfor.getEntity());
        customField.setCode(customFieldInfor.getPROPERTYCODE());
        customField.setType(customFieldInfor.getType());
        customField.setLabel(customFieldInfor.getPROPERTYLABEL());
        customField.setUOM(customFieldInfor.getUOM());
        customField.setMinValue(customFieldInfor.getMINVALUE());
        customField.setMaxValue(customFieldInfor.getMAXVALUE());
        if (customFieldInfor.getLOVSETTINGS() != null) {
            customField.setLovType(customFieldInfor.getLOVSETTINGS().getLOV_TYPE());
            customField.setLovValidate(customFieldInfor.getLOVSETTINGS().getLOV_VALIDATE());
        }
        if (customFieldInfor.getType().toUpperCase().equals("DATI") && customFieldInfor.getDATETIMEFIELD() != null) {
            customField.setValue(this.tools.getDataTypeTools().retrieveDate(customFieldInfor.getDATETIMEFIELD(), "dd-MMM-yyyy HH:mm"));
        } else if (customFieldInfor.getType().toUpperCase().equals("DATE") && customFieldInfor.getDATEFIELD() != null) {
            customField.setValue(this.tools.getDataTypeTools().retrieveDate(customFieldInfor.getDATEFIELD(), "dd-MMM-yyyy"));
        } else if (customFieldInfor.getType().toUpperCase().equals("RENT") && customFieldInfor.getENTITYCODEFIELD() != null) {
            customField.setValue(customFieldInfor.getENTITYCODEFIELD().getCODEVALUE());
            customField.setRentCodeValue(customFieldInfor.getENTITYCODEFIELD().getEntity());
            customField.setValueDesc(this.tools.getFieldDescriptionsTools().readCustomFieldDesc(customFieldInfor.getENTITYCODEFIELD().getEntity(), customFieldInfor.getENTITYCODEFIELD().getCODEVALUE()));
        } else if (customFieldInfor.getType().toUpperCase().equals("NUM") && customFieldInfor.getNUMBERFIELD() != null) {
            customField.setValue(this.tools.getDataTypeTools().decodeQuantity(customFieldInfor.getNUMBERFIELD()));
        } else if (customFieldInfor.getType().toUpperCase().equals("CODE") && customFieldInfor.getCODEDESCFIELD() != null) {
            customField.setValue(customFieldInfor.getCODEDESCFIELD().getCODEVALUE());
            try {
                String[][] cf = this.getCFValues(customFieldInfor.getCLASSID().getCLASSCODE(), customFieldInfor.getPROPERTYCODE(), "EN");
                customField.setCfc(cf[0]);
                customField.setCfd(cf[1]);
            }
            catch (Exception exception) {}
        } else {
            customField.setValue(customFieldInfor.getTEXTFIELD());
        }
        return customField;
    }

    public CUSTOMFIELD encodeInforCustomField(CUSTOMFIELD customFieldInfor, CustomField customField) throws InforException {
        if (customFieldInfor.getType().toUpperCase().equals("DATI") && customField.getValue() != null) {
            customFieldInfor.setDATETIMEFIELD(this.tools.getDataTypeTools().formatDate(customField.getValue(), "Custom field '" + customFieldInfor.getPROPERTYLABEL() + "'"));
        }
        if (customFieldInfor.getType().toUpperCase().equals("DATE") && customField.getValue() != null) {
            customFieldInfor.setDATEFIELD(this.tools.getDataTypeTools().formatDate(customField.getValue(), "Custom field '" + customFieldInfor.getPROPERTYLABEL() + "'"));
        }
        if (customFieldInfor.getType().toUpperCase().equals("RENT")) {
            customFieldInfor.setENTITYCODEFIELD(new ENTITYCODEFIELD());
            if (customField.getValue() != null) {
                customFieldInfor.getENTITYCODEFIELD().setCODEVALUE(customField.getValue());
            } else {
                customFieldInfor.getENTITYCODEFIELD().setCODEVALUE("");
            }
        }
        if (customFieldInfor.getType().toUpperCase().equals("NUM") && customField.getValue() != null) {
            customFieldInfor.setNUMBERFIELD(this.tools.getDataTypeTools().encodeQuantity(customField.getValue(), "Custom field '" + customFieldInfor.getPROPERTYLABEL() + "'"));
        }
        if (customFieldInfor.getType().toUpperCase().equals("CODE") && customFieldInfor.getCODEDESCFIELD() != null) {
            customFieldInfor.setCODEDESCFIELD(new CODEDESCFIELD());
            if (customField.getValue() != null) {
                customFieldInfor.getCODEDESCFIELD().setCODEVALUE(customField.getValue());
            } else {
                customFieldInfor.getCODEDESCFIELD().setCODEVALUE("");
            }
        }
        if (customFieldInfor.getType().toUpperCase().equals("CHAR")) {
            customFieldInfor.setTEXTFIELD(customField.getValue());
        }
        return customFieldInfor;
    }

    public void updateInforCustomFields(USERDEFINEDAREA userdefinedarea, CustomField[] customFields) throws InforException {
        if (userdefinedarea != null && userdefinedarea.getCUSTOMFIELD() != null && userdefinedarea.getCUSTOMFIELD().size() > 0) {
            for (CUSTOMFIELD customFieldInfor : userdefinedarea.getCUSTOMFIELD()) {
                customFieldInfor.setChanged("false");
            }
        }
        if (customFields != null && customFields.length > 0 && userdefinedarea != null && userdefinedarea.getCUSTOMFIELD() != null && userdefinedarea.getCUSTOMFIELD().size() > 0) {
            block1: for (CustomField customField : customFields) {
                for (CUSTOMFIELD customFieldInfor : userdefinedarea.getCUSTOMFIELD()) {
                    if (!customFieldInfor.getPROPERTYCODE().equals(customField.getCode()) || !this.hasChangedCustomField(customFieldInfor, customField)) continue;
                    this.encodeInforCustomField(customFieldInfor, customField);
                    customFieldInfor.setChanged("true");
                    continue block1;
                }
            }
        }
    }

    private boolean hasChangedCustomField(CUSTOMFIELD customFieldInfor, CustomField customField) {
        switch (customFieldInfor.getType().toUpperCase()) {
            case "RENT": {
                if (customFieldInfor.getENTITYCODEFIELD() != null) {
                    return this.isDifferentValue(customFieldInfor.getENTITYCODEFIELD().getCODEVALUE(), customField.getValue());
                }
                return this.isDifferentValue(null, customField.getValue());
            }
            case "NUM": {
                String quantity = this.tools.getDataTypeTools().decodeQuantity(customFieldInfor.getNUMBERFIELD());
                return this.isDifferentValue(quantity, customField.getValue());
            }
            case "CODE": {
                if (customFieldInfor.getCODEDESCFIELD() != null) {
                    return this.isDifferentValue(customFieldInfor.getCODEDESCFIELD().getCODEVALUE(), customField.getValue());
                }
                return this.isDifferentValue(null, customField.getValue());
            }
            case "CHAR": {
                return this.isDifferentValue(customFieldInfor.getTEXTFIELD(), customField.getValue());
            }
        }
        return true;
    }

    private boolean isDifferentValue(String value1, String value2) {
        if (value1 == null && value2 != null) {
            return true;
        }
        if (value1 != null && value2 == null) {
            return true;
        }
        if (value1 == null && value2 == null) {
            return false;
        }
        return !value1.equals(value2);
    }

    public CustomField[] readInforCustomFields(USERDEFINEDAREA userdefinedarea) {
        if (userdefinedarea == null || userdefinedarea.getCUSTOMFIELD() == null) {
            return new CustomField[0];
        }
        return (CustomField[])userdefinedarea.getCUSTOMFIELD().stream().sorted(Comparator.comparing(CUSTOMFIELD::getIndex)).map(cf -> this.decodeInforCustomField((CUSTOMFIELD)cf)).toArray(CustomField[]::new);
    }

    public USERDEFINEDAREA getInforCustomFields(InforContext context, String entity, String inforClass) throws InforException {
        CUSTOMFIELDREQ cfreq = new CUSTOMFIELDREQ();
        cfreq.setORGANIZATIONID(this.tools.getOrganization(context));
        cfreq.setCLASSID(new CLASSID_Type());
        cfreq.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
        cfreq.getCLASSID().setCLASSCODE(inforClass);
        cfreq.setENTITYNAME(entity);
        MP9501_GetCustomFields_001 getcustomfields = new MP9501_GetCustomFields_001();
        getcustomfields.setCUSTOMFIELDREQ(cfreq);
        MP9501_GetCustomFields_001_Result result = context.getCredentials() != null ? this.inforws.getCustomFieldsOp(getcustomfields, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.getCustomFieldsOp(getcustomfields, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return result.getUSERDEFINEDAREA();
    }

    public CustomField[] getWSHubCustomFields(InforContext context, String entity, String inforClass) throws InforException {
        CUSTOMFIELDREQ cfreq = new CUSTOMFIELDREQ();
        cfreq.setORGANIZATIONID(this.tools.getOrganization(context));
        if (inforClass != null) {
            cfreq.setCLASSID(new CLASSID_Type());
            cfreq.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            cfreq.getCLASSID().setCLASSCODE(inforClass.toUpperCase());
        }
        if (entity != null) {
            cfreq.setENTITYNAME(entity.toUpperCase());
        }
        return this.readInforCustomFields(this.getInforCustomFields(context, entity, inforClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] getCFValues(String classCode, String propertyCode, String language) throws SQLException {
        String[][] values = new String[2][];
        if (map.containsKey(propertyCode)) {
            return map.get(classCode + "_" + propertyCode + "_" + language);
        }
        String sqlq = "select distinct prv_value val, (NVL((SELECT TRA_TEXT FROM U5TRANSLATIONS WHERE TRA_LANGUAGE = '" + language + "' and TRA_PAGENAME = '" + propertyCode + "' and UPPER(TRA_ELEMENTID) = UPPER(PVD_VALUE)),NVL(PVD_DESC, PVD_VALUE))) des, PRV_SEQNO from r5propertyvalues, r5pvdescriptions where prv_property = '" + propertyCode + "' and prv_code is null and pvd_property(+)=prv_property and pvd_value(+)=prv_value AND COALESCE(prv_notused, '-') <> '+' order by PRV_SEQNO ASC";
        Connection v_connection = null;
        Statement stmt = null;
        ResultSet v_result = null;
        try {
            v_connection = this.tools.getDataSource().getConnection();
            stmt = v_connection.createStatement();
            v_result = stmt.executeQuery(sqlq);
            LinkedList<String> listCode = new LinkedList<String>();
            listCode.add("");
            LinkedList<String> listDesc = new LinkedList<String>();
            listDesc.add("");
            while (v_result.next()) {
                listCode.add(v_result.getString(1));
                listDesc.add(v_result.getString(2));
            }
            values[0] = listCode.toArray(new String[0]);
            values[1] = listDesc.toArray(new String[0]);
            map.put(classCode + "_" + propertyCode + "_" + language, values);
        }
        catch (Exception exception) {
        }
        finally {
            if (v_result != null) {
                v_result.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (v_connection != null) {
                v_connection.close();
            }
        }
        return values;
    }
}

