/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.LocationService;
import ch.cern.eam.wshub.core.services.equipment.entities.Equipment;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.location_001.Location;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import net.datastream.schemas.mp_functions.mp0318_001.MP0318_GetLocation_001;
import net.datastream.schemas.mp_results.mp0318_001.MP0318_GetLocation_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class LocationServiceImpl
implements LocationService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public LocationServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public Equipment readLocation(InforContext context, String locationCode) throws InforException {
        MP0318_GetLocation_001 getLocation = new MP0318_GetLocation_001();
        getLocation.setLOCATIONID(new LOCATIONID_Type());
        getLocation.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        getLocation.getLOCATIONID().setLOCATIONCODE(locationCode);
        MP0318_GetLocation_001_Result getLocationResult = new MP0318_GetLocation_001_Result();
        getLocationResult = context.getCredentials() != null ? this.inforws.getLocationOp(getLocation, "*", this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.getLocationOp(getLocation, "*", null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        Location locationInfor = getLocationResult.getResultData().getLocation();
        Equipment location = new Equipment();
        if (locationInfor.getLOCATIONID() != null) {
            location.setCode(locationInfor.getLOCATIONID().getLOCATIONCODE());
            location.setDescription(locationInfor.getLOCATIONID().getDESCRIPTION());
        }
        if (locationInfor.getCLASSID() != null) {
            location.setClassCode(locationInfor.getCLASSID().getCLASSCODE());
            location.setClassDesc(locationInfor.getCLASSID().getDESCRIPTION());
        }
        if (locationInfor.getDEPARTMENTID() != null) {
            location.setDepartmentCode(locationInfor.getDEPARTMENTID().getDEPARTMENTCODE());
            location.setDepartmentDesc(locationInfor.getDEPARTMENTID().getDESCRIPTION());
        }
        if (locationInfor.getParentLocationID() != null) {
            location.setHierarchyLocationCode(locationInfor.getParentLocationID().getLOCATIONCODE());
            location.setHierarchyLocationDesc(locationInfor.getParentLocationID().getDESCRIPTION());
        }
        location.setTypeCode("L");
        location.setTypeDesc("Localisation");
        return location;
    }
}

