/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.workorders.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.comments.CommentService;
import ch.cern.eam.wshub.core.services.comments.entities.Comment;
import ch.cern.eam.wshub.core.services.comments.impl.CommentServiceImpl;
import ch.cern.eam.wshub.core.services.entities.BatchResponse;
import ch.cern.eam.wshub.core.services.workorders.WorkOrderService;
import ch.cern.eam.wshub.core.services.workorders.impl.StandardWorkOrderServiceImpl;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.standardworkorder_001.StandardWorkOrder;
import net.datastream.schemas.mp_entities.workorder_001.WorkOrder;
import net.datastream.schemas.mp_fields.ORGANIZATIONID_Type;
import net.datastream.schemas.mp_fields.STATUS_Type;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_functions.mp0023_001.MP0023_AddWorkOrder_001;
import net.datastream.schemas.mp_functions.mp0024_001.MP0024_GetWorkOrder_001;
import net.datastream.schemas.mp_functions.mp0025_001.MP0025_SyncWorkOrder_001;
import net.datastream.schemas.mp_functions.mp0026_001.MP0026_GetWorkOrderDefault_001;
import net.datastream.schemas.mp_functions.mp0055_001.MP0055_DeleteWorkOrder_001;
import net.datastream.schemas.mp_functions.mp7161_001.MP7161_ChangeWorkOrderStatus_001;
import net.datastream.schemas.mp_results.mp0023_001.MP0023_AddWorkOrder_001_Result;
import net.datastream.schemas.mp_results.mp0024_001.MP0024_GetWorkOrder_001_Result;
import net.datastream.schemas.mp_results.mp0026_001.MP0026_GetWorkOrderDefault_001_Result;
import net.datastream.schemas.mp_results.mp0026_001.ResultData;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class WorkOrderServiceImpl
implements WorkOrderService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private CommentService comments;
    private StandardWorkOrderServiceImpl standardWorkOrderServiceImpl;

    public WorkOrderServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.comments = new CommentServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
        this.standardWorkOrderServiceImpl = new StandardWorkOrderServiceImpl(applicationData, tools, inforWebServicesToolkitClient);
    }

    @Override
    public BatchResponse<String> createWorkOrderBatch(InforContext context, List<ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder> workOrderParam) throws InforException {
        List callableList = workOrderParam.stream().map(wo -> () -> this.createWorkOrder(context, (ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder)wo)).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public BatchResponse<ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder> readWorkOrderBatch(InforContext context, List<String> workOrderNumbers) {
        List callableList = workOrderNumbers.stream().map(workOrderNumber -> () -> this.readWorkOrder(context, (String)workOrderNumber)).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public BatchResponse<String> updateWorkOrderBatch(InforContext context, List<ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder> workOrders) throws InforException {
        List callableList = workOrders.stream().map(workOrder -> () -> this.updateWorkOrder(context, (ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder)workOrder)).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public BatchResponse<String> deleteWorkOrderBatch(InforContext context, List<String> workOrderNumbers) throws InforException {
        List callableList = workOrderNumbers.stream().map(workOrderNumber -> () -> this.deleteWorkOrder(context, (String)workOrderNumber)).collect(Collectors.toList());
        return this.tools.processCallables(callableList);
    }

    @Override
    public ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder readWorkOrder(InforContext context, String number) throws InforException {
        WorkOrder inforWorkOrder = this.readWorkOrderInfor(context, number);
        return this.tools.getInforFieldTools().transformInforObject(new ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder(), inforWorkOrder);
    }

    public WorkOrder readWorkOrderInfor(InforContext context, String number) throws InforException {
        MP0024_GetWorkOrder_001 getWorkOrder = new MP0024_GetWorkOrder_001();
        getWorkOrder.setWORKORDERID(new WOID_Type());
        getWorkOrder.getWORKORDERID().setJOBNUM(number);
        getWorkOrder.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP0024_GetWorkOrder_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.getWorkOrderOp(getWorkOrder, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.getWorkOrderOp(getWorkOrder, this.tools.getOrganizationCode(context), null, "", new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        return result.getResultData().getWorkOrder();
    }

    @Override
    public ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder readWorkOrderDefault(InforContext context, String number) throws InforException {
        MP0026_GetWorkOrderDefault_001 getWorkOrderDefault = new MP0026_GetWorkOrderDefault_001();
        getWorkOrderDefault.setORGANIZATIONID(new ORGANIZATIONID_Type());
        getWorkOrderDefault.getORGANIZATIONID().setORGANIZATIONCODE(context.getOrganizationCode());
        MP0026_GetWorkOrderDefault_001_Result getWODefaultResult = null;
        getWODefaultResult = context.getCredentials() != null ? this.inforws.getWorkOrderDefaultOp(getWorkOrderDefault, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.getWorkOrderDefaultOp(getWorkOrderDefault, this.tools.getOrganizationCode(context), null, "", new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        ResultData resultData = getWODefaultResult.getResultData();
        ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workOrder = new ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder();
        if (resultData.getSTATUS() != null) {
            workOrder.setStatusCode(resultData.getSTATUS().getSTATUSCODE());
        }
        if (resultData.getTYPE() != null) {
            workOrder.setTypeCode(resultData.getTYPE().getTYPECODE());
        }
        if (resultData.getTARGETDATE() != null) {
            this.tools.getDataTypeTools();
            workOrder.setScheduledStartDate(DataTypeTools.decodeInforDate(resultData.getTARGETDATE()));
        }
        if (resultData.getSCHEDEND() != null) {
            this.tools.getDataTypeTools();
            workOrder.setScheduledEndDate(DataTypeTools.decodeInforDate(resultData.getSCHEDEND()));
        }
        if (resultData.getREPORTED() != null) {
            this.tools.getDataTypeTools();
            workOrder.setReportedDate(DataTypeTools.decodeInforDate(resultData.getREPORTED()));
        }
        return workOrder;
    }

    @Override
    public String createWorkOrder(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workorderParam) throws InforException {
        WorkOrder inforWorkOrder = new WorkOrder();
        if (workorderParam.getStandardWO() != null && !workorderParam.getStandardWO().trim().equals("")) {
            StandardWorkOrder standardWO = this.standardWorkOrderServiceImpl.readStandardWorkOrderInfor(context, workorderParam.getStandardWO());
            inforWorkOrder.setPERMITREVIEWEDBY(standardWO.getPERMITREVIEWEDBY());
            inforWorkOrder.setPRIORITY(standardWO.getPRIORITY());
            inforWorkOrder.setPROBLEMCODEID(standardWO.getPROBLEMCODEID());
            inforWorkOrder.setSAFETYREVIEWEDBY(standardWO.getSAFETYREVIEWEDBY());
            inforWorkOrder.setSTANDARDWO(standardWO.getSTANDARDWO());
            inforWorkOrder.setUSERDEFINEDAREA(standardWO.getUSERDEFINEDAREA());
            inforWorkOrder.setCLASSID(standardWO.getWORKORDERCLASSID());
            inforWorkOrder.setTYPE(standardWO.getWORKORDERTYPE());
            workorderParam.setUserDefinedFields(this.tools.getUDFTools().readInforUserDefinedFields(standardWO.getUserDefinedFields()));
        }
        if (workorderParam.getCustomFields() != null && workorderParam.getCustomFields().length > 0) {
            if (workorderParam.getClassCode() != null && !workorderParam.getClassCode().trim().equals("")) {
                inforWorkOrder.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, "EVNT", workorderParam.getClassCode()));
            } else {
                inforWorkOrder.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, "EVNT", "*"));
            }
        }
        this.tools.getInforFieldTools().transformWSHubObject(inforWorkOrder, workorderParam, context);
        inforWorkOrder.getWORKORDERID().setJOBNUM("0");
        inforWorkOrder.setFIXED("V");
        MP0023_AddWorkOrder_001 addWO = new MP0023_AddWorkOrder_001();
        addWO.setWorkOrder(inforWorkOrder);
        MP0023_AddWorkOrder_001_Result result = context.getCredentials() != null ? this.inforws.addWorkOrderOp(addWO, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.addWorkOrderOp(addWO, this.tools.getOrganizationCode(context), null, "", new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        if (workorderParam.getComment() != null && !workorderParam.getComment().trim().equals("")) {
            Comment comment = new Comment();
            comment.setEntityCode("EVNT");
            comment.setEntityKeyCode(result.getResultData().getJOBNUM());
            comment.setText(workorderParam.getComment());
            comment.setTypeCode("*");
            this.comments.createComment(context, comment);
        }
        return result.getResultData().getJOBNUM();
    }

    @Override
    public String updateWorkOrder(InforContext context, ch.cern.eam.wshub.core.services.workorders.entities.WorkOrder workorderParam) throws InforException {
        WorkOrder inforWorkOrder = this.readWorkOrderInfor(context, workorderParam.getNumber());
        if (!(workorderParam.getClassCode() == null || inforWorkOrder.getCLASSID() != null && workorderParam.getClassCode().toUpperCase().equals(inforWorkOrder.getCLASSID().getCLASSCODE()))) {
            inforWorkOrder.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, "EVNT", workorderParam.getClassCode().toUpperCase()));
        }
        this.tools.getInforFieldTools().transformWSHubObject(inforWorkOrder, workorderParam, context);
        MP0025_SyncWorkOrder_001 syncWO = new MP0025_SyncWorkOrder_001();
        syncWO.setWorkOrder(inforWorkOrder);
        if (context.getCredentials() != null) {
            this.inforws.syncWorkOrderOp(syncWO, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context));
        } else {
            this.inforws.syncWorkOrderOp(syncWO, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        }
        return inforWorkOrder.getWORKORDERID().getJOBNUM();
    }

    @Override
    public String deleteWorkOrder(InforContext context, String workOrderNumber) throws InforException {
        MP0055_DeleteWorkOrder_001 deleteWO = new MP0055_DeleteWorkOrder_001();
        deleteWO.setWORKORDERID(new WOID_Type());
        deleteWO.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        deleteWO.getWORKORDERID().setJOBNUM(workOrderNumber);
        if (context.getCredentials() != null) {
            this.inforws.deleteWorkOrderOp(deleteWO, "*", this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context));
        } else {
            this.inforws.deleteWorkOrderOp(deleteWO, "*", null, null, new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        }
        return workOrderNumber;
    }

    @Override
    public String updateWorkOrderStatus(InforContext context, String workOrderNumber, String statusCode) throws InforException {
        MP7161_ChangeWorkOrderStatus_001 changeWOStatus = new MP7161_ChangeWorkOrderStatus_001();
        changeWOStatus.setWORKORDERID(new WOID_Type());
        changeWOStatus.getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
        changeWOStatus.getWORKORDERID().setJOBNUM(workOrderNumber);
        changeWOStatus.setNEWSTATUS(new STATUS_Type());
        changeWOStatus.getNEWSTATUS().setSTATUSCODE(statusCode);
        if (context.getCredentials() != null) {
            this.inforws.changeWorkOrderStatusOp(changeWOStatus, "*", this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context));
        } else {
            this.inforws.changeWorkOrderStatusOp(changeWOStatus, "*", null, null, new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        }
        return workOrderNumber;
    }
}

