/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.administration.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.administration.UserSetupService;
import ch.cern.eam.wshub.core.services.entities.CustomField;
import ch.cern.eam.wshub.core.services.entities.EAMUser;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.usersetup_001.UserSetup;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.USERID_Type;
import net.datastream.schemas.mp_functions.SessionType;
import net.datastream.schemas.mp_functions.mp0601_001.MP0601_GetUserSetup_001;
import net.datastream.schemas.mp_functions.mp0602_001.MP0602_AddUserSetup_001;
import net.datastream.schemas.mp_functions.mp0603_001.MP0603_SyncUserSetup_001;
import net.datastream.schemas.mp_functions.mp0604_001.MP0604_DeleteUserSetup_001;
import net.datastream.schemas.mp_functions.mp9532_001.MP9532_RunEmptyOp_001;
import net.datastream.schemas.mp_results.mp0601_001.MP0601_GetUserSetup_001_Result;
import net.datastream.schemas.mp_results.mp0602_001.MP0602_AddUserSetup_001_Result;
import net.datastream.schemas.mp_results.mp0603_001.MP0603_SyncUserSetup_001_Result;
import net.datastream.schemas.mp_results.mp9532_001.MP9532_RunEmptyOp_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class UserSetupServiceImpl
implements UserSetupService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public UserSetupServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String login(InforContext context, String userCode) throws InforException {
        MP9532_RunEmptyOp_001 runEmptyOp = new MP9532_RunEmptyOp_001();
        if (context != null && context.getCredentials() != null) {
            Holder sessionTypeHolder = new Holder();
            MP9532_RunEmptyOp_001_Result result = this.inforws.runEmptyOpOp(runEmptyOp, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "", sessionTypeHolder, null, this.tools.getTenant(context));
            return ((SessionType)sessionTypeHolder.value).getSessionId();
        }
        throw Tools.generateFault("Please supply valid credentials");
    }

    @Override
    public EAMUser readUserSetup(InforContext context, String userCode) throws InforException {
        MP0601_GetUserSetup_001_Result getUserSetupResult = null;
        MP0601_GetUserSetup_001 getUserSetup = new MP0601_GetUserSetup_001();
        getUserSetup.setUSERID(new USERID_Type());
        getUserSetup.getUSERID().setUSERCODE(userCode);
        getUserSetupResult = context.getCredentials() != null ? this.inforws.getUserSetupOp(getUserSetup, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.getUserSetupOp(getUserSetup, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        UserSetup userInfor = getUserSetupResult.getResultData().getUserSetup();
        EAMUser user = new EAMUser();
        user.setUserCode(userCode);
        if (userInfor.getUSERID() != null) {
            user.setUserCode(userInfor.getUSERID().getUSERCODE());
            user.setUserDesc(userInfor.getUSERID().getDESCRIPTION());
        }
        if (userInfor.getUSERGROUP() != null) {
            user.setUserGroup(userInfor.getUSERGROUP());
        }
        if (userInfor.getUSEREXPIREDATE() != null) {
            this.tools.getDataTypeTools();
            user.setUserIDExpirationDate(DataTypeTools.decodeInforDate(userInfor.getUSEREXPIREDATE()));
        }
        if (userInfor.getPASSWORD() != null) {
            user.setPassword(userInfor.getPASSWORD());
        }
        if (userInfor.getPASSEXPIREDATE() != null) {
            this.tools.getDataTypeTools();
            user.setPasswordExpirationDate(DataTypeTools.decodeInforDate(userInfor.getPASSEXPIREDATE()));
        }
        if (userInfor.getEMAIL() != null) {
            user.setEmailAddress(userInfor.getEMAIL());
        }
        if (userInfor.getDEPARTMENTCODE() != null) {
            user.setDepartment(userInfor.getDEPARTMENTCODE());
        }
        if (userInfor.getCLASSID() != null) {
            user.setClassCode(userInfor.getCLASSID().getCLASSCODE());
        }
        user.setCustomFields(this.tools.getCustomFieldsTools().readInforCustomFields(userInfor.getUSERDEFINEDAREA()));
        user.setUserDefinedFields(this.tools.getUDFTools().readInforUserDefinedFields(userInfor.getStandardUserDefinedFields()));
        user.setUdfchar01(user.getUserDefinedFields().getUdfchar01());
        user.setUdfchar02(user.getUserDefinedFields().getUdfchar02());
        user.setUdfchar03(user.getUserDefinedFields().getUdfchar03());
        user.setUdfchar04(user.getUserDefinedFields().getUdfchar04());
        user.setUdfchar05(user.getUserDefinedFields().getUdfchar05());
        user.setUdfchar06(user.getUserDefinedFields().getUdfchar06());
        user.setUdfchar07(user.getUserDefinedFields().getUdfchar07());
        user.setUdfchar08(user.getUserDefinedFields().getUdfchar08());
        user.setUdfchar09(user.getUserDefinedFields().getUdfchar09());
        user.setCernId(Arrays.asList(user.getCustomFields()).stream().filter(cf -> "0002".equals(cf.getCode())).map(CustomField::getValue).findFirst().orElse(null));
        return user;
    }

    @Override
    public String createUserSetup(InforContext context, EAMUser userParam) throws InforException {
        UserSetup userInfor = new UserSetup();
        if (userParam.getCustomFields() != null && userParam.getCustomFields().length > 0) {
            if (userParam.getClassCode() != null && !userParam.getClassCode().trim().equals("")) {
                userInfor.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, "USER", userParam.getClassCode()));
            } else {
                userInfor.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, "USER", "*"));
            }
        }
        this.initializeInforUserObject(userInfor, userParam, context);
        MP0602_AddUserSetup_001 addUser = new MP0602_AddUserSetup_001();
        addUser.setUserSetup(userInfor);
        MP0602_AddUserSetup_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.addUserSetupOp(addUser, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.addUserSetupOp(addUser, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return result.getUSERID().getUSERCODE();
    }

    @Override
    public String updateUserSetup(InforContext context, EAMUser userParam) throws InforException {
        MP0601_GetUserSetup_001_Result getUserSetupResult = null;
        MP0601_GetUserSetup_001 getUserSetup = new MP0601_GetUserSetup_001();
        getUserSetup.setUSERID(new USERID_Type());
        getUserSetup.getUSERID().setUSERCODE(userParam.getUserCode());
        getUserSetupResult = context.getCredentials() != null ? this.inforws.getUserSetupOp(getUserSetup, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.getUserSetupOp(getUserSetup, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        UserSetup userInfor = getUserSetupResult.getResultData().getUserSetup();
        if (!(userParam.getClassCode() == null || userInfor.getCLASSID() != null && userParam.getClassCode().toUpperCase().equals(userInfor.getCLASSID().getCLASSCODE()))) {
            userInfor.setUSERDEFINEDAREA(this.tools.getCustomFieldsTools().getInforCustomFields(context, "USER", userParam.getClassCode().toUpperCase()));
        }
        this.initializeInforUserObject(userInfor, userParam, context);
        MP0603_SyncUserSetup_001 syncUser = new MP0603_SyncUserSetup_001();
        syncUser.setUserSetup(userInfor);
        MP0603_SyncUserSetup_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.syncUserSetupOp(syncUser, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.syncUserSetupOp(syncUser, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return result.getUSERID().getUSERCODE();
    }

    @Override
    public String deleteUserSetup(InforContext context, String userCode) throws InforException {
        MP0604_DeleteUserSetup_001 deleteUser = new MP0604_DeleteUserSetup_001();
        deleteUser.setUSERID(new USERID_Type());
        deleteUser.getUSERID().setUSERCODE(userCode);
        if (context.getCredentials() != null) {
            this.inforws.deleteUserSetupOp(deleteUser, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
        } else {
            this.inforws.deleteUserSetupOp(deleteUser, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return "success";
    }

    private void initializeInforUserObject(UserSetup userInfor, EAMUser userParam, InforContext context) throws InforException {
        if (userInfor.getUSERID() == null) {
            userInfor.setUSERID(new USERID_Type());
            userInfor.getUSERID().setUSERCODE(userParam.getUserCode().toUpperCase().trim());
            userInfor.setLANGUAGE("EN");
            this.tools.getDataTypeTools();
            userInfor.setMSGTIMEOUT(DataTypeTools.encodeAmount(BigDecimal.TEN, "Success Msg. Timeout"));
        }
        if (userParam.getUserDesc() != null) {
            userInfor.getUSERID().setDESCRIPTION(userParam.getUserDesc());
        }
        if (userParam.getUserGroup() != null) {
            userInfor.setUSERGROUP(userParam.getUserGroup());
        }
        if (userParam.getUserIDExpirationDate() != null) {
            this.tools.getDataTypeTools();
            userInfor.setUSEREXPIREDATE(DataTypeTools.encodeInforDate(userParam.getUserIDExpirationDate(), "User Id expiration date"));
        }
        if (userParam.getPassword() != null) {
            userInfor.setPASSWORD(userParam.getPassword());
        }
        if (userParam.getPasswordExpirationDate() != null) {
            this.tools.getDataTypeTools();
            userInfor.setPASSEXPIREDATE(DataTypeTools.encodeInforDate(userParam.getPasswordExpirationDate(), "Password Expiration Date"));
        }
        if (userParam.getEmailAddress() != null) {
            userInfor.setEMAIL(userParam.getEmailAddress());
        }
        if (userParam.getDepartment() != null) {
            userInfor.setDEPARTMENTCODE(userParam.getDepartment());
        }
        userInfor.setISCONNECTOR("+");
        if (userParam.getClassCode() != null) {
            if (userParam.getClassCode().trim().equals("")) {
                userInfor.setCLASSID(null);
            } else {
                userInfor.setCLASSID(new CLASSID_Type());
                userInfor.getCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
                userInfor.getCLASSID().setCLASSCODE(userParam.getClassCode().toUpperCase().trim());
            }
        }
        this.tools.getCustomFieldsTools().updateInforCustomFields(userInfor.getUSERDEFINEDAREA(), userParam.getCustomFields());
        this.tools.getUDFTools().updateInforUserDefinedFields(userInfor.getStandardUserDefinedFields(), userParam.getUserDefinedFields());
    }
}

