/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.EquipmentOtherService;
import ch.cern.eam.wshub.core.services.equipment.entities.EquipmentCampaign;
import ch.cern.eam.wshub.core.services.equipment.entities.EquipmentDepreciation;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import java.math.BigDecimal;
import javax.persistence.EntityManager;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.campaignequipment_001.CampaignEquipment;
import net.datastream.schemas.mp_entities.depreciation_001.Depreciation;
import net.datastream.schemas.mp_entities.depreciation_001.RemainingUsefulLife;
import net.datastream.schemas.mp_entities.depreciationdefault_001.DepreciationDefault;
import net.datastream.schemas.mp_fields.CAMPAIGNEQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.CAMPAIGNID_Type;
import net.datastream.schemas.mp_fields.DEPRECIATIONCATEGORYID_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.StandardUserDefinedFields;
import net.datastream.schemas.mp_fields.UOMID_Type;
import net.datastream.schemas.mp_functions.mp3015_001.MP3015_GetDepreciationDefault_001;
import net.datastream.schemas.mp_functions.mp3016_001.MP3016_GetDepreciation_001;
import net.datastream.schemas.mp_functions.mp3017_001.MP3017_AddDepreciation_001;
import net.datastream.schemas.mp_functions.mp3018_001.MP3018_SyncDepreciation_001;
import net.datastream.schemas.mp_functions.mp3291_001.ChangeEquipmentNumber;
import net.datastream.schemas.mp_functions.mp3291_001.MP3291_ChangeEquipmentNumber_001;
import net.datastream.schemas.mp_functions.mp5039_001.MP5039_AddCampaignEquipment_001;
import net.datastream.schemas.mp_results.mp3016_001.MP3016_GetDepreciation_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class EquipmentOtherServiceImpl
implements EquipmentOtherService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public EquipmentOtherServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createEquipmentDepreciation(InforContext context, EquipmentDepreciation equipmentDepreciation) throws InforException {
        MP3015_GetDepreciationDefault_001 getdepdef = new MP3015_GetDepreciationDefault_001();
        getdepdef.setEQUIPMENTID(new EQUIPMENTID_Type());
        getdepdef.getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        getdepdef.getEQUIPMENTID().setEQUIPMENTCODE(equipmentDepreciation.getEquipmentCode());
        getdepdef.setDEPRECIATIONCATEGORYID(new DEPRECIATIONCATEGORYID_Type());
        if (equipmentDepreciation.getDepreciationCategory() != null) {
            getdepdef.getDEPRECIATIONCATEGORYID().setDEPRECIATIONCATEGORYCODE(equipmentDepreciation.getDepreciationCategory().trim());
        } else {
            getdepdef.getDEPRECIATIONCATEGORYID().setDEPRECIATIONCATEGORYCODE("C");
        }
        if (equipmentDepreciation.getDepreciationType() != null) {
            getdepdef.setEQUIPMENTDEPTYPE(equipmentDepreciation.getDepreciationType().toUpperCase().trim());
        } else {
            getdepdef.setEQUIPMENTDEPTYPE("*");
        }
        this.tools.getDataTypeTools();
        getdepdef.setFROMDATE(DataTypeTools.formatDate(equipmentDepreciation.getFromDate(), "From Date"));
        DepreciationDefault depreciationDefault = context.getCredentials() != null ? this.inforws.getDepreciationDefaultOp(getdepdef, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)).getResultData().getDepreciationDefault() : this.inforws.getDepreciationDefaultOp(getdepdef, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context)).getResultData().getDepreciationDefault();
        Depreciation depreciation = new Depreciation();
        this.tools.getDataTypeTools();
        depreciation.setDEPRECIATIONPK(DataTypeTools.encodeQuantity(BigDecimal.ZERO, "Depreciation PK"));
        if (equipmentDepreciation.getOriginalValue() != null) {
            this.tools.getDataTypeTools();
            depreciation.setORIGINALVALUE(DataTypeTools.encodeAmount(equipmentDepreciation.getOriginalValue(), "Original Value"));
        } else {
            depreciation.setORIGINALVALUE(depreciationDefault.getORIGINALVALUE());
        }
        if (equipmentDepreciation.getResidualValue() != null) {
            this.tools.getDataTypeTools();
            depreciation.setRESIDUALVALUE(DataTypeTools.encodeAmount(equipmentDepreciation.getResidualValue(), "Residual Value"));
        } else {
            depreciation.setRESIDUALVALUE(depreciationDefault.getRESIDUALVALUE());
        }
        if (equipmentDepreciation.getEstimatedUsefulLife() != null) {
            depreciation.setRemainingUsefulLife(new RemainingUsefulLife());
            if (equipmentDepreciation.getEstimatedUsefulLifeUOM() != null && !equipmentDepreciation.getEstimatedUsefulLifeUOM().trim().equals("")) {
                depreciation.getRemainingUsefulLife().setUOMID(new UOMID_Type());
                depreciation.getRemainingUsefulLife().getUOMID().setUOMCODE(equipmentDepreciation.getEstimatedUsefulLifeUOM().trim());
            } else {
                depreciation.getRemainingUsefulLife().setUOMID(new UOMID_Type());
                depreciation.getRemainingUsefulLife().getUOMID().setUOMCODE("Y");
            }
            RemainingUsefulLife remainingUsefulLife = depreciation.getRemainingUsefulLife();
            this.tools.getDataTypeTools();
            remainingUsefulLife.setESTIMATEDLIFE(DataTypeTools.encodeAmount(equipmentDepreciation.getEstimatedUsefulLife(), "Estimated Useful Life"));
        } else {
            depreciation.setRemainingUsefulLife(new RemainingUsefulLife());
            depreciation.getRemainingUsefulLife().setESTIMATEDLIFE(depreciationDefault.getRemainingUsefulLife().getESTIMATEDLIFE());
            depreciation.getRemainingUsefulLife().setUOMID(depreciationDefault.getRemainingUsefulLife().getUOMID());
        }
        if (equipmentDepreciation.getDepreciationMethod() != null) {
            depreciation.setDEPRECIATIONMETHOD(equipmentDepreciation.getDepreciationMethod().trim());
        }
        if (equipmentDepreciation.getEquipmentCode() != null) {
            depreciation.setEQUIPMENTID(new EQUIPMENTID_Type());
            depreciation.getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            depreciation.getEQUIPMENTID().setEQUIPMENTCODE(equipmentDepreciation.getEquipmentCode().trim());
        }
        if (equipmentDepreciation.getDepreciationType() != null) {
            depreciation.setEQUIPMENTDEPTYPE(equipmentDepreciation.getDepreciationType().toUpperCase().trim());
        } else {
            depreciation.setEQUIPMENTDEPTYPE("*");
        }
        if (equipmentDepreciation.getDepreciationCategory() != null) {
            depreciation.setDEPRECIATIONCATEGORYID(new DEPRECIATIONCATEGORYID_Type());
            depreciation.getDEPRECIATIONCATEGORYID().setDEPRECIATIONCATEGORYCODE(equipmentDepreciation.getDepreciationCategory().trim());
        } else {
            depreciation.setDEPRECIATIONCATEGORYID(new DEPRECIATIONCATEGORYID_Type());
            depreciation.getDEPRECIATIONCATEGORYID().setDEPRECIATIONCATEGORYCODE("C");
        }
        if (equipmentDepreciation.getFromDate() != null) {
            this.tools.getDataTypeTools();
            depreciation.setFROMDATE(DataTypeTools.formatDate(equipmentDepreciation.getFromDate().trim(), "From Date"));
        } else {
            depreciation.setFROMDATE(depreciationDefault.getFROMDATE());
        }
        if (equipmentDepreciation.getChangeValue() != null) {
            this.tools.getDataTypeTools();
            depreciation.setCHANGEVALUE(DataTypeTools.encodeAmount(equipmentDepreciation.getChangeValue(), "Change Value"));
        }
        if (equipmentDepreciation.getChangeLife() != null) {
            this.tools.getDataTypeTools();
            depreciation.setCHANGELIFE(DataTypeTools.encodeAmount(equipmentDepreciation.getChangeLife(), "Change Life"));
        }
        if (equipmentDepreciation.getChangeEstimatedLifetimeOutput() != null) {
            this.tools.getDataTypeTools();
            depreciation.setCHANGEESTLIFETIMEOUTPUT(DataTypeTools.encodeAmount(equipmentDepreciation.getChangeEstimatedLifetimeOutput(), "Change Estimated Lifetime Output"));
        }
        depreciation.setStandardUserDefinedFields(new StandardUserDefinedFields());
        this.tools.getUDFTools().updateInforUserDefinedFields(depreciation.getStandardUserDefinedFields(), equipmentDepreciation.getUserDefinedFields());
        MP3017_AddDepreciation_001 adddep = new MP3017_AddDepreciation_001();
        adddep.setDepreciation(depreciation);
        if (context.getCredentials() != null) {
            this.inforws.addDepreciationOp(adddep, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
        } else {
            this.inforws.addDepreciationOp(adddep, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return "OK";
    }

    @Override
    public String updateEquipmentDepreciation(InforContext context, EquipmentDepreciation equipmentDepreciation) throws InforException {
        if (equipmentDepreciation.getDepreciationPK() == null) {
            if (equipmentDepreciation.getEquipmentCode() == null) {
                throw Tools.generateFault("Equipment Code is mandatory field");
            }
            try (EntityManager em = this.tools.getEntityManager();){
                equipmentDepreciation.setDepreciationPK(((EquipmentDepreciation)em.createNamedQuery("GETDEPRECIATION", EquipmentDepreciation.class).setParameter("equipmentCode", (Object)equipmentDepreciation.getEquipmentCode().trim().toUpperCase()).getSingleResult()).getDepreciationPK());
            }
        }
        MP3016_GetDepreciation_001 getdep = new MP3016_GetDepreciation_001();
        this.tools.getDataTypeTools();
        getdep.setDEPRECIATIONPK(DataTypeTools.encodeQuantity(equipmentDepreciation.getDepreciationPK(), "Depreciation PK"));
        MP3016_GetDepreciation_001_Result result = context.getCredentials() != null ? this.inforws.getDepreciationOp(getdep, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.getDepreciationOp(getdep, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        Depreciation depreciation = result.getResultData().getDepreciation();
        if (equipmentDepreciation.getOriginalValue() != null) {
            this.tools.getDataTypeTools();
            depreciation.setORIGINALVALUE(DataTypeTools.encodeAmount(equipmentDepreciation.getOriginalValue(), "Original Value"));
        }
        if (equipmentDepreciation.getResidualValue() != null) {
            this.tools.getDataTypeTools();
            depreciation.setRESIDUALVALUE(DataTypeTools.encodeAmount(equipmentDepreciation.getResidualValue(), "Residual Value"));
        }
        if (equipmentDepreciation.getEstimatedUsefulLifeUOM() != null) {
            depreciation.getRemainingUsefulLife().setUOMID(new UOMID_Type());
            depreciation.getRemainingUsefulLife().getUOMID().setUOMCODE(equipmentDepreciation.getEstimatedUsefulLifeUOM().toUpperCase());
            this.tools.getDataTypeTools();
            BigDecimal amount = DataTypeTools.decodeAmount(depreciation.getRemainingUsefulLife().getESTIMATEDLIFE());
            RemainingUsefulLife remainingUsefulLife = depreciation.getRemainingUsefulLife();
            this.tools.getDataTypeTools();
            remainingUsefulLife.setESTIMATEDLIFE(DataTypeTools.encodeAmount(amount, "Estiamted Life Time"));
        }
        if (equipmentDepreciation.getEstimatedUsefulLife() != null) {
            RemainingUsefulLife remainingUsefulLife = depreciation.getRemainingUsefulLife();
            this.tools.getDataTypeTools();
            remainingUsefulLife.setESTIMATEDLIFE(DataTypeTools.encodeAmount(equipmentDepreciation.getEstimatedUsefulLife(), "Estiamted Life Time"));
        }
        if (equipmentDepreciation.getDepreciationMethod() != null) {
            depreciation.setDEPRECIATIONMETHOD(equipmentDepreciation.getDepreciationMethod());
        }
        if (equipmentDepreciation.getDepreciationType() != null) {
            depreciation.setEQUIPMENTDEPTYPE(equipmentDepreciation.getDepreciationType().toUpperCase());
        }
        if (equipmentDepreciation.getDepreciationCategory() != null) {
            depreciation.setDEPRECIATIONCATEGORYID(new DEPRECIATIONCATEGORYID_Type());
            depreciation.getDEPRECIATIONCATEGORYID().setDEPRECIATIONCATEGORYCODE(equipmentDepreciation.getDepreciationCategory());
        }
        if (equipmentDepreciation.getFromDate() != null) {
            this.tools.getDataTypeTools();
            depreciation.setFROMDATE(DataTypeTools.formatDate(equipmentDepreciation.getFromDate(), "From Date"));
        }
        if (depreciation.getStandardUserDefinedFields() == null) {
            depreciation.setStandardUserDefinedFields(new StandardUserDefinedFields());
        }
        this.tools.getUDFTools().updateInforUserDefinedFields(depreciation.getStandardUserDefinedFields(), equipmentDepreciation.getUserDefinedFields());
        if (equipmentDepreciation.getChangeValue() != null) {
            this.tools.getDataTypeTools();
            depreciation.setCHANGEVALUE(DataTypeTools.encodeAmount(equipmentDepreciation.getChangeValue(), "Change Value"));
        }
        if (equipmentDepreciation.getChangeLife() != null) {
            this.tools.getDataTypeTools();
            depreciation.setCHANGELIFE(DataTypeTools.encodeAmount(equipmentDepreciation.getChangeLife(), "Change Life"));
        }
        if (equipmentDepreciation.getChangeEstimatedLifetimeOutput() != null) {
            this.tools.getDataTypeTools();
            depreciation.setCHANGEESTLIFETIMEOUTPUT(DataTypeTools.encodeAmount(equipmentDepreciation.getChangeEstimatedLifetimeOutput(), "Change Estimated Lifetime Output"));
        }
        MP3018_SyncDepreciation_001 syncdep = new MP3018_SyncDepreciation_001();
        syncdep.setDepreciation(depreciation);
        if (context.getCredentials() != null) {
            this.inforws.syncDepreciationOp(syncdep, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
        } else {
            this.inforws.syncDepreciationOp(syncdep, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return "OK";
    }

    @Override
    public String updateEquipmentCode(InforContext context, String equipmentCode, String equipmentNewCode, String equipmentType) throws InforException {
        MP3291_ChangeEquipmentNumber_001 changeeqpnum = new MP3291_ChangeEquipmentNumber_001();
        changeeqpnum.setChangeEquipmentNumber(new ChangeEquipmentNumber());
        changeeqpnum.getChangeEquipmentNumber().setCURRENTEQUIPMENTID(new EQUIPMENTID_Type());
        changeeqpnum.getChangeEquipmentNumber().getCURRENTEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        changeeqpnum.getChangeEquipmentNumber().getCURRENTEQUIPMENTID().setEQUIPMENTCODE(equipmentCode);
        changeeqpnum.getChangeEquipmentNumber().setNEWEQUIPMENTID(new EQUIPMENTID_Type());
        changeeqpnum.getChangeEquipmentNumber().getNEWEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        changeeqpnum.getChangeEquipmentNumber().getNEWEQUIPMENTID().setEQUIPMENTCODE(equipmentNewCode);
        if (context.getCredentials() != null) {
            this.inforws.changeEquipmentNumberOp(changeeqpnum, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context));
        } else {
            this.inforws.changeEquipmentNumberOp(changeeqpnum, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        }
        return "OK";
    }

    @Override
    public String createEquipmentCampaign(InforContext context, EquipmentCampaign equipmentCampaign) throws InforException {
        CampaignEquipment campaignEquipment = new CampaignEquipment();
        campaignEquipment.setCAMPAIGNEQUIPMENTID(new CAMPAIGNEQUIPMENTID_Type());
        campaignEquipment.getCAMPAIGNEQUIPMENTID().setCAMPAIGNID(new CAMPAIGNID_Type());
        campaignEquipment.getCAMPAIGNEQUIPMENTID().getCAMPAIGNID().setCAMPAIGNCODE(equipmentCampaign.getCampaign());
        campaignEquipment.getCAMPAIGNEQUIPMENTID().getCAMPAIGNID().setORGANIZATIONID(this.tools.getOrganization(context));
        campaignEquipment.getCAMPAIGNEQUIPMENTID().setEQUIPMENTID(new EQUIPMENTID_Type());
        campaignEquipment.getCAMPAIGNEQUIPMENTID().getEQUIPMENTID().setEQUIPMENTCODE(equipmentCampaign.getEquipment());
        campaignEquipment.getCAMPAIGNEQUIPMENTID().getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        MP5039_AddCampaignEquipment_001 addCampaignEquipment = new MP5039_AddCampaignEquipment_001();
        addCampaignEquipment.setCampaignEquipment(campaignEquipment);
        if (context.getCredentials() != null) {
            this.inforws.addCampaignEquipmentOp(addCampaignEquipment, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
        } else {
            this.inforws.addCampaignEquipmentOp(addCampaignEquipment, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return null;
    }
}

