/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.equipment.impl;

import ch.cern.eam.wshub.core.annotations.BooleanType;
import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.equipment.PMScheduleService;
import ch.cern.eam.wshub.core.services.equipment.entities.EquipmentPMSchedule;
import ch.cern.eam.wshub.core.services.equipment.entities.ReleasedPMSchedule;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import javax.persistence.EntityManager;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.pmschedule_001.PMScheduleData;
import net.datastream.schemas.mp_entities.releasedpm_001.ReleasedPM;
import net.datastream.schemas.mp_fields.CLASSID_Type;
import net.datastream.schemas.mp_fields.COSTCODEID_Type;
import net.datastream.schemas.mp_fields.DEPARTMENTID_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.LOCATIONID_Type;
import net.datastream.schemas.mp_fields.METERINTERVAL_Type;
import net.datastream.schemas.mp_fields.PERIODINTERVAL;
import net.datastream.schemas.mp_fields.PERSONID_Type;
import net.datastream.schemas.mp_fields.PMSCHEDULEEQUIPMENTID;
import net.datastream.schemas.mp_fields.PPM_Type;
import net.datastream.schemas.mp_fields.ROUTE_Type;
import net.datastream.schemas.mp_fields.SUPERVISORID;
import net.datastream.schemas.mp_fields.UOMID_Type;
import net.datastream.schemas.mp_functions.mp0364_001.MP0364_AddEquipmentPMSchedule_001;
import net.datastream.schemas.mp_functions.mp0365_001.MP0365_SyncEquipmentPMSchedule_001;
import net.datastream.schemas.mp_functions.mp3014_001.MP3014_GetEquipmentPMSchedule_001;
import net.datastream.schemas.mp_functions.mp7006_001.MP7006_DeletePMScheduleEquipment_001;
import net.datastream.schemas.mp_functions.mp7433_001.MP7433_SyncReleasedPM_001;
import net.datastream.schemas.mp_results.mp0364_001.MP0364_AddEquipmentPMSchedule_001_Result;
import net.datastream.schemas.mp_results.mp0365_001.MP0365_SyncEquipmentPMSchedule_001_Result;
import net.datastream.schemas.mp_results.mp3014_001.MP3014_GetEquipmentPMSchedule_001_Result;
import net.datastream.schemas.mp_results.mp7006_001.MP7006_DeletePMScheduleEquipment_001_Result;
import net.datastream.schemas.mp_results.mp7433_001.MP7433_SyncReleasedPM_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class PMScheduleServiceImpl
implements PMScheduleService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;

    public PMScheduleServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
    }

    @Override
    public String createEquipmentPMSchedule(InforContext context, EquipmentPMSchedule pmSchedule) throws InforException {
        MP0364_AddEquipmentPMSchedule_001 pmschedule = new MP0364_AddEquipmentPMSchedule_001();
        pmschedule.setPMScheduleData(new PMScheduleData());
        pmschedule.getPMScheduleData().setEQUIPMENTID(new EQUIPMENTID_Type());
        pmschedule.getPMScheduleData().getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        pmschedule.getPMScheduleData().getEQUIPMENTID().setEQUIPMENTCODE(pmSchedule.getEquipmentCode());
        pmschedule.getPMScheduleData().setPERIODINTERVAL(new PERIODINTERVAL());
        if (pmSchedule.getPeriodLength() != null && pmSchedule.getPeriodUOM() != null) {
            pmschedule.getPMScheduleData().getPERIODINTERVAL().setINTERVAL(this.tools.getDataTypeTools().encodeLong(pmSchedule.getPeriodLength(), "Period Length"));
            pmschedule.getPMScheduleData().getPERIODINTERVAL().setUOM(pmSchedule.getPeriodUOM());
        }
        if (pmSchedule.getDueDate() != null) {
            PERIODINTERVAL pERIODINTERVAL = pmschedule.getPMScheduleData().getPERIODINTERVAL();
            this.tools.getDataTypeTools();
            pERIODINTERVAL.setDUEDATE(DataTypeTools.formatDate(pmSchedule.getDueDate(), "PM Schedule Due Date"));
        }
        pmschedule.getPMScheduleData().setPMSCHEDULEEQUIPMENTID(new PMSCHEDULEEQUIPMENTID());
        pmschedule.getPMScheduleData().getPMSCHEDULEEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        pmschedule.getPMScheduleData().getPMSCHEDULEEQUIPMENTID().setPPMID(new PPM_Type());
        pmschedule.getPMScheduleData().getPMSCHEDULEEQUIPMENTID().getPPMID().setORGANIZATIONID(this.tools.getOrganization(context));
        pmschedule.getPMScheduleData().getPMSCHEDULEEQUIPMENTID().getPPMID().setPPMCODE(pmSchedule.getPmCode());
        pmschedule.getPMScheduleData().setDEPARTMENTID(new DEPARTMENTID_Type());
        pmschedule.getPMScheduleData().getDEPARTMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        pmschedule.getPMScheduleData().getDEPARTMENTID().setDEPARTMENTCODE(pmSchedule.getDepartmentCode());
        if (pmSchedule.getRoute() != null && !pmSchedule.getRoute().trim().equals("")) {
            pmschedule.getPMScheduleData().setROUTE(new ROUTE_Type());
            pmschedule.getPMScheduleData().getROUTE().setORGANIZATIONID(this.tools.getOrganization(context));
            pmschedule.getPMScheduleData().getROUTE().setROUTECODE(pmSchedule.getRoute());
        }
        if (pmSchedule.getScheduleType() == null || pmSchedule.getScheduleType().trim().equals("")) {
            pmschedule.getPMScheduleData().setPMSCHEDULETYPE("F");
        } else {
            pmschedule.getPMScheduleData().setPMSCHEDULETYPE(pmSchedule.getScheduleType());
        }
        if (pmSchedule.getChanged() != null) {
            PMScheduleData pMScheduleData = pmschedule.getPMScheduleData();
            this.tools.getDataTypeTools();
            pMScheduleData.setCHANGED(DataTypeTools.encodeBoolean(pmSchedule.getChanged(), BooleanType.TRUE_FALSE));
        } else {
            pmschedule.getPMScheduleData().setCHANGED("false");
        }
        if (pmSchedule.getSupervisor() != null) {
            pmschedule.getPMScheduleData().setSUPERVISORID(new SUPERVISORID());
            pmschedule.getPMScheduleData().getSUPERVISORID().setORGANIZATIONID(this.tools.getOrganization(context));
            pmschedule.getPMScheduleData().getSUPERVISORID().setSUPERVISORCODE(pmSchedule.getSupervisor().toUpperCase());
        }
        if (pmSchedule.getCostCode() != null) {
            pmschedule.getPMScheduleData().setCOSTCODEID(new COSTCODEID_Type());
            pmschedule.getPMScheduleData().getCOSTCODEID().setORGANIZATIONID(this.tools.getOrganization(context));
            pmschedule.getPMScheduleData().getCOSTCODEID().setCOSTCODE(pmSchedule.getCostCode().toUpperCase());
        }
        if (pmSchedule.getMeter1Due() != null || pmSchedule.getMeter1Interval() != null || pmSchedule.getMeter1UOM() != null) {
            pmschedule.getPMScheduleData().setMETER1INTERVAL(new METERINTERVAL_Type());
            METERINTERVAL_Type mETERINTERVAL_Type = pmschedule.getPMScheduleData().getMETER1INTERVAL();
            this.tools.getDataTypeTools();
            mETERINTERVAL_Type.setINTERVAL(DataTypeTools.encodeQuantity(pmSchedule.getMeter1Interval(), "Meter 1 Interval"));
            METERINTERVAL_Type mETERINTERVAL_Type2 = pmschedule.getPMScheduleData().getMETER1INTERVAL();
            this.tools.getDataTypeTools();
            mETERINTERVAL_Type2.setREADINGDUE(DataTypeTools.encodeQuantity(pmSchedule.getMeter1Due(), "Meter 1 Due"));
            pmschedule.getPMScheduleData().getMETER1INTERVAL().setUOMID(new UOMID_Type());
            pmschedule.getPMScheduleData().getMETER1INTERVAL().getUOMID().setUOMCODE(pmSchedule.getMeter1UOM());
        }
        if (pmSchedule.getMeter2Due() != null || pmSchedule.getMeter2Interval() != null || pmSchedule.getMeter2UOM() != null) {
            pmschedule.getPMScheduleData().setMETER2INTERVAL(new METERINTERVAL_Type());
            METERINTERVAL_Type mETERINTERVAL_Type = pmschedule.getPMScheduleData().getMETER2INTERVAL();
            this.tools.getDataTypeTools();
            mETERINTERVAL_Type.setINTERVAL(DataTypeTools.encodeQuantity(pmSchedule.getMeter2Interval(), "Meter 2 Interval"));
            METERINTERVAL_Type mETERINTERVAL_Type3 = pmschedule.getPMScheduleData().getMETER2INTERVAL();
            this.tools.getDataTypeTools();
            mETERINTERVAL_Type3.setREADINGDUE(DataTypeTools.encodeQuantity(pmSchedule.getMeter2Due(), "Meter 2 Due"));
            pmschedule.getPMScheduleData().getMETER2INTERVAL().setUOMID(new UOMID_Type());
            pmschedule.getPMScheduleData().getMETER2INTERVAL().getUOMID().setUOMCODE(pmSchedule.getMeter2UOM());
        }
        if (pmSchedule.getDateDeactivated() != null) {
            PMScheduleData pMScheduleData = pmschedule.getPMScheduleData();
            this.tools.getDataTypeTools();
            pMScheduleData.setDEACTIVATEDDATE(DataTypeTools.formatDate(pmSchedule.getDateDeactivated(), "Date Deactivated"));
        }
        if (pmSchedule.getLocation() != null) {
            pmschedule.getPMScheduleData().setLOCATIONID(new LOCATIONID_Type());
            pmschedule.getPMScheduleData().getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
            pmschedule.getPMScheduleData().getLOCATIONID().setLOCATIONCODE(pmSchedule.getLocation());
        }
        if (pmSchedule.getAssignedTo() != null) {
            pmschedule.getPMScheduleData().setASSIGNEDTO(new PERSONID_Type());
            pmschedule.getPMScheduleData().getASSIGNEDTO().setPERSONCODE(pmSchedule.getAssignedTo());
        }
        if (pmSchedule.getWorkOrderClass() != null) {
            pmschedule.getPMScheduleData().setWORKORDERCLASSID(new CLASSID_Type());
            pmschedule.getPMScheduleData().getWORKORDERCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            pmschedule.getPMScheduleData().getWORKORDERCLASSID().setCLASSCODE(pmSchedule.getWorkOrderClass());
        }
        MP0364_AddEquipmentPMSchedule_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.addEquipmentPMScheduleOp(pmschedule, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.addEquipmentPMScheduleOp(pmschedule, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return result.getResultData().getPMSCHEDULEEQUIPMENTID().getSEQUENCENUMBER() + "";
    }

    @Override
    public String deleteEquipmentPMSchedule(InforContext context, EquipmentPMSchedule pmSchedule) throws InforException {
        if (pmSchedule.getSequenceNumber() == null || pmSchedule.getRevision() == null) {
            this.tools.demandDatabaseConnection();
            try (EntityManager em = this.tools.getEntityManager();){
                EquipmentPMSchedule pmScheduleTemp = (EquipmentPMSchedule)em.createNamedQuery("FIND_PM_SCHEDULE", EquipmentPMSchedule.class).setParameter("equipmentCode", (Object)pmSchedule.getEquipmentCode()).setParameter("pmCode", (Object)pmSchedule.getPmCode()).getSingleResult();
                pmSchedule.setSequenceNumber(pmScheduleTemp.getSequenceNumber());
                pmSchedule.setRevision(pmScheduleTemp.getRevision());
                pmSchedule.setPmCode(pmScheduleTemp.getPmCode());
            }
        }
        MP7006_DeletePMScheduleEquipment_001 pmschedule = new MP7006_DeletePMScheduleEquipment_001();
        pmschedule.setPMSCHEDULEEQUIPMENTID(new PMSCHEDULEEQUIPMENTID());
        pmschedule.getPMSCHEDULEEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        pmschedule.getPMSCHEDULEEQUIPMENTID().setPPMID(new PPM_Type());
        pmschedule.getPMSCHEDULEEQUIPMENTID().getPPMID().setORGANIZATIONID(this.tools.getOrganization(context));
        pmschedule.getPMSCHEDULEEQUIPMENTID().getPPMID().setPPMCODE(pmSchedule.getPmCode());
        pmschedule.getPMSCHEDULEEQUIPMENTID().getPPMID().setPPMREVISION(Integer.parseInt(pmSchedule.getRevision()));
        pmschedule.getPMSCHEDULEEQUIPMENTID().setSEQUENCENUMBER(Long.valueOf(this.tools.getDataTypeTools().encodeLong(pmSchedule.getSequenceNumber(), "Sequence Number")));
        MP7006_DeletePMScheduleEquipment_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.deletePMScheduleEquipmentOp(pmschedule, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.deletePMScheduleEquipmentOp(pmschedule, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return result.getResultData().getPMSCHEDULEEQUIPMENTID().getSEQUENCENUMBER() + "";
    }

    @Override
    public String updateEquipmentPMSchedule(InforContext context, EquipmentPMSchedule pmSchedule) throws InforException {
        if (pmSchedule.getSequenceNumber() == null || pmSchedule.getRevision() == null) {
            this.tools.demandDatabaseConnection();
            try (EntityManager em = this.tools.getEntityManager();){
                EquipmentPMSchedule pmScheduleTemp = (EquipmentPMSchedule)em.createNamedQuery("FIND_PM_SCHEDULE", EquipmentPMSchedule.class).setParameter("equipmentCode", (Object)pmSchedule.getEquipmentCode()).setParameter("pmCode", (Object)pmSchedule.getPmCode()).getSingleResult();
                pmSchedule.setSequenceNumber(pmScheduleTemp.getSequenceNumber());
                pmSchedule.setRevision(pmScheduleTemp.getRevision());
                pmSchedule.setPmCode(pmScheduleTemp.getPmCode());
            }
        }
        MP3014_GetEquipmentPMSchedule_001 getpm = new MP3014_GetEquipmentPMSchedule_001();
        getpm.setPMSCHEDULEEQUIPMENTID(new PMSCHEDULEEQUIPMENTID());
        getpm.getPMSCHEDULEEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
        getpm.getPMSCHEDULEEQUIPMENTID().setPPMID(new PPM_Type());
        getpm.getPMSCHEDULEEQUIPMENTID().getPPMID().setORGANIZATIONID(this.tools.getOrganization(context));
        getpm.getPMSCHEDULEEQUIPMENTID().getPPMID().setPPMCODE(pmSchedule.getPmCode());
        getpm.getPMSCHEDULEEQUIPMENTID().getPPMID().setPPMREVISION((int)this.tools.getDataTypeTools().encodeLong(pmSchedule.getRevision(), "PM Schedule Revision"));
        getpm.getPMSCHEDULEEQUIPMENTID().setSEQUENCENUMBER(Long.valueOf(this.tools.getDataTypeTools().encodeLong(pmSchedule.getSequenceNumber(), "PM Schedule Sequence Number")));
        MP3014_GetEquipmentPMSchedule_001_Result getresult = null;
        getresult = context.getCredentials() != null ? this.inforws.getEquipmentPMScheduleOp(getpm, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.getEquipmentPMScheduleOp(getpm, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        PMScheduleData pmScheduleData = getresult.getResultData().getPMSchedule().getPMScheduleData();
        if (pmSchedule.getPeriodLength() != null) {
            if (pmScheduleData.getPERIODINTERVAL() == null) {
                pmScheduleData.setPERIODINTERVAL(new PERIODINTERVAL());
            }
            pmScheduleData.getPERIODINTERVAL().setINTERVAL(this.tools.getDataTypeTools().encodeLong(pmSchedule.getPeriodLength(), "Period Length"));
        }
        if (pmSchedule.getPeriodUOM() != null) {
            if (pmScheduleData.getPERIODINTERVAL() == null) {
                pmScheduleData.setPERIODINTERVAL(new PERIODINTERVAL());
            }
            pmScheduleData.getPERIODINTERVAL().setUOM(pmSchedule.getPeriodUOM());
        }
        if (pmSchedule.getDueDate() != null) {
            if (pmScheduleData.getPERIODINTERVAL() == null) {
                pmScheduleData.setPERIODINTERVAL(new PERIODINTERVAL());
            }
            PERIODINTERVAL pERIODINTERVAL = pmScheduleData.getPERIODINTERVAL();
            this.tools.getDataTypeTools();
            pERIODINTERVAL.setDUEDATE(DataTypeTools.formatDate(pmSchedule.getDueDate(), "PM Schedule Due Date"));
        }
        if (pmSchedule.getDepartmentCode() != null) {
            pmScheduleData.setDEPARTMENTID(new DEPARTMENTID_Type());
            pmScheduleData.getDEPARTMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            pmScheduleData.getDEPARTMENTID().setDEPARTMENTCODE(pmSchedule.getDepartmentCode());
        }
        if (pmSchedule.getRoute() != null && !pmSchedule.getRoute().trim().equals("")) {
            pmScheduleData.setROUTE(new ROUTE_Type());
            pmScheduleData.getROUTE().setORGANIZATIONID(this.tools.getOrganization(context));
            pmScheduleData.getROUTE().setROUTECODE(pmSchedule.getRoute());
        }
        if (pmSchedule.getScheduleType() != null) {
            pmScheduleData.setPMSCHEDULETYPE(pmSchedule.getScheduleType());
        }
        if (pmSchedule.getChanged() != null) {
            this.tools.getDataTypeTools();
            pmScheduleData.setCHANGED(DataTypeTools.encodeBoolean(pmSchedule.getChanged(), BooleanType.TRUE_FALSE));
        }
        if (pmSchedule.getSupervisor() != null) {
            pmScheduleData.setSUPERVISORID(new SUPERVISORID());
            pmScheduleData.getSUPERVISORID().setORGANIZATIONID(this.tools.getOrganization(context));
            pmScheduleData.getSUPERVISORID().setSUPERVISORCODE(pmSchedule.getSupervisor().toUpperCase());
        }
        if (pmSchedule.getCostCode() != null) {
            pmScheduleData.setCOSTCODEID(new COSTCODEID_Type());
            pmScheduleData.getCOSTCODEID().setORGANIZATIONID(this.tools.getOrganization(context));
            pmScheduleData.getCOSTCODEID().setCOSTCODE(pmSchedule.getCostCode().toUpperCase());
        }
        if (pmSchedule.getMeter1Due() != null || pmSchedule.getMeter1Interval() != null || pmSchedule.getMeter1UOM() != null) {
            pmScheduleData.setMETER1INTERVAL(new METERINTERVAL_Type());
            METERINTERVAL_Type mETERINTERVAL_Type = pmScheduleData.getMETER1INTERVAL();
            this.tools.getDataTypeTools();
            mETERINTERVAL_Type.setINTERVAL(DataTypeTools.encodeQuantity(pmSchedule.getMeter1Interval(), "Meter 1 Interval"));
            METERINTERVAL_Type mETERINTERVAL_Type2 = pmScheduleData.getMETER1INTERVAL();
            this.tools.getDataTypeTools();
            mETERINTERVAL_Type2.setREADINGDUE(DataTypeTools.encodeQuantity(pmSchedule.getMeter1Due(), "Meter 1 Due"));
            pmScheduleData.getMETER1INTERVAL().setUOMID(new UOMID_Type());
            pmScheduleData.getMETER1INTERVAL().getUOMID().setUOMCODE(pmSchedule.getMeter1UOM());
        }
        if (pmSchedule.getMeter2Due() != null || pmSchedule.getMeter2Interval() != null || pmSchedule.getMeter2UOM() != null) {
            pmScheduleData.setMETER2INTERVAL(new METERINTERVAL_Type());
            METERINTERVAL_Type mETERINTERVAL_Type = pmScheduleData.getMETER2INTERVAL();
            this.tools.getDataTypeTools();
            mETERINTERVAL_Type.setINTERVAL(DataTypeTools.encodeQuantity(pmSchedule.getMeter2Interval(), "Meter 2 Interval"));
            METERINTERVAL_Type mETERINTERVAL_Type3 = pmScheduleData.getMETER2INTERVAL();
            this.tools.getDataTypeTools();
            mETERINTERVAL_Type3.setREADINGDUE(DataTypeTools.encodeQuantity(pmSchedule.getMeter2Due(), "Meter 2 Due"));
            pmScheduleData.getMETER2INTERVAL().setUOMID(new UOMID_Type());
            pmScheduleData.getMETER2INTERVAL().getUOMID().setUOMCODE(pmSchedule.getMeter2UOM());
        }
        if (pmSchedule.getDateDeactivated() != null) {
            this.tools.getDataTypeTools();
            pmScheduleData.setDEACTIVATEDDATE(DataTypeTools.formatDate(pmSchedule.getDateDeactivated(), "Date Deactivated"));
        }
        if (pmSchedule.getLocation() != null) {
            pmScheduleData.setLOCATIONID(new LOCATIONID_Type());
            pmScheduleData.getLOCATIONID().setORGANIZATIONID(this.tools.getOrganization(context));
            pmScheduleData.getLOCATIONID().setLOCATIONCODE(pmSchedule.getLocation());
        }
        if (pmSchedule.getAssignedTo() != null) {
            pmScheduleData.setASSIGNEDTO(new PERSONID_Type());
            pmScheduleData.getASSIGNEDTO().setPERSONCODE(pmSchedule.getAssignedTo());
        }
        if (pmSchedule.getWorkOrderClass() != null) {
            pmScheduleData.setWORKORDERCLASSID(new CLASSID_Type());
            pmScheduleData.getWORKORDERCLASSID().setORGANIZATIONID(this.tools.getOrganization(context));
            pmScheduleData.getWORKORDERCLASSID().setCLASSCODE(pmSchedule.getWorkOrderClass());
        }
        MP0365_SyncEquipmentPMSchedule_001 syncpm = new MP0365_SyncEquipmentPMSchedule_001();
        syncpm.setPMScheduleData(pmScheduleData);
        MP0365_SyncEquipmentPMSchedule_001_Result syncresult = null;
        syncresult = context.getCredentials() != null ? this.inforws.syncEquipmentPMScheduleOp(syncpm, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.syncEquipmentPMScheduleOp(syncpm, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return syncresult.getResultData().getPMSCHEDULEEQUIPMENTID().getSEQUENCENUMBER() + "";
    }

    @Override
    public String updateReleasedPMSchedule(InforContext context, ReleasedPMSchedule releasedPMSchedule) throws InforException {
        MP7433_SyncReleasedPM_001 syncReleasedPM = new MP7433_SyncReleasedPM_001();
        syncReleasedPM.setReleasedPM(new ReleasedPM());
        syncReleasedPM.setPRINTALLRELEASED("false");
        this.tools.getInforFieldTools().transformWSHubObject(syncReleasedPM.getReleasedPM(), releasedPMSchedule, context);
        MP7433_SyncReleasedPM_001_Result result = null;
        result = context.getCredentials() != null ? this.inforws.syncReleasedPMOp(syncReleasedPM, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.syncReleasedPMOp(syncReleasedPM, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return "OK";
    }
}

