/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.entities;

import ch.cern.eam.wshub.core.adapters.DateAdapter;
import ch.cern.eam.wshub.core.services.entities.CustomField;
import ch.cern.eam.wshub.core.services.entities.UserDefinedFields;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@Entity
@Table(name="R5USERS")
@NamedQueries(value={@NamedQuery(name="ALL_ACTIVE_USERS", query="Select user from EAMUser user WHERE user.classCode IS NULL OR user.classCode <> '*INA'"), @NamedQuery(name="ALL_GROUP_MEMBER_USERNAMES", query="Select userCode from EAMUser user WHERE user.userGroup = :group")})
public class EAMUser
implements Serializable {
    private static final long serialVersionUID = 1149632956701915140L;
    public static final String ALL_ACTIVE_USERS = "ALL_ACTIVE_USERS";
    public static final String ALL_GROUP_MEMBER_USERNAMES = "ALL_GROUP_MEMBER_USERNAMES";
    @Id
    @Column(name="USR_CODE")
    private String userCode;
    @Column(name="USR_DESC")
    private String userDesc;
    @Column(name="USR_GROUP")
    private String userGroup;
    @Column(name="USR_EXPUSER")
    @Temporal(value=TemporalType.DATE)
    private Date userIDExpirationDate;
    @Transient
    private String password;
    @Transient
    private Date passwordExpirationDate;
    @Column(name="USR_EMAILADDRESS")
    private String emailAddress;
    @Column(name="USR_MRC")
    private String department;
    @Column(name="USR_CLASS")
    private String classCode;
    @Transient
    private CustomField[] customFields;
    @Column(name="USR_UDFCHAR01")
    private String udfchar01;
    @Column(name="USR_UDFCHAR02")
    private String udfchar02;
    @Column(name="USR_UDFCHAR03")
    private String udfchar03;
    @Column(name="USR_UDFCHAR04")
    private String udfchar04;
    @Column(name="USR_UDFCHAR05")
    private String udfchar05;
    @Column(name="USR_UDFCHAR06")
    private String udfchar06;
    @Column(name="USR_UDFCHAR07")
    private String udfchar07;
    @Column(name="USR_UDFCHAR08")
    private String udfchar08;
    @Column(name="USR_UDFCHAR09")
    private String udfchar09;
    @Transient
    private String cernId;
    @Transient
    private UserDefinedFields userDefinedFields;

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getUserDesc() {
        return this.userDesc;
    }

    public void setUserDesc(String userDesc) {
        this.userDesc = userDesc;
    }

    public String getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(String userGroup) {
        this.userGroup = userGroup;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    @XmlElementWrapper(name="customFields")
    @XmlElement(name="customField")
    public CustomField[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomField[] customFields) {
        this.customFields = customFields;
    }

    public String getClassCode() {
        return this.classCode;
    }

    public void setClassCode(String classCode) {
        this.classCode = classCode;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getUserIDExpirationDate() {
        return this.userIDExpirationDate;
    }

    public void setUserIDExpirationDate(Date userIDExpirationDate) {
        this.userIDExpirationDate = userIDExpirationDate;
    }

    @XmlJavaTypeAdapter(value=DateAdapter.class)
    public Date getPasswordExpirationDate() {
        return this.passwordExpirationDate;
    }

    public void setPasswordExpirationDate(Date passwordExpirationDate) {
        this.passwordExpirationDate = passwordExpirationDate;
    }

    public List<String> getUserDepartments() {
        LinkedList<String> userDepartments = new LinkedList<String>();
        if (this.getDepartment() != null) {
            userDepartments.add(this.getDepartment());
        }
        if (this.getUserDefinedFields() != null && this.getUserDefinedFields().getUdfchar10() != null) {
            String[] udfDepartments = this.getUserDefinedFields().getUdfchar10().replaceAll("\\s+", "").trim().split(",");
            userDepartments.addAll(Arrays.asList(udfDepartments));
        }
        Collections.sort(userDepartments);
        return userDepartments;
    }

    public String getUdfchar01() {
        return this.udfchar01;
    }

    public void setUdfchar01(String udfchar01) {
        this.udfchar01 = udfchar01;
    }

    public String getUdfchar02() {
        return this.udfchar02;
    }

    public void setUdfchar02(String udfchar02) {
        this.udfchar02 = udfchar02;
    }

    public String getUdfchar03() {
        return this.udfchar03;
    }

    public void setUdfchar03(String udfchar03) {
        this.udfchar03 = udfchar03;
    }

    public String getUdfchar04() {
        return this.udfchar04;
    }

    public void setUdfchar04(String udfchar04) {
        this.udfchar04 = udfchar04;
    }

    public String getUdfchar05() {
        return this.udfchar05;
    }

    public void setUdfchar05(String udfchar05) {
        this.udfchar05 = udfchar05;
    }

    public String getUdfchar06() {
        return this.udfchar06;
    }

    public void setUdfchar06(String udfchar06) {
        this.udfchar06 = udfchar06;
    }

    public String getUdfchar07() {
        return this.udfchar07;
    }

    public void setUdfchar07(String udfchar07) {
        this.udfchar07 = udfchar07;
    }

    public String getUdfchar08() {
        return this.udfchar08;
    }

    public void setUdfchar08(String udfchar08) {
        this.udfchar08 = udfchar08;
    }

    public String getUdfchar09() {
        return this.udfchar09;
    }

    public void setUdfchar09(String udfchar09) {
        this.udfchar09 = udfchar09;
    }

    public String getCernId() {
        return this.cernId;
    }

    public void setCernId(String cernId) {
        this.cernId = cernId;
    }

    public UserDefinedFields getUserDefinedFields() {
        return this.userDefinedFields;
    }

    public void setUserDefinedFields(UserDefinedFields userDefinedFields) {
        this.userDefinedFields = userDefinedFields;
    }

    public String toString() {
        return "EAMUser [" + (this.userCode != null ? "userCode=" + this.userCode + ", " : "") + (this.userDesc != null ? "userDesc=" + this.userDesc + ", " : "") + (this.userGroup != null ? "userGroup=" + this.userGroup + ", " : "") + (this.userIDExpirationDate != null ? "userIDExpirationDate=" + this.userIDExpirationDate + ", " : "") + (this.password != null ? "password=" + this.password + ", " : "") + (this.passwordExpirationDate != null ? "passwordExpirationDate=" + this.passwordExpirationDate + ", " : "") + (this.emailAddress != null ? "emailAddress=" + this.emailAddress + ", " : "") + (this.department != null ? "department=" + this.department + ", " : "") + (this.classCode != null ? "classCode=" + this.classCode + ", " : "") + (this.customFields != null ? "customFields=" + Arrays.toString(this.customFields) + ", " : "") + (this.udfchar01 != null ? "udfchar01=" + this.udfchar01 + ", " : "") + (this.udfchar02 != null ? "udfchar02=" + this.udfchar02 + ", " : "") + (this.udfchar03 != null ? "udfchar03=" + this.udfchar03 + ", " : "") + (this.udfchar04 != null ? "udfchar04=" + this.udfchar04 + ", " : "") + (this.udfchar05 != null ? "udfchar05=" + this.udfchar05 + ", " : "") + (this.udfchar06 != null ? "udfchar06=" + this.udfchar06 + ", " : "") + (this.udfchar07 != null ? "udfchar07=" + this.udfchar07 + ", " : "") + (this.udfchar08 != null ? "udfchar08=" + this.udfchar08 + ", " : "") + (this.udfchar09 != null ? "udfchar09=" + this.udfchar09 + ", " : "") + (this.cernId != null ? "cernId=" + this.cernId + ", " : "") + (this.userDefinedFields != null ? "userDefinedFields=" + this.userDefinedFields : "") + "]";
    }
}

