/*
 * Decompiled with CFR 0.152.
 */
package ch.cern.eam.wshub.core.services.material.impl;

import ch.cern.eam.wshub.core.client.InforContext;
import ch.cern.eam.wshub.core.services.entities.UserDefinedFields;
import ch.cern.eam.wshub.core.services.material.PartMiscService;
import ch.cern.eam.wshub.core.services.material.entities.Bin;
import ch.cern.eam.wshub.core.services.material.entities.IssueReturnPartTransaction;
import ch.cern.eam.wshub.core.services.material.entities.IssueReturnPartTransactionLine;
import ch.cern.eam.wshub.core.services.material.entities.PartAssociation;
import ch.cern.eam.wshub.core.services.material.entities.PartManufacturer;
import ch.cern.eam.wshub.core.services.material.entities.PartSubstitute;
import ch.cern.eam.wshub.core.services.material.entities.PartSupplier;
import ch.cern.eam.wshub.core.tools.ApplicationData;
import ch.cern.eam.wshub.core.tools.DataTypeTools;
import ch.cern.eam.wshub.core.tools.InforException;
import ch.cern.eam.wshub.core.tools.Tools;
import ch.cern.eam.wshub.core.tools.UserDefinedFieldsTools;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.xml.ws.Holder;
import net.datastream.schemas.mp_entities.catalogue_001.Catalogue;
import net.datastream.schemas.mp_entities.issuereturntransaction_001.IssueReturnTransaction;
import net.datastream.schemas.mp_entities.issuereturntransactionline_001.IssueReturnTransactionLine;
import net.datastream.schemas.mp_entities.issuereturntransactionline_001.IssueReturnTransactionLines;
import net.datastream.schemas.mp_entities.partsassociated_001.PartsAssociated;
import net.datastream.schemas.mp_entities.storebin_001.StoreBin;
import net.datastream.schemas.mp_entities.substitutepart_001.SubstitutePart;
import net.datastream.schemas.mp_fields.ACTIVITYCODE;
import net.datastream.schemas.mp_fields.ACTIVITYID;
import net.datastream.schemas.mp_fields.BINID_Type;
import net.datastream.schemas.mp_fields.BUDGET_Type;
import net.datastream.schemas.mp_fields.DEPARTMENTID_Type;
import net.datastream.schemas.mp_fields.EQUIPMENTID_Type;
import net.datastream.schemas.mp_fields.PARTASSOCIATEDID_Type;
import net.datastream.schemas.mp_fields.PARTID_Type;
import net.datastream.schemas.mp_fields.PERSONID_Type;
import net.datastream.schemas.mp_fields.PICKLIST_Type;
import net.datastream.schemas.mp_fields.PROJECTBUDGETID_Type;
import net.datastream.schemas.mp_fields.PROJECTID_Type;
import net.datastream.schemas.mp_fields.STOREBINID;
import net.datastream.schemas.mp_fields.STOREID_Type;
import net.datastream.schemas.mp_fields.SUBSTITUTEPART_Type;
import net.datastream.schemas.mp_fields.SUPPLIERID_Type;
import net.datastream.schemas.mp_fields.StandardUserDefinedFields;
import net.datastream.schemas.mp_fields.TRANSACTIONID_Type;
import net.datastream.schemas.mp_fields.TRANSACTIONLINEID;
import net.datastream.schemas.mp_fields.WOID_Type;
import net.datastream.schemas.mp_functions.mp0220_001.MP0220_AddIssueReturnTransaction_001;
import net.datastream.schemas.mp_functions.mp0271_001.MP0271_AddCatalogue_001;
import net.datastream.schemas.mp_functions.mp0281_001.MP0281_AddStoreBin_001;
import net.datastream.schemas.mp_functions.mp0612_001.MP0612_AddPartsAssociated_001;
import net.datastream.schemas.mp_functions.mp0614_001.MP0614_DeletePartsAssociated_001;
import net.datastream.schemas.mp_functions.mp2051_001.MP2051_AddSubstitutePart_001;
import net.datastream.schemas.mp_results.mp0220_001.MP0220_AddIssueReturnTransaction_001_Result;
import net.datastream.schemas.mp_results.mp0612_001.MP0612_AddPartsAssociated_001_Result;
import net.datastream.wsdls.inforws.InforWebServicesPT;

public class PartMiscServiceImpl
implements PartMiscService {
    private Tools tools;
    private InforWebServicesPT inforws;
    private ApplicationData applicationData;
    private UserDefinedFieldsTools userDefinedFieldsTools;

    public PartMiscServiceImpl(ApplicationData applicationData, Tools tools, InforWebServicesPT inforWebServicesToolkitClient) {
        this.applicationData = applicationData;
        this.tools = tools;
        this.inforws = inforWebServicesToolkitClient;
        this.userDefinedFieldsTools = new UserDefinedFieldsTools(tools);
    }

    @Override
    public String addPartSupplier(InforContext context, PartSupplier partSupplierParam) throws InforException {
        Catalogue catalogue = new Catalogue();
        if (partSupplierParam.getPartCode() != null) {
            catalogue.setPARTID(new PARTID_Type());
            catalogue.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            catalogue.getPARTID().setPARTCODE(partSupplierParam.getPartCode());
        }
        if (partSupplierParam.getSupplierPartDescription() != null) {
            catalogue.setSUPPLIERPARTDESCRIPTION(partSupplierParam.getSupplierPartDescription());
        }
        if (partSupplierParam.getCatalogReference() != null) {
            // empty if block
        }
        if (partSupplierParam.getGrossPrice() != null) {
            this.tools.getDataTypeTools();
            catalogue.setGROSSPRICE(DataTypeTools.encodeAmount(partSupplierParam.getGrossPrice(), "Gross Price"));
        }
        if (partSupplierParam.getMinimumOrderQty() != null) {
            this.tools.getDataTypeTools();
            catalogue.setMINIMUMQTY(DataTypeTools.encodeAmount(partSupplierParam.getMinimumOrderQty(), "Minimum Order Qty."));
        }
        if (partSupplierParam.getSupplierCode() != null) {
            catalogue.setSUPPLIERID(new SUPPLIERID_Type());
            catalogue.getSUPPLIERID().setORGANIZATIONID(this.tools.getOrganization(context));
            catalogue.getSUPPLIERID().setSUPPLIERCODE(partSupplierParam.getSupplierCode());
        }
        MP0271_AddCatalogue_001 addCatalogue = new MP0271_AddCatalogue_001();
        addCatalogue.setCatalogue(catalogue);
        if (context.getCredentials() != null) {
            this.inforws.addCatalogueOp(addCatalogue, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
        } else {
            this.inforws.addCatalogueOp(addCatalogue, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return null;
    }

    @Override
    public List<String> createIssueReturnTransaction(InforContext context, List<IssueReturnPartTransaction> issueReturnPartTransactionList) throws InforException {
        ArrayList<String> results = new ArrayList<String>();
        for (IssueReturnPartTransaction tr : issueReturnPartTransactionList) {
            results.add(this.createIssueReturnTransaction(context, tr));
        }
        return results;
    }

    @Override
    public String createIssueReturnTransaction(InforContext context, IssueReturnPartTransaction issueReturnPartTransaction) throws InforException {
        IssueReturnTransaction issueReturnTransactionInfor = new IssueReturnTransaction();
        if (issueReturnPartTransaction.getTransactionType() != null) {
            if (issueReturnPartTransaction.getTransactionType().toUpperCase().startsWith("I")) {
                issueReturnTransactionInfor.setISSUERETURNTYPE("ISSUE");
            } else {
                issueReturnTransactionInfor.setISSUERETURNTYPE("RETURN");
            }
        }
        switch (issueReturnPartTransaction.getTransactionOn()) {
            case WORKORDER: {
                if (issueReturnPartTransaction.getWorkOrderNumber() == null || issueReturnPartTransaction.getActivityCode() == null) break;
                issueReturnTransactionInfor.setACTIVITYID(new ACTIVITYID());
                issueReturnTransactionInfor.getACTIVITYID().setWORKORDERID(new WOID_Type());
                issueReturnTransactionInfor.getACTIVITYID().getWORKORDERID().setORGANIZATIONID(this.tools.getOrganization(context));
                issueReturnTransactionInfor.getACTIVITYID().getWORKORDERID().setJOBNUM(issueReturnPartTransaction.getWorkOrderNumber());
                issueReturnTransactionInfor.getACTIVITYID().setACTIVITYCODE(new ACTIVITYCODE());
                issueReturnTransactionInfor.getACTIVITYID().getACTIVITYCODE().setValue(this.tools.getDataTypeTools().encodeLong(issueReturnPartTransaction.getActivityCode(), "Activity Code"));
                break;
            }
            case PROJECT: {
                if (issueReturnPartTransaction.getProjectCode() == null || issueReturnPartTransaction.getBudgetCode() == null) break;
                issueReturnTransactionInfor.setPROJECTBUDGET(new PROJECTBUDGETID_Type());
                issueReturnTransactionInfor.getPROJECTBUDGET().setPROJECTID(new PROJECTID_Type());
                issueReturnTransactionInfor.getPROJECTBUDGET().getPROJECTID().setPROJECTCODE(issueReturnPartTransaction.getProjectCode());
                issueReturnTransactionInfor.getPROJECTBUDGET().getPROJECTID().setORGANIZATIONID(this.tools.getOrganization(context));
                issueReturnTransactionInfor.getPROJECTBUDGET().getPROJECTID().setDESCRIPTION(issueReturnPartTransaction.getProjectDesc());
                issueReturnTransactionInfor.getPROJECTBUDGET().setBUDGETID(new BUDGET_Type());
                issueReturnTransactionInfor.getPROJECTBUDGET().getBUDGETID().setBUDGETCODE(issueReturnPartTransaction.getBudgetCode());
                issueReturnTransactionInfor.getPROJECTBUDGET().getBUDGETID().setDESCRIPTION(issueReturnPartTransaction.getBudgetDesc());
                break;
            }
            case EQUIPMENT: {
                if (issueReturnPartTransaction.getEquipmentCode() == null || issueReturnPartTransaction.getEquipmentCode().trim().equals("")) break;
                issueReturnTransactionInfor.setEQUIPMENTID(new EQUIPMENTID_Type());
                issueReturnTransactionInfor.getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
                issueReturnTransactionInfor.getEQUIPMENTID().setEQUIPMENTCODE(issueReturnPartTransaction.getEquipmentCode().toUpperCase());
                break;
            }
            case EMPLOYEE: {
                if (issueReturnPartTransaction.getEmployeeCode() == null || issueReturnPartTransaction.getEmployeeCode().trim().equals("")) break;
                issueReturnTransactionInfor.setISSUETO(new PERSONID_Type());
                issueReturnTransactionInfor.getISSUETO().setPERSONCODE(issueReturnPartTransaction.getEmployeeCode().toUpperCase());
                issueReturnTransactionInfor.getISSUETO().setDESCRIPTION(issueReturnPartTransaction.getEmployeeDesc());
                break;
            }
        }
        if (issueReturnPartTransaction.getPickTicketCode() != null && !issueReturnPartTransaction.getPickTicketCode().trim().equals("")) {
            issueReturnTransactionInfor.setPICKLISTID(new PICKLIST_Type());
            issueReturnTransactionInfor.getPICKLISTID().setPICKLIST(issueReturnPartTransaction.getPickTicketCode());
        }
        if (issueReturnPartTransaction.getDepartmentCode() != null) {
            issueReturnTransactionInfor.setDEPARTMENTID(new DEPARTMENTID_Type());
            issueReturnTransactionInfor.getDEPARTMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
            issueReturnTransactionInfor.getDEPARTMENTID().setDEPARTMENTCODE(issueReturnPartTransaction.getDepartmentCode().toUpperCase());
        }
        if (issueReturnPartTransaction.getStoreCode() != null) {
            issueReturnTransactionInfor.setSTOREID(new STOREID_Type());
            issueReturnTransactionInfor.getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
            issueReturnTransactionInfor.getSTOREID().setSTORECODE(issueReturnPartTransaction.getStoreCode().toUpperCase());
        }
        issueReturnTransactionInfor.setTRANSACTIONID(new TRANSACTIONID_Type());
        issueReturnTransactionInfor.getTRANSACTIONID().setORGANIZATIONID(this.tools.getOrganization(context));
        issueReturnTransactionInfor.getTRANSACTIONID().setTRANSACTIONCODE("0");
        issueReturnTransactionInfor.setIssueReturnTransactionLines(new IssueReturnTransactionLines());
        for (IssueReturnPartTransactionLine line : issueReturnPartTransaction.getTransactionlines()) {
            IssueReturnTransactionLine issueReturnTransactionLine = new IssueReturnTransactionLine();
            if (line.getUserDefinedFields() != null) {
                UserDefinedFields udfs = line.getUserDefinedFields();
                StandardUserDefinedFields sudfs = new StandardUserDefinedFields();
                this.userDefinedFieldsTools.updateInforUserDefinedFields(sudfs, udfs);
                issueReturnTransactionLine.setStandardUserDefinedFields(sudfs);
            }
            if (line.getPartCode() != null) {
                issueReturnTransactionLine.setPARTID(new PARTID_Type());
                issueReturnTransactionLine.getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
                issueReturnTransactionLine.getPARTID().setPARTCODE(line.getPartCode().toUpperCase());
            }
            if (line.getBin() != null) {
                issueReturnTransactionLine.setBIN(line.getBin().toUpperCase());
            }
            if (line.getLot() != null) {
                issueReturnTransactionLine.setLOT(line.getLot().toUpperCase());
            } else {
                issueReturnTransactionLine.setLOT("*");
            }
            if (line.getTransactionQty() != null) {
                this.tools.getDataTypeTools();
                issueReturnTransactionLine.setTRANSACTIONQUANTITY(DataTypeTools.encodeAmount(line.getTransactionQty(), "Transaction Qty."));
            }
            if (line.getAssetIDCode() != null && !"".equals(line.getAssetIDCode().trim())) {
                issueReturnTransactionLine.setEQUIPMENTID(new EQUIPMENTID_Type());
                issueReturnTransactionLine.getEQUIPMENTID().setORGANIZATIONID(this.tools.getOrganization(context));
                issueReturnTransactionLine.getEQUIPMENTID().setEQUIPMENTCODE(line.getAssetIDCode());
            }
            issueReturnTransactionLine.setTRANSACTIONLINEID(new TRANSACTIONLINEID());
            issueReturnTransactionLine.getTRANSACTIONLINEID().setTRANSACTIONID(new TRANSACTIONID_Type());
            issueReturnTransactionLine.getTRANSACTIONLINEID().getTRANSACTIONID().setTRANSACTIONCODE("0");
            issueReturnTransactionInfor.getIssueReturnTransactionLines().getIssueReturnTransactionLine().add(issueReturnTransactionLine);
        }
        MP0220_AddIssueReturnTransaction_001_Result result = null;
        MP0220_AddIssueReturnTransaction_001 addIssueReturnTransaction = new MP0220_AddIssueReturnTransaction_001();
        addIssueReturnTransaction.setIssueReturnTransaction(issueReturnTransactionInfor);
        result = context.getCredentials() != null ? this.inforws.addIssueReturnTransactionOp(addIssueReturnTransaction, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, this.tools.createMessageConfig(), this.tools.getTenant(context)) : this.inforws.addIssueReturnTransactionOp(addIssueReturnTransaction, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), this.tools.createMessageConfig(), this.tools.getTenant(context));
        String transactId = result.getResultData().getIssueReturnTransaction().getTRANSACTIONID().getTRANSACTIONCODE();
        return transactId;
    }

    @Override
    public String createPartAssociation(InforContext context, PartAssociation partAssociation) throws InforException {
        MP0612_AddPartsAssociated_001 addpass = new MP0612_AddPartsAssociated_001();
        addpass.setPartsAssociated(new PartsAssociated());
        if (partAssociation.getPartCode() != null) {
            addpass.getPartsAssociated().setPARTID(new PARTID_Type());
            addpass.getPartsAssociated().getPARTID().setORGANIZATIONID(this.tools.getOrganization(context));
            addpass.getPartsAssociated().getPARTID().setPARTCODE(partAssociation.getPartCode().toUpperCase());
        }
        if (partAssociation.getQuantity() != null) {
            PartsAssociated partsAssociated = addpass.getPartsAssociated();
            this.tools.getDataTypeTools();
            partsAssociated.setPARTQUANTITY(DataTypeTools.encodeQuantity(partAssociation.getQuantity(), "Part Quantity"));
        }
        if (partAssociation.getUOM() != null) {
            addpass.getPartsAssociated().setUOMCODE(partAssociation.getUOM());
        }
        if (partAssociation.getAssociationEntity() != null) {
            addpass.getPartsAssociated().setENTITY(partAssociation.getAssociationEntity().toUpperCase());
        } else {
            addpass.getPartsAssociated().setENTITY("OBJ");
        }
        if (partAssociation.getEquipmentCode() != null) {
            addpass.getPartsAssociated().setPARTASSOCIATEDCODE(partAssociation.getEquipmentCode() + "#*");
        }
        addpass.getPartsAssociated().setPARTASSOCIATEDID(new PARTASSOCIATEDID_Type());
        addpass.getPartsAssociated().getPARTASSOCIATEDID().setPARTASSOCIATEDPK("0");
        addpass.getPartsAssociated().setPARTASSOCIATEDTYPE("*");
        MP0612_AddPartsAssociated_001_Result result = context.getCredentials() != null ? this.inforws.addPartsAssociatedOp(addpass, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context)) : this.inforws.addPartsAssociatedOp(addpass, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        return result.getResultData().getPartsAssociated().getPARTASSOCIATEDID().getPARTASSOCIATEDPK();
    }

    @Override
    public String deletePartAssociation(InforContext context, PartAssociation partAssociation) throws InforException {
        MP0614_DeletePartsAssociated_001 deletepass = new MP0614_DeletePartsAssociated_001();
        deletepass.setPARTASSOCIATEDID(new PARTASSOCIATEDID_Type());
        deletepass.getPARTASSOCIATEDID().setParentcode(partAssociation.getEquipmentCode() + "#*");
        try (EntityManager em = this.tools.getEntityManager();){
            deletepass.getPARTASSOCIATEDID().setPARTASSOCIATEDPK(((PartAssociation)em.createNamedQuery("GET_PART_ASSOCIATION", PartAssociation.class).setParameter("partCode", (Object)partAssociation.getPartCode()).setParameter("equipmentCode", (Object)(partAssociation.getEquipmentCode() + "#*")).getSingleResult()).getPk());
        }
        if (context.getCredentials() != null) {
            this.inforws.deletePartsAssociatedOp(deletepass, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
        } else {
            this.inforws.deletePartsAssociatedOp(deletepass, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return "OK";
    }

    @Override
    public String createPartSubstitute(InforContext context, PartSubstitute partSubstitute) throws InforException {
        MP2051_AddSubstitutePart_001 addPartSub = new MP2051_AddSubstitutePart_001();
        addPartSub.setSubstitutePart(new SubstitutePart());
        addPartSub.getSubstitutePart().setSUBSTITUTEPARTID(new SUBSTITUTEPART_Type());
        if (partSubstitute.getPartA() != null) {
            addPartSub.getSubstitutePart().getSUBSTITUTEPARTID().setPARTAID(new PARTID_Type());
            addPartSub.getSubstitutePart().getSUBSTITUTEPARTID().getPARTAID().setORGANIZATIONID(this.tools.getOrganization(context));
            addPartSub.getSubstitutePart().getSUBSTITUTEPARTID().getPARTAID().setPARTCODE(partSubstitute.getPartA().toUpperCase().trim());
        }
        if (partSubstitute.getPartB() != null) {
            addPartSub.getSubstitutePart().getSUBSTITUTEPARTID().setPARTBID(new PARTID_Type());
            addPartSub.getSubstitutePart().getSUBSTITUTEPARTID().getPARTBID().setORGANIZATIONID(this.tools.getOrganization(context));
            addPartSub.getSubstitutePart().getSUBSTITUTEPARTID().getPARTBID().setPARTCODE(partSubstitute.getPartB().toUpperCase().trim());
        }
        if (partSubstitute.getCondition() != null) {
            addPartSub.getSubstitutePart().setPARTCONDITIONTEMPLATECONDITIONCODE(partSubstitute.getCondition());
        }
        if (partSubstitute.getFullyCompatible() != null) {
            addPartSub.getSubstitutePart().setFULLYCOMPATIBLE(partSubstitute.getFullyCompatible());
        }
        if (context.getCredentials() != null) {
            this.inforws.addSubstitutePartOp(addPartSub, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
        } else {
            this.inforws.addSubstitutePartOp(addPartSub, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return "OK";
    }

    @Override
    public String addStoreBin(InforContext context, Bin binParam) throws InforException {
        StoreBin bin = new StoreBin();
        bin.setSTOREBINID(new STOREBINID());
        if (binParam.getBinCode() != null && !binParam.getBinCode().trim().equals("") && binParam.getBinDesc() != null && !binParam.getBinDesc().trim().equals("")) {
            bin.getSTOREBINID().setBINID(new BINID_Type());
            bin.getSTOREBINID().getBINID().setBIN(binParam.getBinCode().toUpperCase().trim());
            bin.getSTOREBINID().getBINID().setDESCRIPTION(binParam.getBinDesc().toUpperCase().trim());
        }
        if (binParam.getStoreCode() != null && !binParam.getStoreCode().trim().equals("")) {
            bin.getSTOREBINID().setSTOREID(new STOREID_Type());
            bin.getSTOREBINID().getSTOREID().setORGANIZATIONID(this.tools.getOrganization(context));
            bin.getSTOREBINID().getSTOREID().setSTORECODE(binParam.getStoreCode().toUpperCase().trim());
        }
        bin.setOUTOFSERVICE(binParam.getOutOfService());
        MP0281_AddStoreBin_001 storeBin = new MP0281_AddStoreBin_001();
        storeBin.setStoreBin(bin);
        if (context.getCredentials() != null) {
            this.inforws.addStoreBinOp(storeBin, this.tools.getOrganizationCode(context), this.tools.createSecurityHeader(context), "TERMINATE", null, null, this.tools.getTenant(context));
        } else {
            this.inforws.addStoreBinOp(storeBin, this.tools.getOrganizationCode(context), null, null, new Holder((Object)this.tools.createInforSession(context)), null, this.tools.getTenant(context));
        }
        return null;
    }

    @Override
    public PartManufacturer[] getPartManufacturers(InforContext context, String partCode) throws InforException {
        LinkedList<PartManufacturer> partManufacturers = new LinkedList<PartManufacturer>();
        String sqlQuery = "select r5partmfgs.mfp_part, r5partmfgs.mfp_manufacturer, r5manufacturers.mfg_desc, r5partmfgs.mfp_manufactpart, r5partmfgs.mfp_manufactdraw, r5partmfgs.mfp_primary, r5partmfgs.mfp_notused from r5partmfgs,r5manufacturers where mfp_manufacturer = mfg_code and mfp_part= '" + partCode + "'";
        Connection v_connection = null;
        Statement stmt = null;
        ResultSet v_result = null;
        try {
            v_connection = this.tools.getDataSource().getConnection();
            stmt = v_connection.createStatement();
            v_result = stmt.executeQuery(sqlQuery);
            while (v_result.next()) {
                PartManufacturer partManufacturer = new PartManufacturer();
                partManufacturer.setPartCode(v_result.getString("mfp_part"));
                partManufacturer.setManufacturerCode(v_result.getString("mfp_manufacturer"));
                partManufacturer.setManufacturerDesc(v_result.getString("mfg_desc"));
                partManufacturer.setManufacturerPartNumber(v_result.getString("mfp_manufactpart"));
                partManufacturer.setDrawingNumber(v_result.getString("mfp_manufactdraw"));
                partManufacturer.setPrimary(DataTypeTools.decodeBoolean(v_result.getString("mfp_primary")));
                partManufacturer.setOutOfService(DataTypeTools.decodeBoolean(v_result.getString("mfp_notused")));
                partManufacturers.addLast(partManufacturer);
            }
        }
        catch (Exception e) {
            throw Tools.generateFault("Couldn't read the manufacturers: " + e.getMessage());
        }
        finally {
            try {
                if (v_result != null) {
                    v_result.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (v_connection != null) {
                    v_connection.close();
                }
            }
            catch (Exception e) {
                throw Tools.generateFault("Couldn't read the manufacturers");
            }
        }
        return partManufacturers.toArray(new PartManufacturer[0]);
    }
}

